/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.parsing;

import java.io.Serializable;
import javax.net.ssl.SSLSession;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.parsing.HttpMessageParser;
import org.apache.pekko.http.impl.engine.parsing.HttpMessageParser$;
import org.apache.pekko.http.impl.engine.parsing.HttpResponseParser$OneHundredContinueError$;
import org.apache.pekko.http.impl.engine.parsing.HttpResponseParser$ResponseContext$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$EntityPart$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$MessageEnd$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$NeedNextRequestMethod$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$ResponseStart$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$StreamedEntityCreator$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$StrictEntityCreator$;
import org.apache.pekko.http.impl.engine.parsing.ParsingException;
import org.apache.pekko.http.impl.engine.parsing.package$;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.http.scaladsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.AttributeKeys$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$CloseDelimited$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Default$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.SslSessionInfo$;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength$;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Promise;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalApi
public class HttpResponseParser
implements HttpMessageParser<ParserOutput.ResponseOutput> {
    private Object org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result;
    private Function1 org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state;
    private HttpProtocol org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol;
    private Function0 completionHandling;
    private boolean terminated;
    private SSLSession org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession;
    private Tls$minusSession$minusInfo org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;
    private final ParserSettings settings;
    private final HttpHeaderParser headerParser;
    private Option<ResponseContext> contextForCurrentResponse;
    private StatusCode statusCode;

    public HttpResponseParser(ParserSettings settings, HttpHeaderParser headerParser) {
        this.settings = settings;
        this.headerParser = headerParser;
        HttpMessageParser.$init$(this);
        this.contextForCurrentResponse = None$.MODULE$;
        this.statusCode = StatusCodes$.MODULE$.OK();
    }

    @Override
    public Object org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result() {
        return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result;
    }

    @Override
    public Function1 org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state() {
        return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state;
    }

    @Override
    public HttpProtocol org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol() {
        return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol;
    }

    @Override
    public Function0 completionHandling() {
        return this.completionHandling;
    }

    @Override
    public boolean terminated() {
        return this.terminated;
    }

    @Override
    public SSLSession org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession() {
        return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession;
    }

    @Override
    public Tls$minusSession$minusInfo org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader() {
        return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;
    }

    @Override
    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result_$eq(Object x$1) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result = x$1;
    }

    @Override
    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state_$eq(Function1 x$1) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state = x$1;
    }

    @Override
    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol_$eq(HttpProtocol x$1) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol = x$1;
    }

    @Override
    public void completionHandling_$eq(Function0 x$1) {
        this.completionHandling = x$1;
    }

    @Override
    public void terminated_$eq(boolean x$1) {
        this.terminated = x$1;
    }

    @Override
    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession_$eq(SSLSession x$1) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession = x$1;
    }

    @Override
    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader_$eq(Tls$minusSession$minusInfo x$1) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader = x$1;
    }

    @Override
    public ParserSettings settings() {
        return this.settings;
    }

    @Override
    public HttpHeaderParser headerParser() {
        return this.headerParser;
    }

    @Override
    public final boolean isResponseParser() {
        return true;
    }

    public final HttpResponseParser createShallowCopy() {
        return new HttpResponseParser(this.settings(), this.headerParser().createShallowCopy());
    }

    public final void setContextForNextResponse(ResponseContext responseContext) {
        if (this.contextForCurrentResponse.isEmpty()) {
            this.contextForCurrentResponse = Some$.MODULE$.apply((Object)responseContext);
            return;
        }
    }

    public final ParserOutput.ResponseOutput onPull() {
        return (ParserOutput.ResponseOutput)this.doPull();
    }

    public final boolean onUpstreamFinish() {
        return this.shouldComplete();
    }

    @Override
    public final void emit(ParserOutput.ResponseOutput output) {
        ParserOutput.ResponseOutput responseOutput = output;
        ParserOutput$MessageEnd$ parserOutput$MessageEnd$ = ParserOutput$MessageEnd$.MODULE$;
        if (!(responseOutput != null ? !responseOutput.equals(parserOutput$MessageEnd$) : parserOutput$MessageEnd$ != null)) {
            this.contextForCurrentResponse = None$.MODULE$;
        }
        HttpMessageParser.emit$(this, output);
    }

    @Override
    public HttpMessageParser.StateResult parseMessage(ByteString input2, int offset2) {
        if (this.contextForCurrentResponse.isDefined()) {
            int cursor = this.parseProtocol(input2, offset2);
            if (package$.MODULE$.byteChar(input2, cursor) == ' ') {
                cursor = this.parseStatus(input2, cursor + 1);
                return this.parseHeaderLines(input2, cursor, this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), this.parseHeaderLines$default$5(), this.parseHeaderLines$default$6(), this.parseHeaderLines$default$7(), this.parseHeaderLines$default$8(), this.parseHeaderLines$default$9(), this.parseHeaderLines$default$10());
            }
            throw this.onBadProtocol(input2.drop(cursor));
        }
        this.emit(ParserOutput$NeedNextRequestMethod$.MODULE$);
        return this.continue(input2, offset2, (Function2 & Serializable)(input, offset) -> this.parseMessage$$anonfun$1((ByteString)input, BoxesRunTime.unboxToInt((Object)offset)));
    }

    @Override
    public final Nothing$ onBadProtocol(ByteString input) {
        throw new ParsingException("The server-side protocol or HTTP version is not supported", new StringBuilder(21).append("start of response: [").append(LogByteStringTools$.MODULE$.printByteString(input.take(16), 16, false, "")).append("]").toString());
    }

    private int parseStatus(ByteString input, int cursor) {
        if (package$.MODULE$.byteChar(input, cursor + 3) == ' ') {
            int startIdx = cursor + 4;
            int newLineIdx = this.scanNewLineIdx$1(startIdx, input, startIdx);
            this.parseStatusCode$1(input, cursor, startIdx, newLineIdx);
            return HttpResponseParser.skipNewLine$1(input, newLineIdx);
        }
        if (HttpResponseParser.isNewLine$1(input, cursor + 3)) {
            this.parseStatusCode$1(input, cursor, HttpResponseParser.parseStatusCode$default$1$1(), HttpResponseParser.parseStatusCode$default$2$1());
            return HttpResponseParser.skipNewLine$1(input, cursor + 3);
        }
        throw HttpResponseParser.badStatusCode$1();
    }

    public boolean handleInformationalResponses() {
        return true;
    }

    @Override
    public final HttpMessageParser.StateResult parseEntity(List<HttpHeader> headers, HttpProtocol protocol, ByteString input, int bodyStart, Option<Content$minusLength> clh, Option<Content$minusType> cth, boolean isChunked, boolean expect100continue, boolean hostHeaderPresent, boolean closeAfterResponseCompletion, SSLSession sslSession) {
        if (this.statusCode.allowsEntity()) {
            HttpMethod httpMethod = ((ResponseContext)this.contextForCurrentResponse.get()).requestMethod();
            HttpMethod httpMethod2 = HttpMethods$.MODULE$.HEAD();
            HttpMethod httpMethod3 = httpMethod;
            if (!(httpMethod2 != null ? !((Object)httpMethod2).equals(httpMethod3) : httpMethod3 != null)) {
                Content$minusLength content$minusLength;
                long l;
                long contentLength;
                Content$minusLength content$minusLength2;
                Option<Content$minusLength> option = clh;
                if (option instanceof Some && (content$minusLength2 = (Content$minusLength)((Some)option).value()) != null && (contentLength = (l = (content$minusLength = Content$minusLength$.MODULE$.unapply(content$minusLength2))._1())) > 0L) {
                    this.emitResponseStart$1(sslSession, closeAfterResponseCompletion, protocol, ParserOutput$StrictEntityCreator$.MODULE$.apply(HttpEntity$Default$.MODULE$.apply(this.contentType((Option)cth), contentLength, (Source<ByteString, Object>)Source$.MODULE$.empty())), HttpResponseParser.emitResponseStart$default$2$1(headers));
                    this.setCompletionHandling((Function0)HttpMessageParser$.MODULE$.CompletionOk());
                    this.emit(ParserOutput$MessageEnd$.MODULE$);
                    return this.startNewMessage(input, bodyStart);
                }
                return this.finishEmptyResponse$1(input, bodyStart, cth, sslSession, closeAfterResponseCompletion, protocol, headers);
            }
            HttpMethod httpMethod4 = HttpMethods$.MODULE$.CONNECT();
            HttpMethod httpMethod5 = httpMethod;
            if (!(httpMethod4 != null ? !((Object)httpMethod4).equals(httpMethod5) : httpMethod5 != null)) {
                return this.finishEmptyResponse$1(input, bodyStart, cth, sslSession, closeAfterResponseCompletion, protocol, headers);
            }
            if (!isChunked) {
                Content$minusLength content$minusLength;
                Option<Content$minusLength> option = clh;
                if (option instanceof Some && (content$minusLength = (Content$minusLength)((Some)option).value()) != null) {
                    Content$minusLength content$minusLength3 = Content$minusLength$.MODULE$.unapply(content$minusLength);
                    long l = content$minusLength3._1();
                    long contentLength = l;
                    if (contentLength == 0L) {
                        return this.finishEmptyResponse$1(input, bodyStart, cth, sslSession, closeAfterResponseCompletion, protocol, headers);
                    }
                    if (contentLength <= (long)(input.size() - bodyStart)) {
                        int cl = (int)contentLength;
                        this.emitResponseStart$1(sslSession, closeAfterResponseCompletion, protocol, this.strictEntity((Option)cth, input, bodyStart, cl), HttpResponseParser.emitResponseStart$default$2$1(headers));
                        this.setCompletionHandling((Function0)HttpMessageParser$.MODULE$.CompletionOk());
                        this.emit(ParserOutput$MessageEnd$.MODULE$);
                        return this.startNewMessage(input, bodyStart + cl);
                    }
                    this.emitResponseStart$1(sslSession, closeAfterResponseCompletion, protocol, this.defaultEntity((Option)cth, contentLength), HttpResponseParser.emitResponseStart$default$2$1(headers));
                    return this.parseFixedLengthBody(contentLength, closeAfterResponseCompletion, input, bodyStart);
                }
                if (None$.MODULE$.equals(option)) {
                    this.emitResponseStart$1(sslSession, closeAfterResponseCompletion, protocol, ParserOutput$StreamedEntityCreator$.MODULE$.apply((Function1 & Serializable)entityParts -> {
                        Source data = (Source)entityParts.collect((PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(ParserOutput.ResponseOutput x) {
                                ParserOutput.ResponseOutput responseOutput = x;
                                if (responseOutput instanceof ParserOutput.EntityPart) {
                                    ByteString byteString;
                                    ParserOutput.EntityPart entityPart = ParserOutput$EntityPart$.MODULE$.unapply((ParserOutput.EntityPart)responseOutput);
                                    ByteString bytes = byteString = entityPart._1();
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(ParserOutput.ResponseOutput x, Function1 function1) {
                                ParserOutput.ResponseOutput responseOutput = x;
                                if (responseOutput instanceof ParserOutput.EntityPart) {
                                    ByteString byteString;
                                    ParserOutput.EntityPart entityPart = ParserOutput$EntityPart$.MODULE$.unapply((ParserOutput.EntityPart)responseOutput);
                                    ByteString bytes = byteString = entityPart._1();
                                    return bytes;
                                }
                                return function1.apply((Object)x);
                            }
                        });
                        return HttpEntity$CloseDelimited$.MODULE$.apply(this.contentType((Option)cth), (Source<ByteString, Object>)data);
                    }), HttpResponseParser.emitResponseStart$default$2$1(headers));
                    this.setCompletionHandling((Function0)HttpMessageParser$.MODULE$.CompletionOk());
                    return this.parseToCloseBody(input, bodyStart, 0L);
                }
                throw new MatchError(option);
            }
            if (clh.isEmpty()) {
                this.emitResponseStart$1(sslSession, closeAfterResponseCompletion, protocol, this.chunkedEntity((Option)cth), headers);
                return this.parseChunk(input, bodyStart, closeAfterResponseCompletion, 0L);
            }
            return this.failMessageStart("A chunked response must not contain a Content-Length header");
        }
        return this.finishEmptyResponse$1(input, bodyStart, cth, sslSession, closeAfterResponseCompletion, protocol, headers);
    }

    private HttpMessageParser.StateResult parseToCloseBody(ByteString input, int bodyStart, long totalBytesRead) {
        long newTotalBytes = totalBytesRead + (long)scala.math.package$.MODULE$.max(0, input.length() - bodyStart);
        if (input.length() > bodyStart) {
            this.emit(ParserOutput$EntityPart$.MODULE$.apply((ByteString)input.drop(bodyStart).compact()));
        }
        return this.continue((Function2 & Serializable)(_$2, _$3) -> this.parseToCloseBody$$anonfun$1(newTotalBytes, (ByteString)_$2, BoxesRunTime.unboxToInt((Object)_$3)));
    }

    private final /* synthetic */ HttpMessageParser.StateResult parseMessage$$anonfun$1(ByteString input, int offset) {
        return this.startNewMessage(input, offset);
    }

    private static final Nothing$ badStatusCode$1() {
        throw new ParsingException("Illegal response status code");
    }

    private static final Nothing$ badStatusCodeSpecific$1(int code) {
        throw new ParsingException(new StringBuilder(30).append("Illegal response status code: ").append(code).toString());
    }

    private static final int intValue$1(ByteString input$2, int cursor$2, int offset) {
        char c = package$.MODULE$.byteChar(input$2, cursor$2 + offset);
        if (CharacterClasses$.MODULE$.DIGIT().apply(c)) {
            return c - 48;
        }
        throw HttpResponseParser.badStatusCode$1();
    }

    private static final StatusCode parseStatusCode$1$$anonfun$1(ByteString input$3, int reasonStartIdx$1, int reasonEndIdx$1, int code$1) {
        StatusCode statusCode;
        try {
            String reason = package$.MODULE$.asciiString(input$3, reasonStartIdx$1, reasonEndIdx$1);
            statusCode = StatusCodes$.MODULE$.custom(code$1, reason, StatusCodes$.MODULE$.custom$default$3());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable throwable3 = (Throwable)option.get();
            throw HttpResponseParser.badStatusCodeSpecific$1(code$1);
        }
        return statusCode;
    }

    private final void parseStatusCode$1(ByteString input$1, int cursor$1, int reasonStartIdx, int reasonEndIdx) {
        StatusCode statusCode;
        int code = HttpResponseParser.intValue$1(input$1, cursor$1, 0) * 100 + HttpResponseParser.intValue$1(input$1, cursor$1, 1) * 10 + HttpResponseParser.intValue$1(input$1, cursor$1, 2);
        int n = code;
        if (200 == n) {
            statusCode = StatusCodes$.MODULE$.OK();
        } else {
            int code2 = n;
            Option option = StatusCodes$.MODULE$.getForKey(BoxesRunTime.boxToInteger((int)code2));
            if (option instanceof Some) {
                StatusCode x = (StatusCode)((Some)option).value();
                statusCode = x;
            } else if (None$.MODULE$.equals(option)) {
                statusCode = (StatusCode)((Option)this.settings().customStatusCodes().apply((Object)BoxesRunTime.boxToInteger((int)code2))).getOrElse(() -> HttpResponseParser.parseStatusCode$1$$anonfun$1(input$1, reasonStartIdx, reasonEndIdx, code2));
            } else {
                throw new MatchError((Object)option);
            }
        }
        this.statusCode = statusCode;
    }

    private static final int parseStatusCode$default$1$1() {
        return -1;
    }

    private static final int parseStatusCode$default$2$1() {
        return -1;
    }

    private static final boolean isLF$1(ByteString input$4, int idx) {
        return package$.MODULE$.byteChar(input$4, idx) == '\n';
    }

    private static final boolean isCRLF$1(ByteString input$5, int idx) {
        return package$.MODULE$.byteChar(input$5, idx) == '\r' && HttpResponseParser.isLF$1(input$5, idx + 1);
    }

    private static final boolean isNewLine$1(ByteString input$8, int idx) {
        return HttpResponseParser.isLF$1(input$8, idx) || HttpResponseParser.isCRLF$1(input$8, idx);
    }

    private static final int skipNewLine$1(ByteString input$9, int idx) {
        if (HttpResponseParser.isCRLF$1(input$9, idx)) {
            return idx + 2;
        }
        if (HttpResponseParser.isLF$1(input$9, idx)) {
            return idx + 1;
        }
        return idx;
    }

    private final int scanNewLineIdx$1(int startIdx$1, ByteString input$6, int idx) {
        while (idx - startIdx$1 <= this.settings().maxResponseReasonLength()) {
            if (HttpResponseParser.isNewLine$1(input$6, idx)) {
                return idx;
            }
            ++idx;
        }
        throw new ParsingException(new StringBuilder(66).append("Response reason phrase exceeds the configured limit of ").append(this.settings().maxResponseReasonLength()).append(" characters").toString());
    }

    private final void emitResponseStart$1(SSLSession sslSession$1, boolean closeAfterResponseCompletion$1, HttpProtocol protocol$1, ParserOutput.EntityCreator createEntity, List headers) {
        boolean bl;
        Map map;
        if (this.settings().includeSslSessionAttribute()) {
            Object[] objectArray = new Tuple2[1];
            AttributeKey attributeKey = (AttributeKey)Predef$.MODULE$.ArrowAssoc(AttributeKeys$.MODULE$.sslSession());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)attributeKey, (Object)SslSessionInfo$.MODULE$.apply(sslSession$1));
            map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        Map attributes = map;
        Option<Promise<BoxedUnit>> option = ((ResponseContext)this.contextForCurrentResponse.get()).oneHundredContinueTrigger();
        if (None$.MODULE$.equals(option)) {
            bl = closeAfterResponseCompletion$1;
        } else if (option instanceof Some) {
            Promise promise;
            Promise trigger = promise = (Promise)((Some)option).value();
            if (this.statusCode.isSuccess()) {
                trigger.trySuccess((Object)BoxedUnit.UNIT);
                bl = closeAfterResponseCompletion$1;
            } else {
                Promise trigger2 = promise;
                trigger2.tryFailure((Throwable)HttpResponseParser$OneHundredContinueError$.MODULE$);
                bl = true;
            }
        } else {
            throw new MatchError(option);
        }
        boolean close = bl;
        this.emit(ParserOutput$ResponseStart$.MODULE$.apply(this.statusCode, protocol$1, attributes, (List<HttpHeader>)headers, createEntity, close));
    }

    private static final List emitResponseStart$default$2$1(List headers$1) {
        return headers$1;
    }

    private final HttpMessageParser.StateResult finishEmptyResponse$1(ByteString input$7, int bodyStart$1, Option cth$1, SSLSession sslSession$2, boolean closeAfterResponseCompletion$2, HttpProtocol protocol$2, List headers$2) {
        StatusCode statusCode = this.statusCode;
        if (statusCode instanceof StatusCodes.Informational && this.handleInformationalResponses()) {
            StatusCode statusCode2 = this.statusCode;
            StatusCodes.Informational informational = StatusCodes$.MODULE$.Continue();
            if (!(statusCode2 != null ? !statusCode2.equals(informational) : informational != null)) {
                ((ResponseContext)this.contextForCurrentResponse.get()).oneHundredContinueTrigger().foreach((Function1 & Serializable)_$1 -> _$1.trySuccess((Object)BoxedUnit.UNIT));
            }
            return this.startNewMessage(input$7, bodyStart$1);
        }
        this.emitResponseStart$1(sslSession$2, closeAfterResponseCompletion$2, protocol$2, this.emptyEntity(cth$1), HttpResponseParser.emitResponseStart$default$2$1(headers$2));
        this.setCompletionHandling((Function0)HttpMessageParser$.MODULE$.CompletionOk());
        this.emit(ParserOutput$MessageEnd$.MODULE$);
        return this.startNewMessage(input$7, bodyStart$1);
    }

    private final /* synthetic */ HttpMessageParser.StateResult parseToCloseBody$$anonfun$1(long newTotalBytes$1, ByteString _$2, int _$3) {
        return this.parseToCloseBody(_$2, _$3, newTotalBytes$1);
    }

    public static final class ResponseContext
    implements Product,
    Serializable {
        private final HttpMethod requestMethod;
        private final Option oneHundredContinueTrigger;

        public static ResponseContext apply(HttpMethod httpMethod, Option<Promise<BoxedUnit>> option) {
            return HttpResponseParser$ResponseContext$.MODULE$.apply(httpMethod, option);
        }

        public static ResponseContext fromProduct(Product product) {
            return HttpResponseParser$ResponseContext$.MODULE$.fromProduct(product);
        }

        public static ResponseContext unapply(ResponseContext responseContext) {
            return HttpResponseParser$ResponseContext$.MODULE$.unapply(responseContext);
        }

        public ResponseContext(HttpMethod requestMethod, Option<Promise<BoxedUnit>> oneHundredContinueTrigger) {
            this.requestMethod = requestMethod;
            this.oneHundredContinueTrigger = oneHundredContinueTrigger;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResponseContext)) return false;
            ResponseContext responseContext = (ResponseContext)object;
            HttpMethod httpMethod = this.requestMethod();
            HttpMethod httpMethod2 = responseContext.requestMethod();
            if (httpMethod == null) {
                if (httpMethod2 != null) {
                    return false;
                }
            } else if (!((Object)httpMethod).equals(httpMethod2)) return false;
            Option<Promise<BoxedUnit>> option = this.oneHundredContinueTrigger();
            Option<Promise<BoxedUnit>> option2 = responseContext.oneHundredContinueTrigger();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResponseContext;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ResponseContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "requestMethod";
            }
            if (1 == n2) {
                return "oneHundredContinueTrigger";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HttpMethod requestMethod() {
            return this.requestMethod;
        }

        public Option<Promise<BoxedUnit>> oneHundredContinueTrigger() {
            return this.oneHundredContinueTrigger;
        }

        public ResponseContext copy(HttpMethod requestMethod, Option<Promise<BoxedUnit>> oneHundredContinueTrigger) {
            return new ResponseContext(requestMethod, oneHundredContinueTrigger);
        }

        public HttpMethod copy$default$1() {
            return this.requestMethod();
        }

        public Option<Promise<BoxedUnit>> copy$default$2() {
            return this.oneHundredContinueTrigger();
        }

        public HttpMethod _1() {
            return this.requestMethod();
        }

        public Option<Promise<BoxedUnit>> _2() {
            return this.oneHundredContinueTrigger();
        }
    }
}

