/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.model.parser;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.scaladsl.model.HttpCharset;
import org.apache.pekko.http.scaladsl.model.HttpCharset$;
import org.apache.pekko.http.scaladsl.model.HttpCharsets$;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.MediaType$;
import org.apache.pekko.http.scaladsl.model.MediaType$Compressible$;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.MediaTypes$multipart$;
import scala.;
import scala.$less$colon$less$;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

@InternalApi
public interface CommonActions {
    public Function2<String, String, Option<MediaType>> customMediaTypes();

    public static MediaType getMediaType$(CommonActions $this, String mainType, String subType, boolean charsetDefined, Map params) {
        return $this.getMediaType(mainType, subType, charsetDefined, (Map<String, String>)params);
    }

    default public MediaType getMediaType(String mainType, String subType, boolean charsetDefined, Map<String, String> params) {
        String subLower = EnhancedString$.MODULE$.toRootLowerCase$extension(package$.MODULE$.enhanceString_(subType));
        String string = EnhancedString$.MODULE$.toRootLowerCase$extension(package$.MODULE$.enhanceString_(mainType));
        if ("multipart".equals(string)) {
            String string2 = subLower;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -902467812: {
                    if (!"signed".equals(string2)) break;
                    return MediaTypes$multipart$.MODULE$.signed(params);
                }
                case -196794451: {
                    if (!"alternative".equals(string2)) break;
                    return MediaTypes$multipart$.MODULE$.alternative(params);
                }
                case 103910395: {
                    if (!"mixed".equals(string2)) break;
                    return MediaTypes$multipart$.MODULE$.mixed(params);
                }
                case 1090493483: {
                    if (!"related".equals(string2)) break;
                    return MediaTypes$multipart$.MODULE$.related(params);
                }
                case 1613773252: {
                    if (!"encrypted".equals(string2)) break;
                    return MediaTypes$multipart$.MODULE$.encrypted(params);
                }
                case 1763073811: {
                    if (!"form-data".equals(string2)) break;
                    return MediaTypes$multipart$.MODULE$.form$minusdata(params);
                }
            }
            String custom = string2;
            return MediaType$.MODULE$.customMultipart(custom, params);
        }
        String mainLower = string;
        Option option = (Option)this.customMediaTypes().apply((Object)mainLower, (Object)subLower);
        if (option instanceof Some) {
            MediaType customMediaType = (MediaType)((Some)option).value();
            return CommonActions.withParams$1(params, customMediaType);
        }
        if (None$.MODULE$.equals(option)) {
            Option option2 = MediaTypes$.MODULE$.getForKey(Tuple2$.MODULE$.apply((Object)mainLower, (Object)subLower));
            if (option2 instanceof Some) {
                MediaType registered = (MediaType)((Some)option2).value();
                return CommonActions.withParams$1(params, registered);
            }
            if (None$.MODULE$.equals(option2)) {
                if (charsetDefined) {
                    return MediaType$.MODULE$.customWithOpenCharset(mainLower, subLower, MediaType$.MODULE$.customWithOpenCharset$default$3(), params, true);
                }
                MediaType$Compressible$ mediaType$Compressible$ = MediaType$Compressible$.MODULE$;
                List<String> list = MediaType$.MODULE$.customBinary$default$4();
                return MediaType$.MODULE$.customBinary(mainLower, subLower, mediaType$Compressible$, list, params, true);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public static HttpCharset getCharset$(CommonActions $this, String name) {
        return $this.getCharset(name);
    }

    default public HttpCharset getCharset(String name) {
        return (HttpCharset)HttpCharsets$.MODULE$.getForKeyCaseInsensitive(name, (.less.colon.less)$less$colon$less$.MODULE$.refl()).getOrElse(() -> CommonActions.getCharset$$anonfun$1(name));
    }

    public static boolean equalsAsciiCaseInsensitive$(CommonActions $this, String str1, String str2) {
        return $this.equalsAsciiCaseInsensitive(str1, str2);
    }

    default public boolean equalsAsciiCaseInsensitive(String str1, String str2) {
        return str1.length() == str2.length() && CommonActions.stringEquals$1(str1, str2, 0, str1.length());
    }

    private static MediaType withParams$1(Map params$1, MediaType mt) {
        if (params$1.isEmpty()) {
            return mt;
        }
        return mt.withParams((Map<String, String>)params$1);
    }

    private static HttpCharset getCharset$$anonfun$1(String name$1) {
        return HttpCharset$.MODULE$.custom(name$1, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    private static boolean stringEquals$1(String str1$1, String str2$1, int at, int length) {
        while (at < length) {
            char char2;
            char char1 = str1$1.charAt(at);
            if ((char)(char1 | (char2 = str2$1.charAt(at))) < '\u0080' && Character.toLowerCase(char1) == Character.toLowerCase(char2)) {
                ++at;
                continue;
            }
            return false;
        }
        return true;
    }
}

