/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteStringBuilder;

@InternalApi
public class CustomCharsetByteStringRendering
implements Rendering {
    private final Charset nioCharset;
    private final CharBuffer charBuffer;
    private final ByteStringBuilder builder;

    public CustomCharsetByteStringRendering(Charset nioCharset, int sizeHint) {
        this.nioCharset = nioCharset;
        this.charBuffer = CharBuffer.allocate(64);
        this.builder = new ByteStringBuilder();
        this.builder.sizeHint(sizeHint);
    }

    public ByteString get() {
        this.flushCharBuffer();
        return this.builder.result();
    }

    @Override
    public CustomCharsetByteStringRendering $tilde$tilde(char c) {
        if (!this.charBuffer.hasRemaining()) {
            this.flushCharBuffer();
        }
        this.charBuffer.put(c);
        return this;
    }

    @Override
    public CustomCharsetByteStringRendering $tilde$tilde(byte[] bytes) {
        if (bytes.length > 0) {
            this.flushCharBuffer();
            this.builder.putByteArrayUnsafe(bytes);
        }
        return this;
    }

    @Override
    public CustomCharsetByteStringRendering $tilde$tilde(ByteString bytes) {
        if (bytes.length() > 0) {
            this.flushCharBuffer();
            this.builder.$plus$plus$eq(bytes);
        }
        return this;
    }

    private void flushCharBuffer() {
        this.charBuffer.flip();
        if (this.charBuffer.hasRemaining()) {
            ByteBuffer byteBuffer = this.nioCharset.encode(this.charBuffer);
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            this.builder.putByteArrayUnsafe(bytes);
        }
        this.charBuffer.clear();
    }

    @Override
    public int mark() {
        this.flushCharBuffer();
        return this.builder.length();
    }

    @Override
    public boolean check(int mark) {
        this.flushCharBuffer();
        int origMark = mark;
        ByteString contents = this.builder.result();
        return this.rec$9(contents, origMark, mark);
    }

    private final boolean rec$9(ByteString contents$2, int origMark$4, int mark) {
        while (mark < this.builder.length()) {
            byte ch = contents$2.apply(mark);
            if (ch == 13 || ch == 10) {
                this.builder.clear();
                this.builder.append(contents$2.take(origMark$4));
                return false;
            }
            ++mark;
        }
        return true;
    }
}

