/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl;

import java.io.Serializable;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.ConnectionContext;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.ServerBuilder$;
import org.apache.pekko.http.scaladsl.ServerBuilder$Impl$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Source;
import scala.Function1;
import scala.Product;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface ServerBuilder {
    public static ServerBuilder apply(String string, int n, ClassicActorSystemProvider classicActorSystemProvider) {
        return ServerBuilder$.MODULE$.apply(string, n, classicActorSystemProvider);
    }

    public ServerBuilder onInterface(String var1);

    public ServerBuilder onPort(int var1);

    public ServerBuilder logTo(LoggingAdapter var1);

    public ServerBuilder withSettings(ServerSettings var1);

    public ServerBuilder adaptSettings(Function1<ServerSettings, ServerSettings> var1);

    public ServerBuilder enableHttps(HttpsConnectionContext var1);

    public ServerBuilder withMaterializer(Materializer var1);

    public Future<Http.ServerBinding> bind(Function1<HttpRequest, Future<HttpResponse>> var1);

    public Future<Http.ServerBinding> bindSync(Function1<HttpRequest, HttpResponse> var1);

    public Future<Http.ServerBinding> bindFlow(Flow<HttpRequest, HttpResponse, ?> var1);

    public Source<Http.IncomingConnection, Future<Http.ServerBinding>> connectionSource();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Impl
    implements ServerBuilder,
    Product,
    Serializable {
        private final String interface;
        private final int port;
        private final ConnectionContext context;
        private final LoggingAdapter log;
        private final ServerSettings settings;
        private final ClassicActorSystemProvider system;
        private final Materializer materializer;
        private final HttpExt http;

        public static Impl apply(String string, int n, ConnectionContext connectionContext, LoggingAdapter loggingAdapter, ServerSettings serverSettings, ClassicActorSystemProvider classicActorSystemProvider, Materializer materializer) {
            return ServerBuilder$Impl$.MODULE$.apply(string, n, connectionContext, loggingAdapter, serverSettings, classicActorSystemProvider, materializer);
        }

        public static Impl fromProduct(Product product) {
            return ServerBuilder$Impl$.MODULE$.fromProduct(product);
        }

        public static Impl unapply(Impl impl) {
            return ServerBuilder$Impl$.MODULE$.unapply(impl);
        }

        public Impl(String string, int port, ConnectionContext context, LoggingAdapter log, ServerSettings settings, ClassicActorSystemProvider system, Materializer materializer) {
            this.interface = string;
            this.port = port;
            this.context = context;
            this.log = log;
            this.settings = settings;
            this.system = system;
            this.materializer = materializer;
            this.http = Http$.MODULE$.apply(system.classicSystem());
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interface()));
            n = Statics.mix((int)n, (int)this.port());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.context()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.log()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.settings()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.system()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.materializer()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Impl)) return false;
            Impl impl = (Impl)object;
            if (this.port() != impl.port()) return false;
            String string = this.interface();
            String string2 = impl.interface();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            ConnectionContext connectionContext = this.context();
            ConnectionContext connectionContext2 = impl.context();
            if (connectionContext == null) {
                if (connectionContext2 != null) {
                    return false;
                }
            } else if (!connectionContext.equals(connectionContext2)) return false;
            LoggingAdapter loggingAdapter = this.log();
            LoggingAdapter loggingAdapter2 = impl.log();
            if (loggingAdapter == null) {
                if (loggingAdapter2 != null) {
                    return false;
                }
            } else if (!loggingAdapter.equals(loggingAdapter2)) return false;
            ServerSettings serverSettings = this.settings();
            ServerSettings serverSettings2 = impl.settings();
            if (serverSettings == null) {
                if (serverSettings2 != null) {
                    return false;
                }
            } else if (!serverSettings.equals(serverSettings2)) return false;
            ClassicActorSystemProvider classicActorSystemProvider = this.system();
            ClassicActorSystemProvider classicActorSystemProvider2 = impl.system();
            if (classicActorSystemProvider == null) {
                if (classicActorSystemProvider2 != null) {
                    return false;
                }
            } else if (!classicActorSystemProvider.equals(classicActorSystemProvider2)) return false;
            Materializer materializer = this.materializer();
            Materializer materializer2 = impl.materializer();
            if (materializer == null) {
                if (materializer2 != null) {
                    return false;
                }
            } else if (!materializer.equals(materializer2)) return false;
            if (!impl.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Impl;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "Impl";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "interface";
                }
                case 1: {
                    return "port";
                }
                case 2: {
                    return "context";
                }
                case 3: {
                    return "log";
                }
                case 4: {
                    return "settings";
                }
                case 5: {
                    return "system";
                }
                case 6: {
                    return "materializer";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String interface() {
            return this.interface;
        }

        public int port() {
            return this.port;
        }

        public ConnectionContext context() {
            return this.context;
        }

        public LoggingAdapter log() {
            return this.log;
        }

        public ServerSettings settings() {
            return this.settings;
        }

        public ClassicActorSystemProvider system() {
            return this.system;
        }

        public Materializer materializer() {
            return this.materializer;
        }

        @Override
        public ServerBuilder onInterface(String newInterface) {
            return this.copy(newInterface, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public ServerBuilder onPort(int newPort) {
            return this.copy(this.copy$default$1(), newPort, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public ServerBuilder logTo(LoggingAdapter newLog) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), newLog, this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public ServerBuilder withSettings(ServerSettings newSettings) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), newSettings, this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public ServerBuilder adaptSettings(Function1<ServerSettings, ServerSettings> f) {
            ServerSettings serverSettings = (ServerSettings)f.apply((Object)this.settings());
            String string = this.copy$default$1();
            int n = this.copy$default$2();
            ConnectionContext connectionContext = this.copy$default$3();
            LoggingAdapter loggingAdapter = this.copy$default$4();
            ClassicActorSystemProvider classicActorSystemProvider = this.copy$default$6();
            Materializer materializer = this.copy$default$7();
            return this.copy(string, n, connectionContext, loggingAdapter, serverSettings, classicActorSystemProvider, materializer);
        }

        @Override
        public ServerBuilder enableHttps(HttpsConnectionContext newContext) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), newContext, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public ServerBuilder withMaterializer(Materializer newMaterializer) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), newMaterializer);
        }

        @Override
        public Source<Http.IncomingConnection, Future<Http.ServerBinding>> connectionSource() {
            return this.http.bindImpl(this.interface(), this.port(), this.context(), this.settings(), this.log());
        }

        @Override
        public Future<Http.ServerBinding> bindFlow(Flow<HttpRequest, HttpResponse, ?> handlerFlow) {
            return this.http.bindAndHandleImpl(handlerFlow, this.interface(), this.port(), this.context(), this.settings(), this.log(), this.materializer());
        }

        @Override
        public Future<Http.ServerBinding> bind(Function1<HttpRequest, Future<HttpResponse>> handler) {
            return this.http.bindAndHandleAsyncImpl(handler, this.interface(), this.port(), this.context(), this.settings(), 0, this.log(), this.materializer());
        }

        @Override
        public Future<Http.ServerBinding> bindSync(Function1<HttpRequest, HttpResponse> handler) {
            return this.bind((Function1<HttpRequest, Future<HttpResponse>>)((Function1 & Serializable)arg_0 -> ServerBuilder$.org$apache$pekko$http$scaladsl$ServerBuilder$Impl$$_$bindSync$$anonfun$1(handler, arg_0)));
        }

        public Impl copy(String string, int port, ConnectionContext context, LoggingAdapter log, ServerSettings settings, ClassicActorSystemProvider system, Materializer materializer) {
            return new Impl(string, port, context, log, settings, system, materializer);
        }

        public String copy$default$1() {
            return this.interface();
        }

        public int copy$default$2() {
            return this.port();
        }

        public ConnectionContext copy$default$3() {
            return this.context();
        }

        public LoggingAdapter copy$default$4() {
            return this.log();
        }

        public ServerSettings copy$default$5() {
            return this.settings();
        }

        public ClassicActorSystemProvider copy$default$6() {
            return this.system();
        }

        public Materializer copy$default$7() {
            return this.materializer();
        }

        public String _1() {
            return this.interface();
        }

        public int _2() {
            return this.port();
        }

        public ConnectionContext _3() {
            return this.context();
        }

        public LoggingAdapter _4() {
            return this.log();
        }

        public ServerSettings _5() {
            return this.settings();
        }

        public ClassicActorSystemProvider _6() {
            return this.system();
        }

        public Materializer _7() {
            return this.materializer();
        }
    }
}

