/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import org.apache.pekko.http.impl.util.Renderable;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.impl.util.StringRendering;
import org.apache.pekko.http.scaladsl.model.DateTime$;
import scala.Option;
import scala.Product;
import scala.math.Ordered;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class DateTime
extends org.apache.pekko.http.javadsl.model.DateTime
implements Ordered<DateTime>,
Renderable,
Product,
Serializable {
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private final int weekday;
    private final long clicks;
    private final boolean isLeapYear;

    public static DateTime MaxValue() {
        return DateTime$.MODULE$.MaxValue();
    }

    public static DateTime MinValue() {
        return DateTime$.MODULE$.MinValue();
    }

    public static DateTime apply(int n, int n2, int n3, int n4, int n5, int n6) {
        return DateTime$.MODULE$.apply(n, n2, n3, n4, n5, n6);
    }

    public static DateTime apply(long l) {
        return DateTime$.MODULE$.apply(l);
    }

    public static Option<DateTime> fromIsoDateTimeString(String string) {
        return DateTime$.MODULE$.fromIsoDateTimeString(string);
    }

    public static DateTime fromProduct(Product product) {
        return DateTime$.MODULE$.fromProduct(product);
    }

    public static DateTime now() {
        return DateTime$.MODULE$.now();
    }

    public static DateTime unapply(DateTime dateTime) {
        return DateTime$.MODULE$.unapply(dateTime);
    }

    public static int apply$default$4() {
        return DateTime$.MODULE$.apply$default$4();
    }

    public static int apply$default$5() {
        return DateTime$.MODULE$.apply$default$5();
    }

    public static int apply$default$6() {
        return DateTime$.MODULE$.apply$default$6();
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, int weekday, long clicks, boolean isLeapYear) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.weekday = weekday;
        this.clicks = clicks;
        this.isLeapYear = isLeapYear;
        Ordered.$init$((Ordered)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DateTime;
    }

    public int productArity() {
        return 9;
    }

    public String productPrefix() {
        return "DateTime";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this._4());
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this._5());
            }
            case 5: {
                return BoxesRunTime.boxToInteger((int)this._6());
            }
            case 6: {
                return BoxesRunTime.boxToInteger((int)this._7());
            }
            case 7: {
                return BoxesRunTime.boxToLong((long)this._8());
            }
            case 8: {
                return BoxesRunTime.boxToBoolean((boolean)this._9());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "year";
            }
            case 1: {
                return "month";
            }
            case 2: {
                return "day";
            }
            case 3: {
                return "hour";
            }
            case 4: {
                return "minute";
            }
            case 5: {
                return "second";
            }
            case 6: {
                return "weekday";
            }
            case 7: {
                return "clicks";
            }
            case 8: {
                return "isLeapYear";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public int year() {
        return this.year;
    }

    @Override
    public int month() {
        return this.month;
    }

    @Override
    public int day() {
        return this.day;
    }

    @Override
    public int hour() {
        return this.hour;
    }

    @Override
    public int minute() {
        return this.minute;
    }

    @Override
    public int second() {
        return this.second;
    }

    @Override
    public int weekday() {
        return this.weekday;
    }

    @Override
    public long clicks() {
        return this.clicks;
    }

    @Override
    public boolean isLeapYear() {
        return this.isLeapYear;
    }

    @Override
    public String weekdayStr() {
        return DateTime$.MODULE$.weekday(this.weekday());
    }

    @Override
    public String monthStr() {
        return DateTime$.MODULE$.month(this.month() - 1);
    }

    public DateTime $plus(long millis) {
        return DateTime$.MODULE$.apply(this.clicks() + millis);
    }

    public DateTime $minus(long millis) {
        return DateTime$.MODULE$.apply(this.clicks() - millis);
    }

    @Override
    public DateTime minus(long millis) {
        return this.$minus(millis);
    }

    @Override
    public DateTime plus(long millis) {
        return this.$plus(millis);
    }

    @Override
    public <R extends Rendering> Rendering render(R r) {
        return this.renderIsoDateTimeString(r);
    }

    public String toString() {
        return this.toIsoDateTimeString();
    }

    public <R extends Rendering> Rendering renderIsoDate(R r) {
        return this.put_$hash$hash(this.put_$hash$hash(r.$tilde$tilde(this.year()).$tilde$tilde('-'), this.month()).$tilde$tilde('-'), this.day());
    }

    @Override
    public String toIsoDateString() {
        return ((StringRendering)this.renderIsoDate(new StringRendering())).get();
    }

    public <R extends Rendering> Rendering renderIsoDateTimeString(R r) {
        return this.put_$hash$hash(this.put_$hash$hash(this.put_$hash$hash(this.renderIsoDate(r).$tilde$tilde('T'), this.hour()).$tilde$tilde(':'), this.minute()).$tilde$tilde(':'), this.second());
    }

    @Override
    public String toIsoDateTimeString() {
        return ((StringRendering)this.renderIsoDateTimeString(new StringRendering())).get();
    }

    public <R extends Rendering> Rendering renderIsoLikeDateTimeString(R r) {
        return this.put_$hash$hash(this.put_$hash$hash(this.put_$hash$hash(this.renderIsoDate(r).$tilde$tilde(' '), this.hour()).$tilde$tilde(':'), this.minute()).$tilde$tilde(':'), this.second());
    }

    @Override
    public String toIsoLikeDateTimeString() {
        return ((StringRendering)this.renderIsoLikeDateTimeString(new StringRendering())).get();
    }

    public <R extends Rendering> Rendering renderRfc1123DateTimeString(R r) {
        return this.put_$hash$hash(this.put_$hash$hash(this.put_$hash$hash(this.put_$hash$hash(r.$tilde$tilde(this.weekdayStr()).$tilde$tilde(',').$tilde$tilde(' '), this.day()).$tilde$tilde(' ').$tilde$tilde(this.monthStr()).$tilde$tilde(' ').$tilde$tilde(this.year()).$tilde$tilde(' '), this.hour()).$tilde$tilde(':'), this.minute()).$tilde$tilde(':'), this.second()).$tilde$tilde(" GMT");
    }

    @Override
    public String toRfc1123DateTimeString() {
        return ((StringRendering)this.renderRfc1123DateTimeString(new StringRendering())).get();
    }

    private <R extends Rendering> Rendering put_$hash$hash(R r, int i) {
        return r.$tilde$tilde((char)(i / 10 + 48)).$tilde$tilde((char)(i % 10 + 48));
    }

    public int compare(DateTime that) {
        return (int)package$.MODULE$.signum(this.clicks() - that.clicks());
    }

    public int hashCode() {
        return Statics.longHash((long)this.clicks());
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof DateTime) {
            DateTime x = (DateTime)object;
            return x.clicks() == this.clicks();
        }
        return false;
    }

    private DateTime copy(int year, int month, int day, int hour, int minute, int second, int weekday, long clicks, boolean isLeapYear) {
        return new DateTime(year, month, day, hour, minute, second, weekday, clicks, isLeapYear);
    }

    private int copy$default$1() {
        return this.year();
    }

    private int copy$default$2() {
        return this.month();
    }

    private int copy$default$3() {
        return this.day();
    }

    private int copy$default$4() {
        return this.hour();
    }

    private int copy$default$5() {
        return this.minute();
    }

    private int copy$default$6() {
        return this.second();
    }

    private int copy$default$7() {
        return this.weekday();
    }

    private long copy$default$8() {
        return this.clicks();
    }

    private boolean copy$default$9() {
        return this.isLeapYear();
    }

    public int _1() {
        return this.year();
    }

    public int _2() {
        return this.month();
    }

    public int _3() {
        return this.day();
    }

    public int _4() {
        return this.hour();
    }

    public int _5() {
        return this.minute();
    }

    public int _6() {
        return this.second();
    }

    public int _7() {
        return this.weekday();
    }

    public long _8() {
        return this.clicks();
    }

    public boolean _9() {
        return this.isLeapYear();
    }
}

