/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.pekko.Done;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.JavaMapping;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.impl.util.JavaMapping$HttpHeader$;
import org.apache.pekko.http.impl.util.Util;
import org.apache.pekko.http.javadsl.model.ContentType;
import org.apache.pekko.http.javadsl.model.HttpMessage;
import org.apache.pekko.http.javadsl.model.headers.Authorization;
import org.apache.pekko.http.javadsl.model.headers.HttpCredentials;
import org.apache.pekko.http.scaladsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$HttpEntityScalaDSLSugar$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpHeader$;
import org.apache.pekko.http.scaladsl.model.HttpMessage$;
import org.apache.pekko.http.scaladsl.model.HttpMessage$HttpMessageScalaDSLSugar$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusEncoding;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType$;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncoding;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncodings$;
import org.apache.pekko.http.scaladsl.util.FastFuture;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.http.scaladsl.util.FastFuture$EnhancedFuture$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.SystemMaterializer;
import org.apache.pekko.stream.SystemMaterializer$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;

public interface HttpMessage
extends org.apache.pekko.http.javadsl.model.HttpMessage {
    public static DiscardedEntity AlreadyDiscardedEntity() {
        return HttpMessage$.MODULE$.AlreadyDiscardedEntity();
    }

    public static HttpMessage HttpMessageScalaDSLSugar(HttpMessage httpMessage) {
        return HttpMessage$.MODULE$.HttpMessageScalaDSLSugar(httpMessage);
    }

    public HttpMessage self();

    @Override
    public boolean isRequest();

    @Override
    public boolean isResponse();

    public Seq<HttpHeader> headers();

    public Map<AttributeKey<?>, ?> attributes();

    @Override
    public ResponseEntity entity();

    @Override
    public HttpProtocol protocol();

    public static DiscardedEntity discardEntityBytes$(HttpMessage $this, Materializer mat) {
        return $this.discardEntityBytes(mat);
    }

    @Override
    default public DiscardedEntity discardEntityBytes(Materializer mat) {
        return HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar(this.entity()), mat);
    }

    public static DiscardedEntity discardEntityBytes$(HttpMessage $this, ClassicActorSystemProvider system) {
        return $this.discardEntityBytes(system);
    }

    @Override
    default public DiscardedEntity discardEntityBytes(ClassicActorSystemProvider system) {
        return HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar(this.entity()), ((SystemMaterializer)SystemMaterializer$.MODULE$.apply(system)).materializer());
    }

    public static HttpMessage withHeaders$(HttpMessage $this, HttpHeader firstHeader, Seq otherHeaders) {
        return $this.withHeaders(firstHeader, (Seq<HttpHeader>)otherHeaders);
    }

    default public HttpMessage withHeaders(HttpHeader firstHeader, Seq<HttpHeader> otherHeaders) {
        return this.withHeaders((Seq<HttpHeader>)((Seq)otherHeaders.toList().$plus$colon((Object)firstHeader)));
    }

    public HttpMessage withHeaders(Seq<HttpHeader> var1);

    public static HttpMessage withDefaultHeaders$(HttpMessage $this, HttpHeader firstHeader, Seq otherHeaders) {
        return $this.withDefaultHeaders(firstHeader, (Seq<HttpHeader>)otherHeaders);
    }

    default public HttpMessage withDefaultHeaders(HttpHeader firstHeader, Seq<HttpHeader> otherHeaders) {
        return this.withDefaultHeaders((Seq<HttpHeader>)((Seq)otherHeaders.toList().$plus$colon((Object)firstHeader)));
    }

    public static HttpMessage withDefaultHeaders$(HttpMessage $this, Seq defaultHeaders) {
        return $this.withDefaultHeaders((Seq<HttpHeader>)defaultHeaders);
    }

    default public HttpMessage withDefaultHeaders(Seq<HttpHeader> defaultHeaders) {
        return this.withHeaders(this.headers().isEmpty() ? defaultHeaders : (Seq)defaultHeaders.foldLeft(this.headers(), (Function2 & Serializable)(acc, h) -> {
            if (this.headers().exists((Function1 & Serializable)_$1 -> _$1.is(h.lowercaseName()))) {
                return acc;
            }
            return (Seq)acc.$plus$colon(h);
        }));
    }

    public HttpMessage withAttributes(Map<AttributeKey<?>, ?> var1);

    public HttpMessage withEntity(RequestEntity var1);

    public static Future toStrict$(HttpMessage $this, FiniteDuration timeout, ExecutionContext ec, Materializer fm) {
        return $this.toStrict(timeout, ec, fm);
    }

    default public Future<HttpMessage> toStrict(FiniteDuration timeout, ExecutionContext ec, Materializer fm) {
        Future future = FastFuture$.MODULE$.EnhancedFuture(this.entity().toStrict(timeout, fm));
        Future future2 = new FastFuture(FastFuture$EnhancedFuture$.MODULE$.fast$extension(future)).future();
        return FastFuture$.MODULE$.map$extension(future2, (Function1 & Serializable)entity -> this.withEntity((RequestEntity)entity), ec);
    }

    public static Future toStrict$(HttpMessage $this, FiniteDuration timeout, long maxBytes, ExecutionContext ec, Materializer fm) {
        return $this.toStrict(timeout, maxBytes, ec, fm);
    }

    default public Future<HttpMessage> toStrict(FiniteDuration timeout, long maxBytes, ExecutionContext ec, Materializer fm) {
        Future future = FastFuture$.MODULE$.EnhancedFuture(this.entity().toStrict(timeout, maxBytes, fm));
        Future future2 = new FastFuture(FastFuture$EnhancedFuture$.MODULE$.fast$extension(future)).future();
        return FastFuture$.MODULE$.map$extension(future2, (Function1 & Serializable)entity -> this.withEntity((RequestEntity)entity), ec);
    }

    public HttpMessage withHeadersAndEntity(Seq<HttpHeader> var1, RequestEntity var2);

    public static HttpMessage mapHeaders$(HttpMessage $this, Function1 f) {
        return $this.mapHeaders((Function1<Seq<HttpHeader>, Seq<HttpHeader>>)f);
    }

    default public HttpMessage mapHeaders(Function1<Seq<HttpHeader>, Seq<HttpHeader>> f) {
        return this.withHeaders((Seq<HttpHeader>)((Seq)f.apply(this.headers())));
    }

    public static HttpMessage mapAttributes$(HttpMessage $this, Function1 f) {
        return $this.mapAttributes(f);
    }

    default public HttpMessage mapAttributes(Function1<Map<AttributeKey<?>, ?>, Map<AttributeKey<?>, ?>> f) {
        return this.withAttributes((Map)f.apply(this.attributes()));
    }

    public static HttpEncoding encoding$(HttpMessage $this) {
        return $this.encoding();
    }

    default public HttpEncoding encoding() {
        Option option = this.header(ClassTag$.MODULE$.apply(Content$minusEncoding.class));
        if (option instanceof Some) {
            Content$minusEncoding x = (Content$minusEncoding)((Some)option).value();
            return (HttpEncoding)x.encodings().head();
        }
        if (None$.MODULE$.equals(option)) {
            return HttpEncodings$.MODULE$.identity();
        }
        throw new MatchError(option);
    }

    public static Option header$(HttpMessage $this, ClassTag evidence$1) {
        return $this.header(evidence$1);
    }

    default public <T extends org.apache.pekko.http.javadsl.model.HttpHeader> Option<T> header(ClassTag<T> evidence$1) {
        Class clazz = package$.MODULE$.classTag(evidence$1).runtimeClass();
        org.apache.pekko.http.javadsl.model.HttpHeader httpHeader = HttpHeader$.MODULE$.fastFind(clazz, this.headers());
        org.apache.pekko.http.javadsl.model.HttpHeader httpHeader2 = (org.apache.pekko.http.javadsl.model.HttpHeader)OptionVal.Some$.MODULE$.unapply((Object)httpHeader);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)httpHeader2)) {
            org.apache.pekko.http.javadsl.model.HttpHeader httpHeader3;
            org.apache.pekko.http.javadsl.model.HttpHeader h = httpHeader3 = (org.apache.pekko.http.javadsl.model.HttpHeader)OptionVal$.MODULE$.get$extension((Object)httpHeader2);
            return Some$.MODULE$.apply((Object)h);
        }
        Class clazz2 = clazz;
        Class<Content$minusType> clazz3 = Content$minusType.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            return Some$.MODULE$.apply((Object)Content$minusType$.MODULE$.apply(this.entity().contentType()));
        }
        return None$.MODULE$;
    }

    public static Seq headers$(HttpMessage $this, ClassTag evidence$1) {
        return $this.headers(evidence$1);
    }

    default public <T extends org.apache.pekko.http.javadsl.model.HttpHeader> Seq<T> headers(ClassTag<T> evidence$1) {
        return (Seq)this.headers().collect((PartialFunction)new Serializable(evidence$1){
            private final ClassTag evidence$1$1;
            {
                this.evidence$1$1 = evidence$1$2;
            }

            public final boolean isDefinedAt(HttpHeader x) {
                Option option;
                HttpHeader httpHeader = x;
                if (httpHeader != null && !(option = this.evidence$1$1.unapply((Object)httpHeader)).isEmpty()) {
                    org.apache.pekko.http.javadsl.model.HttpHeader httpHeader2;
                    org.apache.pekko.http.javadsl.model.HttpHeader h = httpHeader2 = (org.apache.pekko.http.javadsl.model.HttpHeader)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(HttpHeader x, Function1 function1) {
                Option option;
                HttpHeader httpHeader = x;
                if (httpHeader != null && !(option = this.evidence$1$1.unapply((Object)httpHeader)).isEmpty()) {
                    org.apache.pekko.http.javadsl.model.HttpHeader httpHeader2;
                    org.apache.pekko.http.javadsl.model.HttpHeader h = httpHeader2 = (org.apache.pekko.http.javadsl.model.HttpHeader)option.get();
                    return h;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public static Option attribute$(HttpMessage $this, org.apache.pekko.http.javadsl.model.AttributeKey key, JavaMapping ev) {
        return $this.attribute(key, ev);
    }

    default public <T> Option<T> attribute(org.apache.pekko.http.javadsl.model.AttributeKey<T> key, JavaMapping<org.apache.pekko.http.javadsl.model.AttributeKey<T>, AttributeKey<T>> ev) {
        return this.attributes().get(ev.toScala(key)).map((Function1 & Serializable)_$2 -> _$2);
    }

    public static boolean connectionCloseExpected$(HttpMessage $this) {
        return $this.connectionCloseExpected();
    }

    default public boolean connectionCloseExpected() {
        return HttpMessage$.MODULE$.connectionCloseExpected(this.protocol(), this.header(ClassTag$.MODULE$.apply(Connection.class)));
    }

    public static HttpMessage addHeader$(HttpMessage $this, org.apache.pekko.http.javadsl.model.HttpHeader header) {
        return $this.addHeader(header);
    }

    default public HttpMessage addHeader(org.apache.pekko.http.javadsl.model.HttpHeader header) {
        HttpHeader httpHeader = (HttpHeader)header;
        return this.withHeaders((Seq<HttpHeader>)((Seq)this.headers().$plus$colon((Object)httpHeader)));
    }

    public static HttpMessage addAttribute$(HttpMessage $this, org.apache.pekko.http.javadsl.model.AttributeKey key, Object value) {
        return $this.addAttribute(key, value);
    }

    default public <T> HttpMessage addAttribute(org.apache.pekko.http.javadsl.model.AttributeKey<T> key, T value) {
        JavaMapping ev = (JavaMapping)Predef$.MODULE$.implicitly(JavaMapping$.MODULE$.attributeKey());
        return this.mapAttributes((Function1 & Serializable)_$3 -> (Map)_$3.updated(ev.toScala(key), value));
    }

    public static HttpMessage addCredentials$(HttpMessage $this, HttpCredentials credentials) {
        return $this.addCredentials(credentials);
    }

    default public HttpMessage addCredentials(HttpCredentials credentials) {
        return this.addHeader(Authorization.create(credentials));
    }

    public static HttpMessage removeHeader$(HttpMessage $this, String headerName) {
        return $this.removeHeader(headerName);
    }

    default public HttpMessage removeHeader(String headerName) {
        String lowerHeaderName = EnhancedString$.MODULE$.toRootLowerCase$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_(headerName));
        return this.withHeaders((Seq<HttpHeader>)((Seq)this.headers().filterNot((Function1 & Serializable)_$4 -> _$4.is(lowerHeaderName))));
    }

    public static HttpMessage removeAttribute$(HttpMessage $this, org.apache.pekko.http.javadsl.model.AttributeKey key) {
        return $this.removeAttribute(key);
    }

    default public HttpMessage removeAttribute(org.apache.pekko.http.javadsl.model.AttributeKey<?> key) {
        JavaMapping ev = (JavaMapping)Predef$.MODULE$.implicitly(JavaMapping$.MODULE$.AttributeKey());
        return this.mapAttributes((Function1 & Serializable)_$5 -> (Map)_$5.$minus(ev.toScala(key)));
    }

    public static HttpMessage withEntity$(HttpMessage $this, String string) {
        return $this.withEntity(string);
    }

    default public HttpMessage withEntity(String string) {
        return this.withEntity(HttpEntity$.MODULE$.apply(string));
    }

    public static HttpMessage withEntity$(HttpMessage $this, byte[] bytes) {
        return $this.withEntity(bytes);
    }

    default public HttpMessage withEntity(byte[] bytes) {
        return this.withEntity(HttpEntity$.MODULE$.apply(bytes));
    }

    public static HttpMessage withEntity$(HttpMessage $this, ByteString bytes) {
        return $this.withEntity(bytes);
    }

    default public HttpMessage withEntity(ByteString bytes) {
        return this.withEntity(HttpEntity$.MODULE$.apply(bytes));
    }

    public static HttpMessage withEntity$(HttpMessage $this, ContentType.NonBinary contentType, String string) {
        return $this.withEntity(contentType, string);
    }

    default public HttpMessage withEntity(ContentType.NonBinary contentType, String string) {
        return this.withEntity(HttpEntity$.MODULE$.apply((ContentType.NonBinary)contentType, string));
    }

    public static HttpMessage withEntity$(HttpMessage $this, org.apache.pekko.http.javadsl.model.ContentType contentType, byte[] bytes) {
        return $this.withEntity(contentType, bytes);
    }

    default public HttpMessage withEntity(org.apache.pekko.http.javadsl.model.ContentType contentType, byte[] bytes) {
        return this.withEntity(HttpEntity$.MODULE$.apply((ContentType)contentType, bytes));
    }

    public static HttpMessage withEntity$(HttpMessage $this, org.apache.pekko.http.javadsl.model.ContentType contentType, ByteString bytes) {
        return $this.withEntity(contentType, bytes);
    }

    default public HttpMessage withEntity(org.apache.pekko.http.javadsl.model.ContentType contentType, ByteString bytes) {
        return this.withEntity(HttpEntity$.MODULE$.apply((ContentType)contentType, bytes));
    }

    public static HttpMessage withEntity$(HttpMessage $this, org.apache.pekko.http.javadsl.model.ContentType contentType, File file) {
        return $this.withEntity(contentType, file);
    }

    default public HttpMessage withEntity(org.apache.pekko.http.javadsl.model.ContentType contentType, File file) {
        return this.withEntity(HttpEntity$.MODULE$.fromPath((ContentType)contentType, file.toPath(), HttpEntity$.MODULE$.fromPath$default$3()));
    }

    public static HttpMessage withEntity$(HttpMessage $this, org.apache.pekko.http.javadsl.model.ContentType contentType, Path file) {
        return $this.withEntity(contentType, file);
    }

    default public HttpMessage withEntity(org.apache.pekko.http.javadsl.model.ContentType contentType, Path file) {
        return this.withEntity(HttpEntity$.MODULE$.fromPath((ContentType)contentType, file, HttpEntity$.MODULE$.fromPath$default$3()));
    }

    public <M> HttpMessage transformEntityDataBytes(Graph<FlowShape<ByteString, ByteString>, M> var1);

    public static java.lang.Iterable getHeaders$(HttpMessage $this) {
        return $this.getHeaders();
    }

    @Override
    default public java.lang.Iterable<org.apache.pekko.http.javadsl.model.HttpHeader> getHeaders() {
        return (java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(this.headers()).asJava();
    }

    public static Optional getHeader$(HttpMessage $this, Class headerClass) {
        return $this.getHeader(headerClass);
    }

    @Override
    default public <T extends org.apache.pekko.http.javadsl.model.HttpHeader> Optional<T> getHeader(Class<T> headerClass) {
        org.apache.pekko.http.javadsl.model.HttpHeader httpHeader = HttpHeader$.MODULE$.fastFind(headerClass, this.headers());
        org.apache.pekko.http.javadsl.model.HttpHeader httpHeader2 = (org.apache.pekko.http.javadsl.model.HttpHeader)OptionVal.Some$.MODULE$.unapply((Object)httpHeader);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)httpHeader2)) {
            org.apache.pekko.http.javadsl.model.HttpHeader httpHeader3;
            org.apache.pekko.http.javadsl.model.HttpHeader h = httpHeader3 = (org.apache.pekko.http.javadsl.model.HttpHeader)OptionVal$.MODULE$.get$extension((Object)httpHeader2);
            return Optional.of(h);
        }
        return Optional.empty();
    }

    public static java.lang.Iterable getHeaders$(HttpMessage $this, Class headerClass) {
        return $this.getHeaders(headerClass);
    }

    @Override
    default public <T extends org.apache.pekko.http.javadsl.model.HttpHeader> java.lang.Iterable<T> getHeaders(Class<T> headerClass) {
        return (java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(this.headers(ClassTag$.MODULE$.apply(headerClass))).asJava();
    }

    public static Optional getHeader$(HttpMessage $this, String headerName) {
        return $this.getHeader(headerName);
    }

    @Override
    default public Optional<org.apache.pekko.http.javadsl.model.HttpHeader> getHeader(String headerName) {
        String lowerCased = EnhancedString$.MODULE$.toRootLowerCase$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_(headerName));
        return Util.convertOption(this.headers().find((Function1 & Serializable)_$6 -> _$6.is(lowerCased)));
    }

    public static HttpMessage addHeaders$(HttpMessage $this, java.lang.Iterable headers) {
        return $this.addHeaders(headers);
    }

    default public HttpMessage addHeaders(java.lang.Iterable<org.apache.pekko.http.javadsl.model.HttpHeader> headers) {
        return this.withHeaders((Seq<HttpHeader>)((Seq)this.headers().$plus$plus((IterableOnce)((Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(headers).asScala()))));
    }

    public static HttpMessage withHeaders$(HttpMessage $this, java.lang.Iterable headers) {
        return $this.withHeaders(headers);
    }

    default public HttpMessage withHeaders(java.lang.Iterable<org.apache.pekko.http.javadsl.model.HttpHeader> headers) {
        return this.withHeaders((Seq<HttpHeader>)((Seq)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(headers).asScala()).toVector().map((Function1 & Serializable)x -> JavaMapping$.MODULE$.toScala(x, JavaMapping$HttpHeader$.MODULE$))));
    }

    public static Optional getAttribute$(HttpMessage $this, org.apache.pekko.http.javadsl.model.AttributeKey attributeKey) {
        return $this.getAttribute(attributeKey);
    }

    @Override
    default public <T> Optional<T> getAttribute(org.apache.pekko.http.javadsl.model.AttributeKey<T> attributeKey) {
        return Util.convertOption(this.attribute(attributeKey, JavaMapping$.MODULE$.attributeKey()));
    }

    public static CompletionStage toStrict$(HttpMessage $this, long timeoutMillis, Executor ec, Materializer materializer) {
        return $this.toStrict(timeoutMillis, ec, materializer);
    }

    default public CompletionStage<HttpMessage> toStrict(long timeoutMillis, Executor ec, Materializer materializer) {
        ExecutionContextExecutor ex = ExecutionContext$.MODULE$.fromExecutor(ec);
        Future future = FutureConverters$.MODULE$.FutureOps(this.toStrict(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(timeoutMillis)).millis(), (ExecutionContext)ex, materializer));
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }

    public static CompletionStage toStrict$(HttpMessage $this, long timeoutMillis, long maxBytes, Executor ec, Materializer materializer) {
        return $this.toStrict(timeoutMillis, maxBytes, ec, materializer);
    }

    default public CompletionStage<HttpMessage> toStrict(long timeoutMillis, long maxBytes, Executor ec, Materializer materializer) {
        ExecutionContextExecutor ex = ExecutionContext$.MODULE$.fromExecutor(ec);
        Future future = FutureConverters$.MODULE$.FutureOps(this.toStrict(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(timeoutMillis)).millis(), maxBytes, (ExecutionContext)ex, materializer));
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }

    public static CompletionStage toStrict$(HttpMessage $this, long timeoutMillis, ClassicActorSystemProvider system) {
        return $this.toStrict(timeoutMillis, system);
    }

    default public CompletionStage<HttpMessage> toStrict(long timeoutMillis, ClassicActorSystemProvider system) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.toStrict(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(timeoutMillis)).millis(), (ExecutionContext)system.classicSystem().dispatcher(), ((SystemMaterializer)SystemMaterializer$.MODULE$.apply(system)).materializer()));
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }

    public static CompletionStage toStrict$(HttpMessage $this, long timeoutMillis, long maxBytes, ClassicActorSystemProvider system) {
        return $this.toStrict(timeoutMillis, maxBytes, system);
    }

    default public CompletionStage<HttpMessage> toStrict(long timeoutMillis, long maxBytes, ClassicActorSystemProvider system) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.toStrict(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(timeoutMillis)).millis(), maxBytes, (ExecutionContext)system.classicSystem().dispatcher(), ((SystemMaterializer)SystemMaterializer$.MODULE$.apply(system)).materializer()));
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }

    public static final class DiscardedEntity
    implements HttpMessage.DiscardedEntity {
        private final Future<Done> f;

        public DiscardedEntity(Future<Done> f) {
            this.f = f;
        }

        @Override
        public Future<Done> future() {
            return this.f;
        }

        @Override
        public CompletionStage<Done> completionStage() {
            Future future = FutureConverters$.MODULE$.FutureOps(this.f);
            return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
        }
    }

    public static final class HttpMessageScalaDSLSugar {
        private final HttpMessage httpMessage;

        public static DiscardedEntity discardEntityBytes$extension(HttpMessage httpMessage, Materializer materializer) {
            return HttpMessage$HttpMessageScalaDSLSugar$.MODULE$.discardEntityBytes$extension(httpMessage, materializer);
        }

        public static boolean equals$extension(HttpMessage httpMessage, Object object) {
            return HttpMessage$HttpMessageScalaDSLSugar$.MODULE$.equals$extension(httpMessage, object);
        }

        public static int hashCode$extension(HttpMessage httpMessage) {
            return HttpMessage$HttpMessageScalaDSLSugar$.MODULE$.hashCode$extension(httpMessage);
        }

        public HttpMessageScalaDSLSugar(HttpMessage httpMessage) {
            this.httpMessage = httpMessage;
        }

        public int hashCode() {
            return HttpMessage$HttpMessageScalaDSLSugar$.MODULE$.hashCode$extension(this.httpMessage());
        }

        public boolean equals(Object x$0) {
            return HttpMessage$HttpMessageScalaDSLSugar$.MODULE$.equals$extension(this.httpMessage(), x$0);
        }

        public HttpMessage httpMessage() {
            return this.httpMessage;
        }

        public DiscardedEntity discardEntityBytes(Materializer mat) {
            return HttpMessage$HttpMessageScalaDSLSugar$.MODULE$.discardEntityBytes$extension(this.httpMessage(), mat);
        }
    }
}

