/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Empty$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Segment$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Slash$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$Cons$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$Empty$;
import org.apache.pekko.http.scaladsl.model.UriRendering$AuthorityRenderer$;
import org.apache.pekko.http.scaladsl.model.UriRendering$HostRenderer$;
import org.apache.pekko.http.scaladsl.model.UriRendering$PathRenderer$;
import org.apache.pekko.http.scaladsl.model.UriRendering$QueryRenderer$;
import org.apache.pekko.http.scaladsl.model.UriRendering$UriRenderer$;
import org.parboiled2.CharPredicate;
import org.parboiled2.CharUtils$;
import scala.Byte$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class UriRendering$
implements Serializable {
    public static final UriRendering$HostRenderer$ HostRenderer;
    public static final UriRendering$AuthorityRenderer$ AuthorityRenderer;
    public static final UriRendering$PathRenderer$ PathRenderer;
    public static final UriRendering$QueryRenderer$ QueryRenderer;
    public static final UriRendering$UriRenderer$ UriRenderer;
    public static final UriRendering$ MODULE$;

    private UriRendering$() {
    }

    static {
        MODULE$ = new UriRendering$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UriRendering$.class);
    }

    public <R extends Rendering> Rendering renderUri(R r, Uri value, Charset charset) {
        this.renderUriWithoutFragment(r, value, charset);
        if (value.fragment().isDefined()) {
            this.encode(r.$tilde$tilde('#'), (String)value.fragment().get(), charset, CharacterClasses$.MODULE$.query$minusfragment$minuschar(), this.encode$default$5());
        }
        return r;
    }

    public <R extends Rendering> Rendering renderUriWithoutFragment(R r, Uri value, Charset charset) {
        if (value.isAbsolute()) {
            r.$tilde$tilde(value.scheme()).$tilde$tilde(':');
        }
        if (value.authority().nonEmpty()) {
            r.$tilde$tilde('/').$tilde$tilde('/');
        }
        this.renderAuthority(r, value.authority(), value.path(), value.scheme(), charset);
        this.renderPath(r, value.path(), charset, value.isRelative());
        value.rawQueryString().foreach((Function1 & Serializable)_$4 -> r.$tilde$tilde('?').$tilde$tilde((String)_$4));
        return r;
    }

    public <R extends Rendering> Rendering renderAuthority(R r, Uri.Authority authority, String scheme, Charset charset) {
        return this.renderAuthority(r, authority, Uri$Path$Empty$.MODULE$, scheme, charset);
    }

    public <R extends Rendering> Rendering renderAuthority(R r, Uri.Authority authority, Uri.Path path, String scheme, Charset charset) {
        if (authority.nonEmpty()) {
            if (!authority.userinfo().isEmpty()) {
                this.encode(r, authority.userinfo(), charset, CharacterClasses$.MODULE$.userinfo$minuschar(), this.encode$default$5()).$tilde$tilde('@');
            }
            r.$tilde$tilde((Uri.Host)authority.host(), UriRendering$HostRenderer$.MODULE$);
            if (authority.port() != 0) {
                return r.$tilde$tilde(':').$tilde$tilde(authority.port());
            }
            return r;
        }
        String string = scheme;
        if ("".equals(string) || "mailto".equals(string)) {
            return r;
        }
        if (path.isEmpty() || path.startsWithSlash()) {
            return r.$tilde$tilde('/').$tilde$tilde('/');
        }
        return r;
    }

    public <R extends Rendering> Rendering renderPath(R r, Uri.Path path, Charset charset, boolean encodeFirstSegmentColons) {
        Uri.Path path2;
        while (true) {
            if (Uri$Path$Empty$.MODULE$.equals(path2 = path)) {
                return r;
            }
            if (path2 instanceof Uri.Path.Slash) {
                Uri.Path path3;
                Uri.Path.Slash slash = Uri$Path$Slash$.MODULE$.unapply((Uri.Path.Slash)path2);
                Uri.Path tail = path3 = slash._1();
                Rendering rendering = r.$tilde$tilde('/');
                Uri.Path path4 = tail;
                boolean bl = false;
                r = rendering;
                path = path4;
                encodeFirstSegmentColons = bl;
                continue;
            }
            if (!(path2 instanceof Uri.Path.Segment)) break;
            Uri.Path.Segment segment = Uri$Path$Segment$.MODULE$.unapply((Uri.Path.Segment)path2);
            String string = segment._1();
            Uri.Path.SlashOrEmpty slashOrEmpty = segment._2();
            String head = string;
            Uri.Path.SlashOrEmpty tail = slashOrEmpty;
            CharPredicate keep = encodeFirstSegmentColons ? CharacterClasses$.MODULE$.pchar$minusbase$minusnc() : CharacterClasses$.MODULE$.pchar$minusbase();
            Rendering rendering = this.encode((Rendering)r, head, charset, keep, this.encode$default$5());
            Uri.Path.SlashOrEmpty slashOrEmpty2 = tail;
            boolean bl = false;
            r = rendering;
            path = slashOrEmpty2;
            encodeFirstSegmentColons = bl;
        }
        throw new MatchError((Object)path2);
    }

    public boolean renderPath$default$4() {
        return false;
    }

    public <R extends Rendering> Rendering renderQuery(R r, Uri.Query query, Charset charset, CharPredicate keep) {
        return this.append$3(r, query, charset, keep, query);
    }

    public <R extends Rendering> CharPredicate renderQuery$default$4() {
        return CharacterClasses$.MODULE$.strict$minusquery$minuschar$minusnp();
    }

    public Rendering encode(Rendering r, String string, Charset charset, CharPredicate keep, boolean replaceSpaces) {
        boolean asciiCompatible = this.isAsciiCompatible(charset);
        return this.rec$3(r, string, keep, replaceSpaces, asciiCompatible, charset, 0);
    }

    public boolean encode$default$5() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAsciiCompatible(Charset cs) {
        Charset charset = cs;
        Charset charset2 = package$.MODULE$.UTF8();
        if (charset == null) {
            if (charset2 == null) return true;
        } else if (((Object)charset).equals(charset2)) return true;
        Charset charset3 = cs;
        Charset charset4 = package$.MODULE$.ISO88591();
        if (charset3 == null) {
            if (charset4 == null) return true;
        } else if (((Object)charset3).equals(charset4)) return true;
        Charset charset5 = cs;
        Charset charset6 = package$.MODULE$.ASCII();
        if (charset5 != null) {
            if (!((Object)charset5).equals(charset6)) return false;
            return true;
        }
        if (charset6 == null) return true;
        return false;
    }

    private final void enc$1(Rendering r$2, Charset charset$3, CharPredicate keep$1, String s2) {
        this.encode(r$2, s2, charset$3, keep$1, true);
    }

    private final Rendering append$3(Rendering r$3, Uri.Query query$1, Charset charset$4, CharPredicate keep$2, Uri.Query q) {
        Uri.Query query;
        while (true) {
            if (((Object)Uri$Query$Empty$.MODULE$).equals(query = q)) {
                return r$3;
            }
            if (!(query instanceof Uri.Query.Cons)) break;
            Uri.Query.Cons cons = Uri$Query$Cons$.MODULE$.unapply((Uri.Query.Cons)query);
            String string = cons._1();
            String string2 = cons._2();
            Uri.Query query2 = cons._3();
            String key = string;
            String value = string2;
            Uri.Query tail = query2;
            if (q != query$1) {
                r$3.$tilde$tilde('&');
            }
            this.enc$1(r$3, charset$4, keep$2, key);
            if (value != Uri$Query$.MODULE$.EmptyValue()) {
                r$3.$tilde$tilde('=');
            }
            this.enc$1(r$3, charset$4, keep$2, value);
            q = tail;
        }
        throw new MatchError((Object)query);
    }

    private final void appendEncoded$1(Rendering r$5, byte by) {
        r$5.$tilde$tilde('%').$tilde$tilde(CharUtils$.MODULE$.upperHexDigit(by >>> 4)).$tilde$tilde(CharUtils$.MODULE$.upperHexDigit(Byte$.MODULE$.byte2int(by)));
    }

    private final /* synthetic */ void append$4$$anonfun$1(Rendering r$7, byte by) {
        this.appendEncoded$1(r$7, by);
    }

    private final void append$4(Charset charset$6, Rendering r$6, String s2) {
        Object object = Predef$.MODULE$.byteArrayOps(s2.getBytes(charset$6));
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)v1 -> {
            this.append$4$$anonfun$1(r$6, BoxesRunTime.unboxToByte((Object)v1));
            return BoxedUnit.UNIT;
        });
    }

    private final Rendering rec$3(Rendering r$4, String string$6, CharPredicate keep$3, boolean replaceSpaces$1, boolean asciiCompatible$1, Charset charset$5, int ix) {
        while (ix < string$6.length()) {
            int n;
            char c = string$6.charAt(ix);
            char c2 = c;
            if (keep$3.apply(c2)) {
                r$4.$tilde$tilde(c2);
                n = 1;
            } else if (' ' == c && replaceSpaces$1) {
                r$4.$tilde$tilde('+');
                n = 1;
            } else {
                char c3 = c;
                if (c3 <= '\u007f' && asciiCompatible$1) {
                    this.appendEncoded$1(r$4, (byte)c3);
                    n = 1;
                } else {
                    char c4 = c;
                    if (Character.isHighSurrogate(c4)) {
                        this.append$4(charset$5, r$4, new String(new int[]{string$6.codePointAt(ix)}, 0, 1));
                        n = 2;
                    } else {
                        this.append$4(charset$5, r$4, BoxesRunTime.boxToCharacter((char)c4).toString());
                        n = 1;
                    }
                }
            }
            int charSize = n;
            ix += charSize;
        }
        return r$4;
    }
}

