/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model.sse;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.pekko.http.scaladsl.model.sse.ServerSentEvent$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.OptionConverters;
import org.apache.pekko.util.OptionConverters$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.OptionShape$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class ServerSentEvent
extends org.apache.pekko.http.javadsl.model.sse.ServerSentEvent
implements Product,
Serializable {
    private final String data;
    private final Option eventType;
    private final Option id;
    private final Option retry;

    public static ServerSentEvent apply(String string, int n) {
        return ServerSentEvent$.MODULE$.apply(string, n);
    }

    public static ServerSentEvent apply(String string, Option<String> option, Option<String> option2, Option<Object> option3) {
        return ServerSentEvent$.MODULE$.apply(string, option, option2, option3);
    }

    public static ServerSentEvent apply(String string, String string2) {
        return ServerSentEvent$.MODULE$.apply(string, string2);
    }

    public static ServerSentEvent apply(String string, String string2, String string3) {
        return ServerSentEvent$.MODULE$.apply(string, string2, string3);
    }

    public static ServerSentEvent fromProduct(Product product) {
        return ServerSentEvent$.MODULE$.fromProduct(product);
    }

    public static ServerSentEvent heartbeat() {
        return ServerSentEvent$.MODULE$.heartbeat();
    }

    public static ServerSentEvent unapply(ServerSentEvent serverSentEvent) {
        return ServerSentEvent$.MODULE$.unapply(serverSentEvent);
    }

    public static Option<String> $lessinit$greater$default$2() {
        return ServerSentEvent$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return ServerSentEvent$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Object> $lessinit$greater$default$4() {
        return ServerSentEvent$.MODULE$.$lessinit$greater$default$4();
    }

    public ServerSentEvent(String data, Option<String> eventType, Option<String> id, Option<Object> retry) {
        this.data = data;
        this.eventType = eventType;
        this.id = id;
        this.retry = retry;
        Predef$.MODULE$.require(eventType.forall((Function1 & Serializable)s2 -> ServerSentEvent$.MODULE$.org$apache$pekko$http$scaladsl$model$sse$ServerSentEvent$$$noNewLine((String)s2)), ServerSentEvent::$init$$$anonfun$2);
        Predef$.MODULE$.require(id.forall((Function1 & Serializable)s2 -> ServerSentEvent$.MODULE$.org$apache$pekko$http$scaladsl$model$sse$ServerSentEvent$$$noNewLine((String)s2)), ServerSentEvent::$init$$$anonfun$4);
        Predef$.MODULE$.require(retry.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> _$1 > 0), ServerSentEvent::$init$$$anonfun$6);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ServerSentEvent)) return false;
        ServerSentEvent serverSentEvent = (ServerSentEvent)object;
        String string = this.data();
        String string2 = serverSentEvent.data();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option = this.eventType();
        Option<String> option2 = serverSentEvent.eventType();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.id();
        Option<String> option4 = serverSentEvent.id();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Object> option5 = this.retry();
        Option<Object> option6 = serverSentEvent.retry();
        if (option5 == null) {
            if (option6 == null) return true;
            return false;
        } else {
            if (!option5.equals(option6)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ServerSentEvent;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "ServerSentEvent";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "data";
            }
            case 1: {
                return "eventType";
            }
            case 2: {
                return "id";
            }
            case 3: {
                return "retry";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String data() {
        return this.data;
    }

    public Option<String> eventType() {
        return this.eventType;
    }

    public Option<String> id() {
        return this.id;
    }

    public Option<Object> retry() {
        return this.retry;
    }

    public ByteString encode() {
        return ByteString$.MODULE$.apply(this.s$2(), StandardCharsets.UTF_8.name());
    }

    @Override
    public String getData() {
        return this.data();
    }

    @Override
    public Optional<String> getEventType() {
        Option option = OptionConverters$.MODULE$.RichOption(this.eventType());
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    @Override
    public Optional<String> getId() {
        Option option = OptionConverters$.MODULE$.RichOption(this.id());
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    @Override
    public OptionalInt getRetry() {
        Option option = OptionConverters$.MODULE$.RichOption(this.retry());
        return (OptionalInt)OptionConverters.RichOption$.MODULE$.toJavaPrimitive$extension(option, OptionShape$.MODULE$.intOptionShape());
    }

    public ServerSentEvent copy(String data, Option<String> eventType, Option<String> id, Option<Object> retry) {
        return new ServerSentEvent(data, eventType, id, retry);
    }

    public String copy$default$1() {
        return this.data();
    }

    public Option<String> copy$default$2() {
        return this.eventType();
    }

    public Option<String> copy$default$3() {
        return this.id();
    }

    public Option<Object> copy$default$4() {
        return this.retry();
    }

    public String _1() {
        return this.data();
    }

    public Option<String> _2() {
        return this.eventType();
    }

    public Option<String> _3() {
        return this.id();
    }

    public Option<Object> _4() {
        return this.retry();
    }

    private static final Object $init$$$anonfun$2() {
        return "eventType must not contain \\n or \\r!";
    }

    private static final Object $init$$$anonfun$4() {
        return "id must not contain \\n or \\r!";
    }

    private static final Object $init$$$anonfun$6() {
        return "retry must be a positive number!";
    }

    private static final int $anonfun$1() {
        return 0;
    }

    private static final int $anonfun$3() {
        return 0;
    }

    private static final int $anonfun$5() {
        return 0;
    }

    private static final int addLine$1(String s$1, StringBuilder builder$1, int index) {
        while (index < s$1.length()) {
            char c = s$1.charAt(index);
            builder$1.append(c);
            if (c == '\n') {
                return index + 1;
            }
            ++index;
        }
        return -1;
    }

    private static final void appendData$1(StringBuilder builder$2, String s2, int index) {
        while (true) {
            int i;
            builder$2.append("data:");
            int n = ServerSentEvent.addLine$1(s2, builder$2, index);
            if (-1 == n) {
                builder$2.append('\n');
                return;
            }
            index = i = n;
        }
    }

    private static final int appendData$default$2$1() {
        return 0;
    }

    private final String s$2() {
        StringBuilder builder = new StringBuilder(ServerSentEvent$.MODULE$.org$apache$pekko$http$scaladsl$model$sse$ServerSentEvent$$$nextPowerOfTwoBiggerThan(8 + this.data().length() + BoxesRunTime.unboxToInt((Object)this.eventType().fold(ServerSentEvent::$anonfun$1, (Function1 & Serializable)_$2 -> _$2.length() + 7)) + BoxesRunTime.unboxToInt((Object)this.id().fold(ServerSentEvent::$anonfun$3, (Function1 & Serializable)_$3 -> _$3.length() + 4)) + BoxesRunTime.unboxToInt((Object)this.retry().fold(ServerSentEvent::$anonfun$5, (Function1)(JFunction1.mcII.sp & Serializable)_$4 -> 17))));
        ServerSentEvent.appendData$1(builder, this.data(), ServerSentEvent.appendData$default$2$1());
        if (this.eventType().isDefined() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)this.eventType().get()))) {
            builder.append("event:").append((String)this.eventType().get()).append('\n');
        }
        if (this.id().isDefined()) {
            builder.append("id:").append((String)this.id().get()).append('\n');
        }
        if (this.retry().isDefined()) {
            builder.append("retry:").append(BoxesRunTime.unboxToInt((Object)this.retry().get())).append('\n');
        }
        return builder.append('\n').toString();
    }
}

