/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.coding.Coder;
import org.apache.pekko.http.scaladsl.coding.Coders$;
import org.apache.pekko.http.scaladsl.coding.Decoder;
import org.apache.pekko.http.scaladsl.coding.Encoder;
import org.apache.pekko.http.scaladsl.model.ErrorInfo$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.IllegalRequestException$;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusEncoding$;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncoding;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncodings$;
import org.apache.pekko.http.scaladsl.server.ConjunctionMagnet$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directive$SingleValueTransformers$;
import org.apache.pekko.http.scaladsl.server.EncodingNegotiator$;
import org.apache.pekko.http.scaladsl.server.Rejection;
import org.apache.pekko.http.scaladsl.server.StandardRoute$;
import org.apache.pekko.http.scaladsl.server.UnacceptedResponseEncodingRejection$;
import org.apache.pekko.http.scaladsl.server.UnsupportedRequestEncodingRejection;
import org.apache.pekko.http.scaladsl.server.UnsupportedRequestEncodingRejection$;
import org.apache.pekko.http.scaladsl.server.directives.BasicDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.CodingDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.MiscDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.RouteDirectives$;
import org.apache.pekko.http.scaladsl.server.util.Tuple$;
import org.apache.pekko.http.scaladsl.server.util.TupleOps$Join$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Flow$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public interface CodingDirectives {
    public static Seq<Coder> DefaultCoders() {
        return CodingDirectives$.MODULE$.DefaultCoders();
    }

    public static Seq<Coder> DefaultEncodeResponseEncoders() {
        return CodingDirectives$.MODULE$.DefaultEncodeResponseEncoders();
    }

    public static <T> Seq<T> theseOrDefault(Seq<T> seq) {
        return CodingDirectives$.MODULE$.theseOrDefault(seq);
    }

    public static Directive responseEncodingAccepted$(CodingDirectives $this, HttpEncoding encoding) {
        return $this.responseEncodingAccepted(encoding);
    }

    default public Directive<BoxedUnit> responseEncodingAccepted(HttpEncoding encoding) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequest());
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)request -> {
            if (EncodingNegotiator$.MODULE$.apply((Seq<HttpHeader>)request.headers()).isAccepted(encoding)) {
                return BasicDirectives$.MODULE$.pass();
            }
            return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{UnacceptedResponseEncodingRejection$.MODULE$.apply((Set<HttpEncoding>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpEncoding[]{encoding}))))})), Tuple$.MODULE$.forUnit());
        }, Tuple$.MODULE$.forUnit());
    }

    public static Directive encodeResponse$(CodingDirectives $this) {
        return $this.encodeResponse();
    }

    default public Directive<BoxedUnit> encodeResponse() {
        return CodingDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$CodingDirectives$$$_encodeResponse(CodingDirectives$.MODULE$.DefaultEncodeResponseEncoders());
    }

    public static Directive encodeResponseWith$(CodingDirectives $this, Encoder first, Seq more) {
        return $this.encodeResponseWith(first, (Seq<Encoder>)more);
    }

    default public Directive<BoxedUnit> encodeResponseWith(Encoder first, Seq<Encoder> more) {
        return CodingDirectives$.MODULE$.org$apache$pekko$http$scaladsl$server$directives$CodingDirectives$$$_encodeResponse((Seq<Encoder>)((Seq)Seq$.MODULE$.apply((Seq)more.$plus$colon((Object)first))));
    }

    public static Directive decodeRequestWith$(CodingDirectives $this, Decoder decoder) {
        return $this.decodeRequestWith(decoder);
    }

    default public Directive<BoxedUnit> decodeRequestWith(Decoder decoder) {
        return MiscDirectives$.MODULE$.requestEntityEmpty().$bar((Directive)((Directive)this.requestEncodedWith(decoder.encoding()).$amp(ConjunctionMagnet$.MODULE$.fromDirective(CodingDirectives.applyDecoder$1(decoder), TupleOps$Join$.MODULE$.join0P()))).$amp(ConjunctionMagnet$.MODULE$.fromDirective(BasicDirectives$.MODULE$.cancelRejections((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{UnsupportedRequestEncodingRejection.class})), TupleOps$Join$.MODULE$.join0P())));
    }

    public static Directive requestEncodedWith$(CodingDirectives $this, HttpEncoding encoding) {
        return $this.requestEncodedWith(encoding);
    }

    default public Directive<BoxedUnit> requestEncodedWith(HttpEncoding encoding) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extract((Function1 & Serializable)_$1 -> _$1.request().encoding()));
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)x$1 -> {
            HttpEncoding httpEncoding = x$1;
            HttpEncoding httpEncoding2 = encoding;
            HttpEncoding httpEncoding3 = httpEncoding;
            if (!(httpEncoding2 != null ? !httpEncoding2.equals(httpEncoding3) : httpEncoding3 != null)) {
                return BasicDirectives$.MODULE$.pass();
            }
            return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{UnsupportedRequestEncodingRejection$.MODULE$.apply(encoding)})), Tuple$.MODULE$.forUnit());
        }, Tuple$.MODULE$.forUnit());
    }

    public static Directive decodeRequestWith$(CodingDirectives $this, Seq decoders) {
        return $this.decodeRequestWith((Seq<Decoder>)decoders);
    }

    default public Directive<BoxedUnit> decodeRequestWith(Seq<Decoder> decoders) {
        return (Directive)((IterableOnceOps)CodingDirectives$.MODULE$.theseOrDefault(decoders).map((Function1 & Serializable)decoder -> this.decodeRequestWith((Decoder)decoder))).reduce((Function2 & Serializable)(_$2, _$3) -> _$2.$bar(_$3));
    }

    public static Directive decodeRequest$(CodingDirectives $this) {
        return $this.decodeRequest();
    }

    default public Directive<BoxedUnit> decodeRequest() {
        return this.decodeRequestWith(CodingDirectives$.MODULE$.DefaultCoders());
    }

    public static Directive withPrecompressedMediaTypeSupport$(CodingDirectives $this) {
        return $this.withPrecompressedMediaTypeSupport();
    }

    default public Directive<BoxedUnit> withPrecompressedMediaTypeSupport() {
        return BasicDirectives$.MODULE$.mapResponse((Function1 & Serializable)response -> {
            MediaType.Compressibility compressibility = response.entity().contentType().mediaType().comp();
            MediaType.Gzipped$ gzipped$ = MediaType.Gzipped$.MODULE$;
            if (compressibility == null ? gzipped$ != null : !compressibility.equals(gzipped$)) {
                return response;
            }
            return (HttpResponse)response.withDefaultHeaders((HttpHeader)Content$minusEncoding$.MODULE$.apply(HttpEncodings$.MODULE$.gzip(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpEncoding[0])), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpHeader[0]));
        });
    }

    private static Directive applyDecoder$1(Decoder decoder$1) {
        Decoder decoder = decoder$1;
        Coder coder = Coders$.MODULE$.NoCoding();
        if (!(decoder != null ? !decoder.equals(coder) : coder != null)) {
            return BasicDirectives$.MODULE$.pass();
        }
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractSettings());
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)settings -> {
            Decoder effectiveDecoder = decoder$1.withMaxBytesPerChunk(settings.decodeMaxBytesPerChunk());
            return (Directive)BasicDirectives$.MODULE$.mapRequest((Function1 & Serializable)msg -> ((HttpRequest)effectiveDecoder.decodeMessage((HttpMessage)msg)).transformEntityDataBytes((Graph)Flow$.MODULE$.apply().mapError((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Option option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2;
                        Throwable e = throwable2 = (Throwable)option.get();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Option option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2;
                        Throwable e = throwable2 = (Throwable)option.get();
                        return IllegalRequestException$.MODULE$.apply(StatusCodes$.MODULE$.BadRequest(), ErrorInfo$.MODULE$.apply("The request's encoding is corrupt", e.getMessage()));
                    }
                    return function1.apply((Object)x);
                }
            }))).$amp(ConjunctionMagnet$.MODULE$.fromDirective(MiscDirectives$.MODULE$.withSizeLimit(settings.decodeMaxSize()), TupleOps$Join$.MODULE$.join0P()));
        }, Tuple$.MODULE$.forUnit());
    }
}

