/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.nw;

import java.io.Serializable;
import org.apache.commons.collections15.Transformer;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet$;
import org.nlogo.agent.IndexedAgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.core.AgentKind;
import org.nlogo.core.I18N$;
import org.nlogo.core.Syntax;
import org.nlogo.core.Syntax$;
import org.nlogo.extensions.nw.NetworkExtensionUtil$;
import org.nlogo.nvm.AssemblerAssistant;
import org.nlogo.nvm.CustomAssembled;
import org.nlogo.nvm.ExtensionContext;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public final class NetworkExtensionUtil {
    public static RichAgentSet AgentSetToRichAgentSet(AgentSet agentSet, World world) {
        return NetworkExtensionUtil$.MODULE$.AgentSetToRichAgentSet(agentSet, world);
    }

    public static RichAgent AgentToRichAgent(Agent agent) {
        return NetworkExtensionUtil$.MODULE$.AgentToRichAgent(agent);
    }

    public static RichLink LinkToRichLink(Link link, World world) {
        return NetworkExtensionUtil$.MODULE$.LinkToRichLink(link, world);
    }

    public static String canonocilizeVar(Object object) {
        return NetworkExtensionUtil$.MODULE$.canonocilizeVar(object);
    }

    public static Turtle createTurtle(World world, org.nlogo.agent.AgentSet agentSet, MersenneTwisterFast mersenneTwisterFast) {
        return NetworkExtensionUtil$.MODULE$.createTurtle(world, agentSet, mersenneTwisterFast);
    }

    public static <I, O> Transformer<I, O> functionToTransformer(Function1<I, O> function1) {
        return NetworkExtensionUtil$.MODULE$.functionToTransformer(function1);
    }

    public static <A, B> B using(A a, Function1<A, B> function1) {
        return NetworkExtensionUtil$.MODULE$.using(a, function1);
    }

    public static class RichAgent {
        private final Agent agent;

        public RichAgent(Agent agent) {
            this.agent = agent;
        }

        public Agent requireAlive() {
            if (this.agent.id() != -1L) {
                return this.agent;
            }
            throw new ExtensionException(I18N$.MODULE$.errors().get("org.nlogo.$common.thatAgentIsDead"));
        }
    }

    public static class RichAgentSet {
        public final org.nlogo.agent.AgentSet org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet;
        private final World world;

        public RichAgentSet(org.nlogo.agent.AgentSet agentSet, World world) {
            this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet = agentSet;
            this.world = world;
            if (agentSet == null) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
        }

        public World world() {
            return this.world;
        }

        public boolean isLinkBreed() {
            return this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet == this.world().links() || this.world().isLinkBreed(this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet);
        }

        public boolean isTurtleBreed() {
            return this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet == this.world().turtles() || this.world().isBreed(this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet);
        }

        public boolean isLinkSet() {
            AgentKind agentKind = this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet.kind();
            AgentKind.Link$ link$ = AgentKind.Link$.MODULE$;
            return !(agentKind != null ? !agentKind.equals(link$) : link$ != null);
        }

        public boolean isTurtleSet() {
            AgentKind agentKind = this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet.kind();
            AgentKind.Turtle$ turtle$ = AgentKind.Turtle$.MODULE$;
            return !(agentKind != null ? !agentKind.equals(turtle$) : turtle$ != null);
        }

        public org.nlogo.agent.AgentSet requireTurtleSet() {
            if (this.isTurtleSet()) {
                return this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet;
            }
            throw new ExtensionException("Expected input to be a turtleset");
        }

        public org.nlogo.agent.AgentSet requireLinkSet() {
            if (this.isLinkSet()) {
                return this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet;
            }
            throw new ExtensionException("Expected input to be a linkset");
        }

        public TreeAgentSet requireTurtleBreed() {
            if (this.isTurtleBreed()) {
                return (TreeAgentSet)this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet;
            }
            throw new ExtensionException("Expected input to be a turtle breed");
        }

        public TreeAgentSet requireLinkBreed() {
            if (this.isLinkBreed()) {
                return (TreeAgentSet)this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet;
            }
            throw new ExtensionException(I18N$.MODULE$.errors().get("org.nlogo.prim.etc.$common.expectedLastInputToBeLinkBreed"));
        }

        public TreeAgentSet requireDirectedLinkBreed() {
            if (this.isLinkBreed() && this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet.isDirected()) {
                return (TreeAgentSet)this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet;
            }
            throw new ExtensionException("Expected input to be a directed link breed");
        }

        public TreeAgentSet requireUndirectedLinkBreed() {
            if (this.isLinkBreed() && !this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet.isDirected()) {
                return (TreeAgentSet)this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet;
            }
            throw new ExtensionException("Expected input to be an undirected link breed");
        }

        public <T extends Agent> Iterable<T> asIterable() {
            return new AgentSetIterable();
        }

        public <T extends Agent> Iterable<T> asShufflerable(MersenneTwisterFast rng) {
            return new AgentSetShufflerable(this, rng);
        }

        public class AgentSetIterable<T extends Agent>
        implements Iterable<T> {
            public AgentSetIterable() {
                if (RichAgentSet.this == null) {
                    throw new NullPointerException();
                }
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
            }

            public AgentIterator newIt() {
                return RichAgentSet.this.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet.iterator();
            }

            public Iterator<T> iterator() {
                AgentIterator it = this.newIt();
                return new Iterator<T>(it){
                    private final AgentIterator it$1;
                    {
                        this.it$1 = it$2;
                        IterableOnce.$init$((IterableOnce)this);
                        IterableOnceOps.$init$((IterableOnceOps)this);
                        Iterator.$init$((Iterator)this);
                    }

                    public boolean hasNext() {
                        return this.it$1.hasNext();
                    }

                    public Agent next() {
                        return this.it$1.next();
                    }
                };
            }

            public final /* synthetic */ RichAgentSet org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$AgentSetIterable$$$outer() {
                return RichAgentSet.this;
            }
        }

        public class AgentSetShufflerable<T extends Agent>
        extends AgentSetIterable<T> {
            private final MersenneTwisterFast rng;
            private final /* synthetic */ RichAgentSet $outer;

            public AgentSetShufflerable(RichAgentSet $outer, MersenneTwisterFast rng) {
                this.rng = rng;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            @Override
            public AgentIterator newIt() {
                return this.$outer.org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$$agentSet.shufflerator(this.rng);
            }

            public final /* synthetic */ RichAgentSet org$nlogo$extensions$nw$NetworkExtensionUtil$RichAgentSet$AgentSetShufflerable$$$outer() {
                return this.$outer;
            }
        }
    }

    public static class RichLink {
        private final Link link;
        private final World world;

        public RichLink(Link link, World world) {
            this.link = link;
            this.world = world;
        }

        public Object getBreedOrLinkVariable(String variable) {
            Object object;
            try {
                int n = this.world.program().linksOwn().indexOf((Object)variable);
                if (-1 == n) {
                    object = this.link.getLinkBreedVariable(variable);
                } else {
                    int i = n;
                    object = this.link.getLinkVariable(i);
                }
            }
            catch (Exception e) {
                throw new ExtensionException(e);
            }
            return object;
        }
    }

    public static interface TurtleAskingCommand
    extends Command,
    CustomAssembled {
        public static Syntax getSyntax$(TurtleAskingCommand $this) {
            return $this.getSyntax();
        }

        default public Syntax getSyntax() {
            Some some = Some$.MODULE$.apply((Object)"-T--");
            List list = Syntax$.MODULE$.commandSyntax$default$1();
            Option option = Syntax$.MODULE$.commandSyntax$default$2();
            Option option2 = Syntax$.MODULE$.commandSyntax$default$3();
            boolean bl = Syntax$.MODULE$.commandSyntax$default$6();
            boolean bl2 = Syntax$.MODULE$.commandSyntax$default$7();
            return Syntax$.MODULE$.commandSyntax(list, option, option2, "OT--", (Option)some, bl, bl2);
        }

        public static void askTurtles$(TurtleAskingCommand $this, Context context, IterableOnce turtles) {
            $this.askTurtles(context, (IterableOnce<Turtle>)turtles);
        }

        default public void askTurtles(Context context, IterableOnce<Turtle> turtles) {
            Object[] agents = (Turtle[])turtles.iterator().toArray(ClassTag$.MODULE$.apply(Turtle.class));
            ExtensionContext extContext = (ExtensionContext)context;
            org.nlogo.nvm.Context nvmContext = extContext.nvmContext();
            Object object = Predef$.MODULE$.refArrayOps(agents);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)((JProcedure1 & Serializable)arg_0 -> NetworkExtensionUtil$.org$nlogo$extensions$nw$NetworkExtensionUtil$TurtleAskingCommand$$_$askTurtles$$anonfun$1(extContext, arg_0)));
            IndexedAgentSet agentSet = AgentSet$.MODULE$.fromArray((AgentKind)AgentKind.Turtle$.MODULE$, (org.nlogo.agent.Agent[])agents);
            nvmContext.runExclusiveJob((org.nlogo.agent.AgentSet)agentSet, nvmContext.ip + 1);
        }

        public static void assemble$(TurtleAskingCommand $this, AssemblerAssistant a) {
            $this.assemble(a);
        }

        default public void assemble(AssemblerAssistant a) {
            a.block();
            a.done();
        }
    }

    public static interface TurtleCreatingCommand
    extends TurtleAskingCommand {
        public IterableOnce<Turtle> createTurtles(Argument[] var1, Context var2);

        public static void perform$(TurtleCreatingCommand $this, Argument[] args, Context context) {
            $this.perform(args, context);
        }

        default public void perform(Argument[] args, Context context) {
            this.askTurtles(context, this.createTurtles(args, context));
        }

        public static int getIntValueWithMinimum$(TurtleCreatingCommand $this, Argument arg, int minimum, String things) {
            return $this.getIntValueWithMinimum(arg, minimum, things);
        }

        default public int getIntValueWithMinimum(Argument arg, int minimum, String things) {
            int nb = arg.getIntValue();
            if (nb < minimum) {
                throw new ExtensionException("The number of " + things + " in the generated network must be at least " + minimum + ".");
            }
            return nb;
        }

        public static String getIntValueWithMinimum$default$3$(TurtleCreatingCommand $this) {
            return $this.getIntValueWithMinimum$default$3();
        }

        default public String getIntValueWithMinimum$default$3() {
            return "nodes";
        }
    }
}

