/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.nw.algorithms;

import java.io.Serializable;
import org.nlogo.extensions.nw.Graph;
import org.nlogo.extensions.nw.algorithms.Louvain$;
import org.nlogo.extensions.nw.algorithms.Louvain$CommunityStructure$;
import org.nlogo.extensions.nw.algorithms.Louvain$MergedGraph$;
import org.nlogo.extensions.nw.algorithms.Louvain$WeightedLink$;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Random;

public final class Louvain {
    public static <V, E> Seq<Seq<V>> cluster(Graph<V, E> graph, Random random) {
        return Louvain$.MODULE$.cluster(graph, random);
    }

    public static <V, E> CommunityStructure<V, E> clusterLocally(Graph<V, E> graph, Random random) {
        return Louvain$.MODULE$.clusterLocally(graph, random);
    }

    public static class CommunityStructure<V, E> {
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(CommunityStructure.class.getDeclaredField("_members$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CommunityStructure.class.getDeclaredField("communities$lzy1"));
        private final Graph<V, E> graph;
        private final Map<V, Object> comMap;
        private final Vector<Object> internal;
        private final Vector<Object> totalIn;
        private final Vector<Object> totalOut;
        private final double modularity;
        private volatile Object communities$lzy1;
        private volatile Object _members$lzy1;

        public static <V, E> CommunityStructure<V, E> apply(Graph<V, E> graph) {
            return Louvain$CommunityStructure$.MODULE$.apply(graph);
        }

        public static <V, E> CommunityStructure<V, E> apply(Graph<V, E> graph, Seq<Seq<V>> seq) {
            return Louvain$CommunityStructure$.MODULE$.apply(graph, seq);
        }

        public CommunityStructure(Graph<V, E> graph, Map<V, Object> comMap, Vector<Object> internal, Vector<Object> totalIn, Vector<Object> totalOut, double modularity) {
            this.graph = graph;
            this.comMap = comMap;
            this.internal = internal;
            this.totalIn = totalIn;
            this.totalOut = totalOut;
            this.modularity = modularity;
        }

        public double modularity() {
            return this.modularity;
        }

        public int community(V node) {
            return BoxesRunTime.unboxToInt((Object)this.comMap.apply(node));
        }

        public CommunityStructure<V, E> move(V node, int newCommunity) {
            int originalCommunity = this.community(node);
            Function1 & Serializable otherEnd = (Function1 & Serializable)link -> this.graph.otherEnd(node, link);
            DoubleRef inDegree = DoubleRef.create((double)0.0);
            DoubleRef outDegree = DoubleRef.create((double)0.0);
            DoubleRef internalOriginal = DoubleRef.create((double)0.0);
            DoubleRef internalNew = DoubleRef.create((double)0.0);
            this.graph.outEdges(node).foreach((Function1)(JProcedure1 & Serializable)link -> {
                Object other = otherEnd.apply(link);
                int comOther = this.community(other);
                double weight = this.graph.weight(link);
                outDegree$1.elem += weight;
                if (BoxesRunTime.equals((Object)other, (Object)node)) {
                    internalOriginal$1.elem += weight;
                    internalNew$1.elem += weight;
                    return;
                }
                if (comOther == originalCommunity) {
                    internalOriginal$1.elem += weight;
                    return;
                }
                if (comOther == newCommunity) {
                    internalNew$1.elem += weight;
                    return;
                }
            });
            this.graph.inEdges(node).foreach((Function1)(JProcedure1 & Serializable)link -> {
                Object other = otherEnd.apply(link);
                int comOther = this.community(other);
                double weight = this.graph.weight(link);
                inDegree$1.elem += weight;
                if (BoxesRunTime.equals((Object)other, (Object)node)) {
                    internalOriginal$2.elem += weight;
                    internalNew$2.elem += weight;
                    return;
                }
                if (comOther == originalCommunity) {
                    internalOriginal$2.elem += weight;
                    return;
                }
                if (comOther == newCommunity) {
                    internalNew$2.elem += weight;
                    return;
                }
            });
            Vector newTotalIn = this.totalIn.updated(originalCommunity, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.totalIn.apply(originalCommunity)) - inDegree.elem))).updated(newCommunity, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.totalIn.apply(newCommunity)) + inDegree.elem)));
            Vector newTotalOut = this.totalOut.updated(originalCommunity, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.totalOut.apply(originalCommunity)) - outDegree.elem))).updated(newCommunity, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.totalOut.apply(newCommunity)) + outDegree.elem)));
            Vector newInternal = this.internal.updated(originalCommunity, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.internal.apply(originalCommunity)) - internalOriginal.elem))).updated(newCommunity, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.internal.apply(newCommunity)) + internalNew.elem)));
            Function4 & Serializable contrib = (Function4 & Serializable)(com, intern, in, out) -> this.$anonfun$7(BoxesRunTime.unboxToInt((Object)com), (Vector)intern, (Vector)in, (Vector)out);
            double deltaOriginal = BoxesRunTime.unboxToDouble((Object)contrib.apply((Object)BoxesRunTime.boxToInteger((int)originalCommunity), (Object)newInternal, (Object)newTotalIn, (Object)newTotalOut)) - BoxesRunTime.unboxToDouble((Object)contrib.apply((Object)BoxesRunTime.boxToInteger((int)originalCommunity), this.internal, this.totalIn, this.totalOut));
            double deltaNew = BoxesRunTime.unboxToDouble((Object)contrib.apply((Object)BoxesRunTime.boxToInteger((int)newCommunity), (Object)newInternal, (Object)newTotalIn, (Object)newTotalOut)) - BoxesRunTime.unboxToDouble((Object)contrib.apply((Object)BoxesRunTime.boxToInteger((int)newCommunity), this.internal, this.totalIn, this.totalOut));
            return new CommunityStructure<V, E>(this.graph, (Map)this.comMap.updated(node, (Object)BoxesRunTime.boxToInteger((int)newCommunity)), (Vector<Object>)newInternal, (Vector<Object>)newTotalIn, (Vector<Object>)newTotalOut, this.modularity() + deltaOriginal + deltaNew);
        }

        public Seq<Object> communities() {
            Object object = this.communities$lzy1;
            if (object instanceof Seq) {
                return (Seq)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Seq)this.communities$lzyINIT1();
        }

        private Object communities$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.communities$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Seq seq = null;
                        try {
                            seq = (Seq)((SeqOps)this.comMap.values().toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$);
                            object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.communities$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return seq;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        private Map<Object, Seq<V>> _members() {
            Object object = this._members$lzy1;
            if (object instanceof Map) {
                return (Map)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Map)this._members$lzyINIT1();
        }

        private Object _members$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this._members$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Map map = null;
                        try {
                            map = this.graph.nodes().toSeq().groupBy(this.comMap);
                            object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this._members$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return map;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Seq<V> members(int community) {
            return (Seq)this._members().apply((Object)BoxesRunTime.boxToInteger((int)community));
        }

        private final /* synthetic */ double $anonfun$7(int com, Vector intern, Vector in, Vector out) {
            return (BoxesRunTime.unboxToDouble((Object)intern.apply(com)) - BoxesRunTime.unboxToDouble((Object)in.apply(com)) * BoxesRunTime.unboxToDouble((Object)out.apply(com)) / this.graph.totalArcWeight()) / this.graph.totalArcWeight();
        }
    }

    public static class MergedGraph<V, E>
    implements Graph<Object, WeightedLink<Object>>,
    Product,
    Serializable {
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MergedGraph.class.getDeclaredField("totalArcWeight$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MergedGraph.class.getDeclaredField("arcCount$lzy1"));
        private volatile Object arcCount$lzy1;
        private volatile Object totalArcWeight$lzy1;
        private final Graph<V, E> graph;
        private final CommunityStructure<V, E> communityStructure;
        private final Seq<Object> nodes;
        private final Seq<WeightedLink<Object>> edges;
        private final Map<Object, Seq<WeightedLink<Object>>> outEdgeMap;
        private final Map<Object, Seq<WeightedLink<Object>>> inEdgeMap;

        public static <V, E> MergedGraph<V, E> apply(Graph<V, E> graph, CommunityStructure<V, E> communityStructure) {
            return Louvain$MergedGraph$.MODULE$.apply(graph, communityStructure);
        }

        public static MergedGraph<?, ?> fromProduct(Product product) {
            return Louvain$MergedGraph$.MODULE$.fromProduct(product);
        }

        public static <V, E> MergedGraph<V, E> unapply(MergedGraph<V, E> mergedGraph) {
            return Louvain$MergedGraph$.MODULE$.unapply(mergedGraph);
        }

        public MergedGraph(Graph<V, E> graph, CommunityStructure<V, E> communityStructure) {
            this.graph = graph;
            this.communityStructure = communityStructure;
            Graph.$init$(this);
            this.nodes = communityStructure.communities();
            this.edges = (Seq)communityStructure.communities().flatMap((Function1 & Serializable)sourceCom -> this.$init$$$anonfun$1(communityStructure, graph, BoxesRunTime.unboxToInt((Object)sourceCom)));
            this.outEdgeMap = this.edges().groupBy((Function1 & Serializable)_$8 -> BoxesRunTime.unboxToInt(_$8.end1())).withDefaultValue((Object)package$.MODULE$.Seq().empty());
            this.inEdgeMap = this.edges().groupBy((Function1 & Serializable)_$9 -> BoxesRunTime.unboxToInt(_$9.end2())).withDefaultValue((Object)package$.MODULE$.Seq().empty());
        }

        @Override
        public int arcCount() {
            Object object = this.arcCount$lzy1;
            if (object instanceof Integer) {
                return BoxesRunTime.unboxToInt((Object)object);
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return BoxesRunTime.unboxToInt(null);
            }
            return BoxesRunTime.unboxToInt((Object)this.arcCount$lzyINIT1());
        }

        private Object arcCount$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.arcCount$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Integer n = null;
                        try {
                            n = BoxesRunTime.boxToInteger((int)Graph.arcCount$(this));
                            object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.arcCount$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return n;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public double totalArcWeight() {
            Object object = this.totalArcWeight$lzy1;
            if (object instanceof Double) {
                return BoxesRunTime.unboxToDouble((Object)object);
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return BoxesRunTime.unboxToDouble(null);
            }
            return BoxesRunTime.unboxToDouble((Object)this.totalArcWeight$lzyINIT1());
        }

        private Object totalArcWeight$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.totalArcWeight$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Double d = null;
                        try {
                            d = BoxesRunTime.boxToDouble((double)Graph.totalArcWeight$(this));
                            object2 = d == null ? LazyVals.NullValue$.MODULE$ : d;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.totalArcWeight$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return d;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MergedGraph)) return false;
            MergedGraph mergedGraph = (MergedGraph)object;
            Graph<V, E> graph = this.graph();
            Graph<V, E> graph2 = mergedGraph.graph();
            if (graph == null) {
                if (graph2 != null) {
                    return false;
                }
            } else if (!graph.equals(graph2)) return false;
            CommunityStructure<V, E> communityStructure = this.communityStructure();
            CommunityStructure<V, E> communityStructure2 = mergedGraph.communityStructure();
            if (communityStructure == null) {
                if (communityStructure2 != null) {
                    return false;
                }
            } else if (!communityStructure.equals(communityStructure2)) return false;
            if (!mergedGraph.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MergedGraph;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MergedGraph";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "graph";
            }
            if (1 == n2) {
                return "communityStructure";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Graph<V, E> graph() {
            return this.graph;
        }

        public CommunityStructure<V, E> communityStructure() {
            return this.communityStructure;
        }

        @Override
        public Seq<Object> nodes() {
            return this.nodes;
        }

        public Seq<WeightedLink<Object>> edges() {
            return this.edges;
        }

        public Map<Object, Seq<WeightedLink<Object>>> outEdgeMap() {
            return this.outEdgeMap;
        }

        public Map<Object, Seq<WeightedLink<Object>>> inEdgeMap() {
            return this.inEdgeMap;
        }

        @Override
        public Seq<WeightedLink<Object>> inEdges(int node) {
            return (Seq)this.inEdgeMap().apply((Object)BoxesRunTime.boxToInteger((int)node));
        }

        @Override
        public Seq<WeightedLink<Object>> outEdges(int node) {
            return (Seq)this.outEdgeMap().apply((Object)BoxesRunTime.boxToInteger((int)node));
        }

        @Override
        public double weight(WeightedLink<Object> link) {
            return link.weight();
        }

        @Override
        public Tuple2<Object, Object> ends(WeightedLink<Object> link) {
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc(link.end1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, link.end2());
        }

        public <V, E> MergedGraph<V, E> copy(Graph<V, E> graph, CommunityStructure<V, E> communityStructure) {
            return new MergedGraph<V, E>(graph, communityStructure);
        }

        public <V, E> Graph<V, E> copy$default$1() {
            return this.graph();
        }

        public <V, E> CommunityStructure<V, E> copy$default$2() {
            return this.communityStructure();
        }

        public Graph<V, E> _1() {
            return this.graph();
        }

        public CommunityStructure<V, E> _2() {
            return this.communityStructure();
        }

        private final /* synthetic */ IterableOnce $init$$$anonfun$1(CommunityStructure communityStructure$2, Graph graph$11, int sourceCom) {
            return (IterableOnce)((IterableOps)communityStructure$2.members(sourceCom).flatMap((Function1 & Serializable)source -> (IterableOnce)graph$11.outEdges(source).map((Function1 & Serializable)e -> {
                Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)communityStructure$2.community(graph$11.otherEnd(source, e))));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)BoxesRunTime.boxToDouble((double)graph$11.weight(e)));
            }))).groupBy((Function1 & Serializable)_$6 -> _$6._1$mcI$sp()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    int targetCom = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    Seq ws = (Seq)tuple2._2();
                    return Louvain$WeightedLink$.MODULE$.apply(BoxesRunTime.boxToInteger((int)sourceCom), BoxesRunTime.boxToInteger((int)targetCom), BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)ws.map((Function1 & Serializable)_$7 -> _$7._2$mcD$sp())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
                }
                throw new MatchError((Object)tuple2);
            });
        }
    }

    public static class WeightedLink<V>
    implements Product,
    Serializable {
        private final V end1;
        private final V end2;
        private final double weight;

        public static <V> WeightedLink<V> apply(V v, V v2, double d) {
            return Louvain$WeightedLink$.MODULE$.apply(v, v2, d);
        }

        public static WeightedLink<?> fromProduct(Product product) {
            return Louvain$WeightedLink$.MODULE$.fromProduct(product);
        }

        public static <V> WeightedLink<V> unapply(WeightedLink<V> weightedLink) {
            return Louvain$WeightedLink$.MODULE$.unapply(weightedLink);
        }

        public WeightedLink(V end1, V end2, double weight) {
            this.end1 = end1;
            this.end2 = end2;
            this.weight = weight;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.end1()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.end2()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.weight()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WeightedLink)) return false;
            WeightedLink weightedLink = (WeightedLink)object;
            if (this.weight() != weightedLink.weight()) return false;
            if (!BoxesRunTime.equals(this.end1(), weightedLink.end1())) return false;
            if (!BoxesRunTime.equals(this.end2(), weightedLink.end2())) return false;
            if (!weightedLink.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WeightedLink;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "WeightedLink";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "end1";
                }
                case 1: {
                    return "end2";
                }
                case 2: {
                    return "weight";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public V end1() {
            return this.end1;
        }

        public V end2() {
            return this.end2;
        }

        public double weight() {
            return this.weight;
        }

        public <V> WeightedLink<V> copy(V end1, V end2, double weight) {
            return new WeightedLink<V>(end1, end2, weight);
        }

        public <V> V copy$default$1() {
            return this.end1();
        }

        public <V> V copy$default$2() {
            return this.end2();
        }

        public double copy$default$3() {
            return this.weight();
        }

        public V _1() {
            return this.end1();
        }

        public V _2() {
            return this.end2();
        }

        public double _3() {
            return this.weight();
        }
    }
}

