/*
 * Decompiled with CFR 0.152.
 */
package org.json4s.reflect;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.json4s.MappingException;
import org.json4s.reflect.PrimaryConstructor;
import org.json4s.reflect.SingletonDescriptor;
import org.json4s.reflect.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;

public class Executable {
    private final Method method;
    private final Constructor constructor;
    private final boolean isPrimaryCtor;

    private Executable(Method method, Constructor<?> constructor, boolean isPrimaryCtor) {
        this.method = method;
        this.constructor = constructor;
        this.isPrimaryCtor = isPrimaryCtor;
    }

    public Method method() {
        return this.method;
    }

    public Constructor<?> constructor() {
        return this.constructor;
    }

    public Executable(Method method) {
        this(method, null, false);
    }

    public Executable(Constructor<?> constructor, boolean isPrimaryCtor) {
        this(null, constructor, isPrimaryCtor);
    }

    public Option<String> defaultValuePattern() {
        return this.isPrimaryCtor ? Some$.MODULE$.apply((Object)package$.MODULE$.ConstructorDefaultValuePattern()) : None$.MODULE$;
    }

    public int getModifiers() {
        return this.method() != null ? this.method().getModifiers() : this.constructor().getModifiers();
    }

    public Type[] getGenericParameterTypes() {
        return this.method() != null ? this.method().getGenericParameterTypes() : this.constructor().getGenericParameterTypes();
    }

    public Class<?>[] getParameterTypes() {
        return this.method() != null ? this.method().getParameterTypes() : this.constructor().getParameterTypes();
    }

    public Class<?> getDeclaringClass() {
        return this.method() != null ? this.method().getDeclaringClass() : this.constructor().getDeclaringClass();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object invoke(Option<SingletonDescriptor> companion, Seq<Object> args) {
        Object object;
        if (this.method() == null) {
            object = this.constructor().newInstance((Object[])((IterableOnceOps)args.map((Function1 & Serializable)_$2 -> _$2)).toArray(ClassTag$.MODULE$.apply(Object.class)));
            return object;
        }
        Option<SingletonDescriptor> option = companion;
        if (option instanceof Some) {
            SingletonDescriptor cmp = (SingletonDescriptor)((Some)option).value();
            object = this.method().invoke(cmp.instance(), (Object[])((IterableOnceOps)args.map((Function1 & Serializable)_$1 -> _$1)).toArray(ClassTag$.MODULE$.apply(Object.class)));
            return object;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new MappingException("Trying to call apply method, but the companion object was not found.");
    }

    public AccessibleObject getAsAccessibleObject() {
        return this.method() != null ? this.method() : this.constructor();
    }

    public boolean getMarkedAsPrimary() {
        boolean markedByAnnotation = this.method() == null ? this.constructor().isAnnotationPresent(PrimaryConstructor.class) : false;
        return markedByAnnotation || this.isPrimaryCtor;
    }

    public String toString() {
        return this.method() != null ? new StringBuilder(20).append("Executable(Method(").append(this.method()).append("))").toString() : new StringBuilder(25).append("Executable(Constructor(").append(this.constructor()).append("))").toString();
    }
}

