/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.pekko;

import com.typesafe.sslconfig.pekko.DefaultSSLEngineConfigurator;
import com.typesafe.sslconfig.pekko.PekkoSSLConfig$;
import com.typesafe.sslconfig.pekko.util.PekkoLoggerFactory;
import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder;
import com.typesafe.sslconfig.ssl.DefaultHostnameVerifier;
import com.typesafe.sslconfig.ssl.DefaultKeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.DefaultTrustManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.DisabledComplainingHostnameVerifier;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.NoopHostnameVerifier;
import com.typesafe.sslconfig.ssl.Protocols$;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.util.Try;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class PekkoSSLConfig
implements Extension {
    private final ExtendedActorSystem system;
    private final SSLConfigSettings config;
    private final PekkoLoggerFactory mkLogger;
    private final LoggingAdapter log;
    private final HostnameVerifier hostnameVerifier;
    private final DefaultSSLEngineConfigurator sslEngineConfigurator;

    public static Extension apply(ActorSystem actorSystem) {
        return PekkoSSLConfig$.MODULE$.apply(actorSystem);
    }

    public static PekkoSSLConfig apply(ActorSystem actorSystem) {
        return PekkoSSLConfig$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return PekkoSSLConfig$.MODULE$.apply(classicActorSystemProvider);
    }

    public static PekkoSSLConfig createExtension(ExtendedActorSystem extendedActorSystem) {
        return PekkoSSLConfig$.MODULE$.createExtension(extendedActorSystem);
    }

    public static SSLConfigSettings defaultSSLConfigSettings(ActorSystem actorSystem) {
        return PekkoSSLConfig$.MODULE$.defaultSSLConfigSettings(actorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return PekkoSSLConfig$.MODULE$.get(actorSystem);
    }

    public static PekkoSSLConfig get(ActorSystem actorSystem) {
        return PekkoSSLConfig$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return PekkoSSLConfig$.MODULE$.get(classicActorSystemProvider);
    }

    public static PekkoSSLConfig get(ClassicActorSystemProvider classicActorSystemProvider) {
        return PekkoSSLConfig$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return PekkoSSLConfig$.MODULE$.lookup();
    }

    public PekkoSSLConfig(ExtendedActorSystem system, SSLConfigSettings config) {
        SSLContext sSLContext;
        this.system = system;
        this.config = config;
        this.mkLogger = new PekkoLoggerFactory((ActorSystem)system);
        this.log = Logging$.MODULE$.apply((ActorSystem)system, PekkoSSLConfig.class, LogSource$.MODULE$.fromAnyClass());
        this.log.debug("Initializing PekkoSSLConfig extension...");
        this.hostnameVerifier = this.buildHostnameVerifier(config);
        if (config.default()) {
            this.log.info("ssl-config.default is true, using the JDK's default SSLContext");
            sSLContext = SSLContext.getDefault();
        } else {
            KeyManagerFactoryWrapper keyManagerFactory = this.buildKeyManagerFactory(config);
            TrustManagerFactoryWrapper trustManagerFactory = this.buildTrustManagerFactory(config);
            sSLContext = new ConfigSSLContextBuilder((LoggerFactory)this.mkLogger, config, keyManagerFactory, trustManagerFactory).build();
        }
        SSLContext sslContext = sSLContext;
        SSLParameters defaultParams = sslContext.getDefaultSSLParameters();
        String[] defaultProtocols = defaultParams.getProtocols();
        String[] protocols = this.configureProtocols(defaultProtocols, config);
        String[] defaultCiphers = defaultParams.getCipherSuites();
        String[] cipherSuites = this.configureCipherSuites(defaultCiphers, config);
        this.looseDisableSNI(defaultParams);
        this.sslEngineConfigurator = new DefaultSSLEngineConfigurator(config, protocols, cipherSuites);
    }

    public SSLConfigSettings config() {
        return this.config;
    }

    public PekkoSSLConfig withSettings(SSLConfigSettings c) {
        return new PekkoSSLConfig(this.system, c);
    }

    public PekkoSSLConfig mapSettings(Function1<SSLConfigSettings, SSLConfigSettings> f) {
        return new PekkoSSLConfig(this.system, (SSLConfigSettings)f.apply((Object)this.config()));
    }

    public PekkoSSLConfig convertSettings(Function<SSLConfigSettings, SSLConfigSettings> f) {
        return new PekkoSSLConfig(this.system, f.apply(this.config()));
    }

    public HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    @InternalApi
    public boolean useJvmHostnameVerification() {
        HostnameVerifier hostnameVerifier = this.hostnameVerifier();
        return hostnameVerifier instanceof DefaultHostnameVerifier || hostnameVerifier instanceof NoopHostnameVerifier;
        {
        }
    }

    public DefaultSSLEngineConfigurator sslEngineConfigurator() {
        return this.sslEngineConfigurator;
    }

    public KeyManagerFactoryWrapper buildKeyManagerFactory(SSLConfigSettings ssl) {
        String keyManagerAlgorithm = ssl.keyManagerConfig().algorithm();
        return new DefaultKeyManagerFactoryWrapper(keyManagerAlgorithm);
    }

    public TrustManagerFactoryWrapper buildTrustManagerFactory(SSLConfigSettings ssl) {
        String trustManagerAlgorithm = ssl.trustManagerConfig().algorithm();
        return new DefaultTrustManagerFactoryWrapper(trustManagerAlgorithm);
    }

    public HostnameVerifier buildHostnameVerifier(SSLConfigSettings conf) {
        boolean bl = conf != null;
        Class clazz = this.config().loose().disableHostnameVerification() ? DisabledComplainingHostnameVerifier.class : this.config().hostnameVerifierClass();
        HostnameVerifier v = (HostnameVerifier)this.system.dynamicAccess().createInstanceFor(clazz, (Seq)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(HostnameVerifier.class)).orElse(() -> this.$anonfun$1(clazz)).getOrElse(() -> PekkoSSLConfig.$anonfun$2(clazz));
        this.log.debug("buildHostnameVerifier: created hostname verifier: {}", (Object)v);
        return v;
    }

    public void validateDefaultTrustManager(SSLConfigSettings sslConfig) {
        this.log.warning("validateDefaultTrustManager is not doing anything since akka 2.6.19, it was useful only in Java 7 and below");
    }

    public String[] configureProtocols(String[] existingProtocols, SSLConfigSettings sslConfig) {
        String[] stringArray;
        Option option = sslConfig.enabledProtocols();
        if (option instanceof Some) {
            Seq configuredProtocols = (Seq)((Some)option).value();
            Object object = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
            stringArray = (String[])((IterableOnceOps)configuredProtocols.filter((Function1 & Serializable)elem -> ArrayOps$.MODULE$.contains$extension(object, elem))).toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (None$.MODULE$.equals(option)) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])Protocols$.MODULE$.recommendedProtocols());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
            stringArray = (String[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)elem -> ArrayOps$.MODULE$.contains$extension(object2, elem));
        } else {
            throw new MatchError((Object)option);
        }
        String[] definedProtocols = stringArray;
        return definedProtocols;
    }

    public String[] configureCipherSuites(String[] existingCiphers, SSLConfigSettings sslConfig) {
        String[] stringArray;
        Option option = sslConfig.enabledCipherSuites();
        if (option instanceof Some) {
            Seq configuredCiphers = (Seq)((Some)option).value();
            stringArray = (String[])((IterableOnceOps)configuredCiphers.filter((Function1 & Serializable)_$1 -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])existingCiphers);
                return ArrayOps$.MODULE$.contains$extension(object, _$1);
            })).toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (None$.MODULE$.equals(option)) {
            stringArray = existingCiphers;
        } else {
            throw new MatchError((Object)option);
        }
        String[] definedCiphers = stringArray;
        return definedCiphers;
    }

    private void looseDisableSNI(SSLParameters defaultParams) {
        if (this.config().loose().disableSNI()) {
            this.log.warning("You are using ssl-config.loose.disableSNI=true! It is strongly discouraged to disable Server Name Indication, as it is crucial to preventing man-in-the-middle attacks.");
            defaultParams.setServerNames(Collections.emptyList());
            defaultParams.setSNIMatchers(Collections.emptyList());
            return;
        }
    }

    private final Try $anonfun$1(Class clazz$1) {
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(LoggerFactory.class);
        return this.system.dynamicAccess().createInstanceFor(clazz$1, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)this.mkLogger), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(HostnameVerifier.class));
    }

    private static final HostnameVerifier $anonfun$2(Class clazz$2) {
        throw new Exception(new StringBuilder(46).append("Unable to obtain hostname verifier for class: ").append(clazz$2).toString());
    }
}

