/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$SourceLocation$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.impl.ContextPropagation;
import org.apache.pekko.stream.impl.ContextPropagation$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.fusing.GroupedWeightedWithin$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@InternalApi
public final class GroupedWeightedWithin<T>
extends GraphStage<FlowShape<T, Seq<T>>> {
    private final long maxWeight;
    private final int maxNumber;
    private final Function1 costFn;
    private final FiniteDuration interval;
    private final Inlet in;
    private final Outlet out;
    private final FlowShape shape;

    public static String groupedWeightedWithinTimer() {
        return GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer();
    }

    public GroupedWeightedWithin(long maxWeight, int maxNumber, Function1<T, Object> costFn, FiniteDuration interval) {
        this.maxWeight = maxWeight;
        this.maxNumber = maxNumber;
        this.costFn = costFn;
        this.interval = interval;
        Predef$.MODULE$.require(maxWeight > 0L, GroupedWeightedWithin::$init$$$anonfun$14);
        Predef$.MODULE$.require(maxNumber > 0, GroupedWeightedWithin::$init$$$anonfun$15);
        Predef$.MODULE$.require(interval.$greater((Object)Duration$.MODULE$.Zero()));
        this.in = Inlet$.MODULE$.apply("in");
        this.out = Outlet$.MODULE$.apply("out");
        this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
    }

    public long maxWeight() {
        return this.maxWeight;
    }

    public int maxNumber() {
        return this.maxNumber;
    }

    public Function1<T, Object> costFn() {
        return this.costFn;
    }

    public FiniteDuration interval() {
        return this.interval;
    }

    public Inlet<T> in() {
        return this.in;
    }

    public Outlet<Seq<T>> out() {
        return this.out;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.groupedWeightedWithin().and(Attributes$SourceLocation$.MODULE$.forLambda(this.costFn()));
    }

    @Override
    public FlowShape<T, Seq<T>> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private final VectorBuilder buf;
            private Object pending;
            private long pendingWeight;
            private boolean pushEagerly;
            private boolean groupEmitted;
            private boolean finished;
            private long totalWeight;
            private int totalNumber;
            private boolean hasElements;
            private final ContextPropagation contextPropagation;
            private final /* synthetic */ GroupedWeightedWithin $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.buf = new VectorBuilder();
                this.pending = null;
                this.pendingWeight = 0L;
                this.pushEagerly = false;
                this.groupEmitted = true;
                this.finished = false;
                this.totalWeight = 0L;
                this.totalNumber = 0;
                this.hasElements = false;
                this.contextPropagation = ContextPropagation$.MODULE$.apply();
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public void preStart() {
                this.scheduleWithFixedDelay((Object)GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval(), this.$outer.interval());
                this.pull(this.$outer.in());
            }

            private void nextElement(Object elem) {
                this.groupEmitted = false;
                long cost = BoxesRunTime.unboxToLong((Object)this.$outer.costFn().apply(elem));
                if (cost < 0L) {
                    this.failStage(new IllegalArgumentException(new StringBuilder(48).append("Negative weight [").append(cost).append("] for element [").append(elem).append("] is not allowed").toString()));
                    return;
                }
                this.hasElements = true;
                if (this.totalWeight + cost <= this.$outer.maxWeight() && this.totalNumber + 1 <= this.$outer.maxNumber()) {
                    this.buf.$plus$eq(elem);
                    this.totalWeight += cost;
                    ++this.totalNumber;
                    if (this.totalWeight < this.$outer.maxWeight() && this.totalNumber < this.$outer.maxNumber()) {
                        this.pull(this.$outer.in());
                        return;
                    }
                    if (!this.isAvailable(this.$outer.out())) {
                        this.pushEagerly = true;
                        this.pull(this.$outer.in());
                        return;
                    }
                    this.scheduleWithFixedDelay((Object)GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval(), this.$outer.interval());
                    this.emitGroup();
                    return;
                }
                if (this.totalWeight == 0L && this.totalNumber == 0) {
                    this.buf.$plus$eq(elem);
                    this.totalWeight += cost;
                    ++this.totalNumber;
                    this.pushEagerly = true;
                } else {
                    this.pending = elem;
                    this.pendingWeight = cost;
                }
                this.scheduleWithFixedDelay((Object)GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval(), this.$outer.interval());
                this.tryCloseGroup();
            }

            private void tryCloseGroup() {
                if (this.isAvailable(this.$outer.out())) {
                    this.emitGroup();
                    return;
                }
                if (this.pending != null || this.finished) {
                    this.pushEagerly = true;
                    return;
                }
            }

            private void emitGroup() {
                this.groupEmitted = true;
                this.contextPropagation.resumeContext();
                this.push(this.$outer.out(), this.buf.result());
                this.buf.clear();
                if (!this.finished) {
                    this.startNewGroup();
                    return;
                }
                if (this.pending != null) {
                    this.emit(this.$outer.out(), package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.pending})), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.completeStage());
                    return;
                }
                this.completeStage();
            }

            private void startNewGroup() {
                if (this.pending != null) {
                    this.totalWeight = this.pendingWeight;
                    this.totalNumber = 1;
                    this.pendingWeight = 0L;
                    this.buf.$plus$eq(this.pending);
                    this.pending = null;
                    this.groupEmitted = false;
                } else {
                    this.totalWeight = 0L;
                    this.totalNumber = 0;
                    this.hasElements = false;
                }
                this.pushEagerly = false;
                if (this.isAvailable(this.$outer.in())) {
                    this.nextElement(this.grab(this.$outer.in()));
                    return;
                }
                if (!this.hasBeenPulled(this.$outer.in())) {
                    this.pull(this.$outer.in());
                    return;
                }
            }

            public void onPush() {
                this.contextPropagation.suspendContext();
                if (this.pending == null) {
                    this.nextElement(this.grab(this.$outer.in()));
                    return;
                }
            }

            public void onPull() {
                if (this.pushEagerly) {
                    this.emitGroup();
                    return;
                }
            }

            public void onUpstreamFinish() {
                this.finished = true;
                if (this.groupEmitted) {
                    this.completeStage();
                    return;
                }
                this.tryCloseGroup();
            }

            public void onTimer(Object timerKey) {
                if (this.hasElements) {
                    if (this.isAvailable(this.$outer.out())) {
                        this.emitGroup();
                        return;
                    }
                    this.pushEagerly = true;
                    return;
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{emitGroup$$anonfun$1()}, serializedLambda);
            }
        };
    }

    private static final Object $init$$$anonfun$14() {
        return "maxWeight must be greater than 0";
    }

    private static final Object $init$$$anonfun$15() {
        return "maxNumber must be greater than 0";
    }
}

