/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.io.Inet;
import org.apache.pekko.io.Tcp;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.impl.io.OutgoingConnectionStage$;
import org.apache.pekko.stream.impl.io.TcpConnectionStage;
import org.apache.pekko.stream.impl.io.TcpConnectionStage$Outbound$;
import org.apache.pekko.stream.scaladsl.Tcp;
import org.apache.pekko.stream.scaladsl.Tcp$OutgoingConnection$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Iterable;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public class OutgoingConnectionStage
extends GraphStageWithMaterializedValue<FlowShape<ByteString, ByteString>, Future<Tcp.OutgoingConnection>> {
    private final ActorRef manager;
    private final InetSocketAddress remoteAddress;
    private final Option<InetSocketAddress> localAddress;
    private final Iterable<Inet.SocketOption> options;
    private final boolean halfClose;
    private final Duration connectTimeout;
    private final Inlet bytesIn;
    private final Outlet bytesOut;
    private final FlowShape shape;

    public static Option<InetSocketAddress> $lessinit$greater$default$3() {
        return OutgoingConnectionStage$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<Inet.SocketOption> $lessinit$greater$default$4() {
        return OutgoingConnectionStage$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$5() {
        return OutgoingConnectionStage$.MODULE$.$lessinit$greater$default$5();
    }

    public static Duration $lessinit$greater$default$6() {
        return OutgoingConnectionStage$.MODULE$.$lessinit$greater$default$6();
    }

    public OutgoingConnectionStage(ActorRef manager, InetSocketAddress remoteAddress, Option<InetSocketAddress> localAddress, Iterable<Inet.SocketOption> options, boolean halfClose, Duration connectTimeout) {
        this.manager = manager;
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
        this.options = options;
        this.halfClose = halfClose;
        this.connectTimeout = connectTimeout;
        this.bytesIn = Inlet$.MODULE$.apply("OutgoingTCP.in");
        this.bytesOut = Outlet$.MODULE$.apply("OutgoingTCP.out");
        this.shape = FlowShape$.MODULE$.apply(this.bytesIn(), this.bytesOut());
    }

    public Inlet<ByteString> bytesIn() {
        return this.bytesIn;
    }

    public Outlet<ByteString> bytesOut() {
        return this.bytesOut;
    }

    @Override
    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("OutgoingConnection");
    }

    @Override
    public FlowShape<ByteString, ByteString> shape() {
        return this.shape;
    }

    @Override
    public Tuple2<GraphStageLogic, Future<Tcp.OutgoingConnection>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        throw new UnsupportedOperationException("Not used");
    }

    @Override
    public Tuple2<GraphStageLogic, Future<Tcp.OutgoingConnection>> createLogicAndMaterializedValue(Attributes inheritedAttributes, Materializer eagerMaterializer) {
        None$ none$;
        Duration duration = this.connectTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration x = (FiniteDuration)duration;
            none$ = Some$.MODULE$.apply((Object)x);
        } else {
            none$ = None$.MODULE$;
        }
        None$ connTimeout = none$;
        Promise localAddressPromise = Promise$.MODULE$.apply();
        TcpConnectionStage.TcpStreamLogic logic = new TcpConnectionStage.TcpStreamLogic((FlowShape<ByteString, ByteString>)this.shape(), TcpConnectionStage$Outbound$.MODULE$.apply(this.manager, Tcp.Connect$.MODULE$.apply(this.remoteAddress, this.localAddress, this.options, (Option)connTimeout, true), (Promise<InetSocketAddress>)localAddressPromise, this.halfClose), inheritedAttributes, this.remoteAddress, eagerMaterializer);
        return Tuple2$.MODULE$.apply((Object)logic, (Object)localAddressPromise.future().map((Function1 & Serializable)_$4 -> Tcp$OutgoingConnection$.MODULE$.apply(this.remoteAddress, (InetSocketAddress)_$4), ExecutionContexts$.MODULE$.parasitic()));
    }

    public String toString() {
        return new StringBuilder(8).append("TCP-to(").append(this.remoteAddress).append(")").toString();
    }
}

