/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.contour;

import java.awt.geom.Point2D;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.contour.Contour;
import org.tinfour.contour.ContourRegion;
import org.tinfour.contour.ContourRegionMember;
import org.tinfour.contour.PerimeterLink;
import org.tinfour.contour.TipLink;
import org.tinfour.interpolation.IVertexValuator;
import org.tinfour.utils.VisvalingamLineSimplification;

public class ContourBuilderForTin {
    private IIncrementalTin tin;
    private List<IQuadEdge> perimeter;
    private IVertexValuator valuator;
    private final double[] zContour;
    private BitSet visited;
    private BitSet perimeterTermination;
    private final ArrayList<Contour> closedContourList = new ArrayList();
    private final ArrayList<Contour> openContourList = new ArrayList();
    private final ArrayList<Contour> perimeterContourList = new ArrayList();
    private final ArrayList<ContourRegion> regionList = new ArrayList();
    private final ArrayList<ContourRegion> outerRegions = new ArrayList();
    private final double[] envelope;
    private int nVertexTransit;
    private int nEdgeTransit;
    boolean regionsAreBuilt;
    private long timeToBuildContours;
    private long timeToBuildRegions;
    private Map<Integer, PerimeterLink> perimeterMap = new HashMap<Integer, PerimeterLink>();
    private List<PerimeterLink> perimeterList = new ArrayList<PerimeterLink>();

    public ContourBuilderForTin(IIncrementalTin tin, IVertexValuator vertexValuator, double[] zContour, boolean buildRegions) {
        if (tin == null) {
            throw new IllegalArgumentException("Null reference for input TIN");
        }
        if (!tin.isBootstrapped()) {
            throw new IllegalArgumentException("Input TIN is not properly populated");
        }
        if (zContour == null) {
            throw new IllegalArgumentException("Null reference for input contour list");
        }
        for (int i = 1; i < zContour.length; ++i) {
            if (zContour[i - 1] < zContour[i]) continue;
            throw new IllegalArgumentException("Input contours must be unique and specified in ascending order, zContours[ " + i + "] does not meet this requirement");
        }
        this.tin = tin;
        this.valuator = vertexValuator == null ? new DefaultValuator() : vertexValuator;
        this.zContour = Arrays.copyOf(zContour, zContour.length);
        int n = tin.getMaximumEdgeAllocationIndex();
        this.visited = new BitSet(n);
        this.perimeterTermination = new BitSet(n);
        this.perimeter = tin.getPerimeter();
        PerimeterLink prior = null;
        int k = 0;
        for (IQuadEdge p : this.perimeter) {
            PerimeterLink pLink = new PerimeterLink(k, p);
            this.perimeterMap.put(p.getIndex(), pLink);
            this.perimeterList.add(pLink);
            if (prior != null) {
                prior.next = pLink;
                pLink.prior = prior;
            }
            prior = pLink;
            ++k;
        }
        assert (!this.perimeterList.isEmpty() && prior != null) : "Missing perimeter data";
        PerimeterLink pFirst = this.perimeterList.get(0);
        pFirst.prior = prior;
        prior.next = pFirst;
        for (IQuadEdge p : this.perimeter) {
            for (IQuadEdge w : p.pinwheel()) {
                this.perimeterTermination.set(w.getIndex() ^ 1);
            }
        }
        this.envelope = new double[2 * this.perimeter.size() + 2];
        k = 0;
        for (IQuadEdge p : this.perimeter) {
            Vertex A = p.getA();
            this.envelope[k++] = A.getX();
            this.envelope[k++] = A.getY();
        }
        this.envelope[k++] = this.envelope[0];
        this.envelope[k++] = this.envelope[1];
        this.buildAllContours();
        if (buildRegions) {
            this.buildRegions();
        }
        this.tin = null;
        this.valuator = null;
        this.visited = null;
        this.perimeterTermination = null;
        this.perimeterMap = null;
        this.perimeterList = null;
        this.perimeter = null;
        for (Contour contour : this.closedContourList) {
            contour.cleanUp();
        }
        for (Contour contour : this.openContourList) {
            contour.cleanUp();
        }
    }

    public void simplify(double areaThreshold) {
        VisvalingamLineSimplification vis = new VisvalingamLineSimplification();
        for (Contour contour : this.closedContourList) {
            int nBefore = contour.n;
            contour.n = 2 * vis.simplify(contour.n / 2, contour.xy, areaThreshold);
            if (contour.n >= nBefore) continue;
            contour.complete();
        }
    }

    public List<Contour> getContours() {
        int n = this.closedContourList.size() + this.openContourList.size() + this.perimeterContourList.size();
        ArrayList<Contour> cList = new ArrayList<Contour>(n);
        cList.addAll(this.openContourList);
        cList.addAll(this.closedContourList);
        cList.addAll(this.perimeterContourList);
        return cList;
    }

    public List<ContourRegion> getRegions() {
        ArrayList<ContourRegion> aList = new ArrayList<ContourRegion>(this.regionList.size());
        aList.addAll(this.regionList);
        return aList;
    }

    public double[] getEnvelope() {
        return Arrays.copyOf(this.envelope, this.envelope.length);
    }

    private void buildAllContours() {
        long time0 = System.nanoTime();
        for (int i = 0; i < this.zContour.length; ++i) {
            this.visited.clear();
            this.buildOpenContours(i);
            this.buildClosedLoopContours(i);
        }
        long time1 = System.nanoTime();
        this.timeToBuildContours = time1 - time0;
    }

    private void buildClosedLoopContours(int iContour) {
        double z = this.zContour[iContour];
        for (IQuadEdge p : this.tin.edges()) {
            Contour contour;
            IQuadEdge e = p;
            int eIndex = e.getIndex();
            if (this.visited.get(eIndex)) continue;
            this.markAsVisited(e);
            Vertex A = e.getA();
            Vertex B = e.getB();
            double zA = this.valuator.value(A);
            double zB = this.valuator.value(B);
            double test = (zA - z) * (zB - z);
            if (test < 0.0) {
                if (zA < zB) {
                    e = e.getDual();
                    double zSwap = zA;
                    zA = zB;
                    zB = zSwap;
                    A = e.getA();
                    B = e.getB();
                }
                Contour contour2 = new Contour(iContour + 1, iContour, z, true);
                contour2.add(e, zA, zB);
                this.followContour(contour2, z, e, null, 0, e, null);
                continue;
            }
            if (test != 0.0 || zA != z || zB != z) continue;
            IQuadEdge f = e.getForward();
            IQuadEdge g = e.getDual();
            IQuadEdge h = g.getForward();
            this.markAsVisited(f);
            this.markAsVisited(g);
            this.markAsVisited(h);
            Vertex C = f.getB();
            Vertex D = h.getB();
            double zC = this.valuator.value(C);
            double zD = this.valuator.value(D);
            if (zC >= z && z > zD) {
                contour = new Contour(iContour + 1, iContour, z, true);
                contour.add(A);
                contour.add(B);
                this.followContour(contour, z, e, A, 0, f, B);
                continue;
            }
            if (!(zD >= z) || !(z > zC)) continue;
            contour = new Contour(iContour + 1, iContour, z, true);
            contour.add(B);
            contour.add(A);
            this.followContour(contour, z, g, B, 0, h, A);
        }
    }

    private void buildOpenContours(int iContour) {
        double z = this.zContour[iContour];
        block0: for (IQuadEdge p : this.perimeter) {
            this.markAsVisited(p);
            IQuadEdge e = p;
            IQuadEdge f = e.getForward();
            IQuadEdge r = e.getReverse();
            Vertex A = e.getA();
            Vertex B = f.getA();
            Vertex C = r.getA();
            double zA = this.valuator.value(A);
            double zB = this.valuator.value(B);
            double zC = this.valuator.value(C);
            if (zA > z && z > zB) {
                Contour contour = new Contour(iContour + 1, iContour, z, false);
                contour.add(e, zA, zB);
                this.followContour(contour, z, e, null, 0, e, null);
                continue;
            }
            if (zA != z) continue;
            int startSweepIndex = 0;
            IQuadEdge g = r.getDual();
            IQuadEdge h = g.getForward();
            Vertex G = h.getB();
            this.markAsVisited(h);
            while (true) {
                ++startSweepIndex;
                if (zB < z && z < zC) {
                    this.markAsVisited(f);
                    Contour contour = new Contour(iContour + 1, iContour, z, false);
                    contour.add(A);
                    contour.add(f.getDual(), zC, zB);
                    this.followContour(contour, z, e, A, startSweepIndex, f.getDual(), null);
                }
                if (G == null) continue block0;
                double zG = this.valuator.value(G);
                if (zB < z && zC == z && zG >= z) {
                    Contour contour = new Contour(iContour + 1, iContour, z, false);
                    contour.add(A);
                    contour.add(C);
                    this.markAsVisited(g);
                    this.markAsVisited(h);
                    int dualIndex = h.getIndex() ^ 1;
                    if (this.perimeterTermination.get(dualIndex)) {
                        this.finishContour(contour, e, startSweepIndex, h, C);
                    } else {
                        this.followContour(contour, z, e, A, startSweepIndex, h, C);
                    }
                }
                B = C;
                C = G;
                zB = zC;
                zC = zG;
                f = h;
                r = h.getForward();
                g = r.getDual();
                h = g.getForward();
                G = h.getB();
                this.markAsVisited(h);
            }
        }
    }

    private void markAsVisited(IQuadEdge e) {
        int index = e.getIndex();
        this.visited.set(index);
        this.visited.set(index ^ 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean followContour(Contour contour, double z, IQuadEdge startEdge, Vertex startVertex, int startSweepIndex, IQuadEdge terminalEdge, Vertex terminalVertex) {
        Vertex V = terminalVertex;
        IQuadEdge e = terminalEdge;
        this.markAsVisited(e);
        while (true) {
            IQuadEdge f = e.getForward();
            IQuadEdge r = e.getReverse();
            this.markAsVisited(e);
            Vertex A = e.getA();
            Vertex B = f.getA();
            Vertex C = r.getA();
            double zA = this.valuator.value(A);
            double zB = this.valuator.value(B);
            double zC = C == null ? Double.NaN : this.valuator.value(C);
            if (V == null) {
                ++this.nEdgeTransit;
                assert (zA > z && z > zB) : "Entry not on a bracketed descending edge";
                if (zC < z) {
                    e = r.getDual();
                    contour.add(e, zA, zC);
                    this.markAsVisited(e);
                } else if (zC > z) {
                    e = f.getDual();
                    contour.add(e, zC, zB);
                    this.markAsVisited(e);
                } else {
                    if (zC != z) return false;
                    e = r;
                    V = C;
                    contour.add(C);
                }
            } else {
                ++this.nVertexTransit;
                IQuadEdge e0 = e;
                IQuadEdge g = e;
                while (true) {
                    g = g.getForwardFromDual();
                    IQuadEdge h = g.getForward();
                    IQuadEdge k = h.getForward();
                    Vertex K = h.getA();
                    Vertex G = h.getB();
                    double zK = this.valuator.value(K);
                    double zG = this.valuator.value(G);
                    this.markAsVisited(g);
                    this.markAsVisited(h);
                    this.markAsVisited(k);
                    if (zG > z && z > zK) {
                        e = h.getDual();
                        V = null;
                        contour.add(e, zG, zK);
                        break;
                    }
                    if (zG == z && z > zK) {
                        contour.add(G);
                        e = f;
                        V = G;
                        break;
                    }
                    f = h;
                }
                assert (!e0.equals(e)) : "trans-vertex search loop failed";
            }
            if (V == null) {
                if (contour.isClosed()) {
                    if (!startEdge.equals(e) || startVertex != null) continue;
                    this.finishContour(contour, startEdge, startSweepIndex, e, V);
                    return true;
                }
                C = e.getForward().getB();
                if (C != null) continue;
                this.finishContour(contour, startEdge, startSweepIndex, e, V);
                return true;
            }
            if (contour.isClosed() && V == startVertex) {
                this.finishContour(contour, startEdge, 0, e, V);
                return true;
            }
            int dualIndex = e.getIndex() ^ 1;
            if (this.perimeterTermination.get(dualIndex)) break;
        }
        this.finishContour(contour, startEdge, startSweepIndex, e, V);
        return true;
    }

    private void finishContour(Contour contour, IQuadEdge startEdge, int startSweepIndex, IQuadEdge terminalEdge, Vertex terminalVertex) {
        contour.complete();
        if (contour.isClosed()) {
            this.closedContourList.add(contour);
            return;
        }
        this.openContourList.add(contour);
        int startIndex = startEdge.getIndex();
        PerimeterLink pStart = this.perimeterMap.get(startIndex);
        pStart.addContourTip(contour, true, startSweepIndex);
        if (terminalVertex == null) {
            int termIndex = terminalEdge.getIndex() ^ 1;
            PerimeterLink pTerm = this.perimeterMap.get(termIndex);
            pTerm.addContourTip(contour, false, 0);
        } else {
            int terminalSweepIndex = 0;
            IQuadEdge s = terminalEdge;
            while (true) {
                ++terminalSweepIndex;
                IQuadEdge n = s.getForwardFromDual();
                Vertex B = n.getB();
                if (B == null) break;
                s = n;
            }
            int termIndex = s.getIndex();
            PerimeterLink pTerm = this.perimeterMap.get(termIndex);
            pTerm.addContourTip(contour, false, terminalSweepIndex);
        }
    }

    private void buildRegions() {
        long time0 = System.nanoTime();
        this.buildRegionsUsingPerimeter();
        for (Contour contour : this.closedContourList) {
            ContourRegion region = new ContourRegion(contour);
            this.regionList.add(region);
        }
        this.organizeNestedRegions();
        long time1 = System.nanoTime();
        this.timeToBuildRegions = time1 - time0;
    }

    private void buildRegionsUsingPerimeter() {
        if (this.openContourList.isEmpty()) {
            Vertex A = this.perimeter.get(0).getA();
            double z = this.valuator.value(A);
            int leftIndex = this.zContour.length;
            for (int i = 0; i < this.zContour.length; ++i) {
                if (!(this.zContour[i] > z)) continue;
                leftIndex = i;
                break;
            }
            Contour contour = new Contour(leftIndex, -1, z, true);
            for (IQuadEdge p : this.perimeter) {
                A = p.getA();
                contour.add(A.getX(), A.getY());
            }
            contour.complete();
            this.perimeterContourList.add(contour);
            ContourRegion region = new ContourRegion(contour);
            this.regionList.add(region);
            return;
        }
        for (PerimeterLink pLink : this.perimeterList) {
            pLink.prependThroughVertexTips();
        }
        for (PerimeterLink pLink : this.perimeterList) {
            if (pLink.tip0 == null) continue;
            TipLink tip = pLink.tip0;
            while (tip != null) {
                ContourRegion region;
                List<ContourRegionMember> mList;
                double z;
                if (tip.start) {
                    if (!tip.contour.traversedForward) {
                        int leftIndex = tip.contour.leftIndex;
                        z = tip.contour.z;
                        mList = this.traverseFromTipLink(tip, leftIndex, z, true);
                        region = new ContourRegion(mList, leftIndex);
                        this.regionList.add(region);
                    }
                } else if (!tip.contour.traversedBackward) {
                    int rightIndex = tip.contour.rightIndex;
                    z = tip.contour.z;
                    mList = this.traverseFromTipLink(tip, rightIndex, z, false);
                    region = new ContourRegion(mList, rightIndex);
                    this.regionList.add(region);
                }
                tip = tip.next;
            }
        }
    }

    private List<ContourRegionMember> traverseFromTipLink(TipLink tipLink0, int leftIndex, double z, boolean forward0) {
        ArrayList<ContourRegionMember> mList = new ArrayList<ContourRegionMember>();
        TipLink node = tipLink0;
        boolean forward = forward0;
        do {
            double y;
            double x;
            Contour contour = node.contour;
            ContourRegionMember member = new ContourRegionMember(contour, forward);
            mList.add(member);
            Contour boundaryContour = new Contour(leftIndex, -1, z, false);
            this.perimeterContourList.add(boundaryContour);
            member = new ContourRegionMember(boundaryContour, true);
            mList.add(member);
            if (forward) {
                contour.traversedForward = true;
                node = contour.terminalTip;
                x = contour.xy[contour.xy.length - 2];
                y = contour.xy[contour.xy.length - 1];
            } else {
                contour.traversedBackward = true;
                node = contour.startTip;
                x = contour.xy[0];
                y = contour.xy[1];
            }
            boundaryContour.add(x, y);
            if (node.next != null) {
                node = node.next;
            } else {
                PerimeterLink pLink = node.pLink.next;
                IQuadEdge pEdge = pLink.edge;
                Vertex A = pEdge.getA();
                boundaryContour.add(A.getX(), A.getY());
                while (pLink.tip0 == null) {
                    pLink = pLink.next;
                    pEdge = pLink.edge;
                    A = pEdge.getA();
                    boundaryContour.add(A.getX(), A.getY());
                }
                node = pLink.tip0;
            }
            contour = node.contour;
            if (node.start) {
                forward = true;
                x = contour.xy[0];
                y = contour.xy[1];
            } else {
                forward = false;
                x = contour.xy[contour.xy.length - 2];
                y = contour.xy[contour.xy.length - 1];
            }
            boundaryContour.add(x, y);
            boundaryContour.complete();
        } while (node != tipLink0);
        return mList;
    }

    private void organizeNestedRegions() {
        int nRegion = this.regionList.size();
        if (nRegion < 2) {
            return;
        }
        Collections.sort(this.regionList, (o1, o2) -> Double.compare(o2.absArea, o1.absArea));
        for (int i = 0; i < nRegion - 1; ++i) {
            ContourRegion rI = this.regionList.get(i);
            double[] xy = rI.getXY();
            for (int j = i + 1; j < nRegion; ++j) {
                Point2D testPoint;
                ContourRegion rJ = this.regionList.get(j);
                if (rJ.contourRegionType == ContourRegion.ContourRegionType.Primary || !rI.isPointInsideRegion(xy, (testPoint = rJ.getTestPoint()).getX(), testPoint.getY())) continue;
                rJ.setParent(rI);
            }
        }
        for (ContourRegion region : this.regionList) {
            if (region.parent == null) {
                this.outerRegions.add(region);
                continue;
            }
            region.parent.addChild(region);
        }
    }

    private int countPoints(List<Contour> cList) {
        int n = 0;
        for (Contour c : cList) {
            n += c.size();
        }
        return n;
    }

    public void summarize(PrintStream ps, double areaFactor) {
        ps.format("Summary of statistics for contour building%n", new Object[0]);
        ps.format("Time to build contours %7.1f ms%n", (double)this.timeToBuildContours / 1000000.0);
        ps.format("Time to build regions  %7.1f ms%n", (double)this.timeToBuildRegions / 1000000.0);
        ps.format("Open contours:      %8d,  %8d points%n", this.openContourList.size(), this.countPoints(this.openContourList));
        ps.format("Closed contours:    %8d,  %8d points%n", this.closedContourList.size(), this.countPoints(this.closedContourList));
        ps.format("Regions:            %8d%n", this.regionList.size());
        ps.format("Outer Regions:      %8d%n", this.outerRegions.size());
        ps.format("Edge transits:      %8d%n", this.nEdgeTransit);
        ps.format("Vertex transits:    %8d%n", this.nVertexTransit);
        ps.format("%n", new Object[0]);
    }

    private static class DefaultValuator
    implements IVertexValuator {
        private DefaultValuator() {
        }

        @Override
        public double value(Vertex v) {
            assert (v != null) : "Internal method failure, accessing value for null vertex";
            double z = v.getZ();
            if (Double.isNaN(z)) {
                throw new IllegalArgumentException("Input includes vertices with NaN z values");
            }
            return z;
        }
    }
}

