/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class BufferedRandomAccessFile
implements Closeable,
AutoCloseable,
DataInput,
DataOutput {
    private static final int BUFFER_SIZE = 8192;
    final File file;
    final ByteBuffer buffer = ByteBuffer.allocateDirect(8192).order(ByteOrder.LITTLE_ENDIAN);
    RandomAccessFile raf;
    FileChannel rafChannel;
    long virtualLength;
    long virtualPosition;
    long truePosition;
    boolean writeDataIsInBuffer;
    boolean readDataIsInBuffer;

    private BufferedRandomAccessFile() {
        this.file = null;
    }

    public BufferedRandomAccessFile(String fileName, String mode) throws IOException {
        if (fileName == null) {
            throw new NullPointerException();
        }
        if (fileName.length() == 0) {
            throw new IllegalArgumentException("Null length file name not allowed");
        }
        this.file = new File(fileName);
        this.openFile(this.file, mode);
    }

    public BufferedRandomAccessFile(File file, String mode) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.openFile(file, mode);
    }

    private void openFile(File file, String mode) throws FileNotFoundException, IOException {
        if (mode == null) {
            throw new NullPointerException();
        }
        this.raf = new RandomAccessFile(file, mode);
        this.rafChannel = this.raf.getChannel();
        this.virtualLength = this.raf.length();
        this.virtualPosition = 0L;
        this.raf.seek(0L);
        this.truePosition = 0L;
        this.readDataIsInBuffer = false;
        this.writeDataIsInBuffer = false;
    }

    private void prepRead(int nBytesToRead) throws IOException {
        int nBytesRead;
        int nBytes = nBytesToRead;
        assert (!this.readDataIsInBuffer || !this.writeDataIsInBuffer) : "Read/Write conflict";
        if (this.readDataIsInBuffer) {
            int remaining = this.buffer.remaining();
            if (remaining >= nBytesToRead) {
                this.virtualPosition += (long)nBytesToRead;
                return;
            }
            if (remaining == 0) {
                this.buffer.clear();
            } else {
                this.buffer.compact();
                this.virtualPosition += (long)remaining;
                nBytes -= remaining;
            }
        } else if (this.writeDataIsInBuffer) {
            this.flushWrite();
        } else {
            this.buffer.clear();
            if (this.raf == null) {
                throw new IOException("Reading from a file that was closed");
            }
        }
        if (this.virtualPosition >= this.virtualLength) {
            throw new EOFException();
        }
        if (this.virtualPosition != this.truePosition) {
            this.rafChannel.position(this.virtualPosition);
            this.truePosition = this.virtualPosition;
        }
        if ((nBytesRead = this.rafChannel.read(this.buffer)) < 0) {
            throw new EOFException();
        }
        this.buffer.flip();
        this.readDataIsInBuffer = true;
        this.truePosition += (long)nBytesRead;
        this.virtualPosition += (long)nBytes;
    }

    private void flushWrite() throws IOException {
        long filePos = this.virtualPosition - (long)this.buffer.position();
        this.buffer.flip();
        this.rafChannel.write(this.buffer, filePos);
        this.buffer.clear();
        this.writeDataIsInBuffer = false;
        this.readDataIsInBuffer = false;
        this.truePosition = -1L;
    }

    private void prepWrite(int nBytesToWrite) throws IOException {
        assert (!this.readDataIsInBuffer || !this.writeDataIsInBuffer) : "Write/Read conflict";
        if (this.raf == null) {
            throw new IOException("Writing to a file that was closed");
        }
        if (!this.writeDataIsInBuffer) {
            this.buffer.clear();
            this.readDataIsInBuffer = false;
        } else {
            int remaining = this.buffer.remaining();
            if (remaining < nBytesToWrite) {
                if (this.writeDataIsInBuffer) {
                    this.flushWrite();
                }
                this.buffer.clear();
            }
        }
        this.writeDataIsInBuffer = true;
        this.virtualPosition += (long)nBytesToWrite;
        if (this.virtualPosition > this.virtualLength) {
            this.virtualLength = this.virtualPosition;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            if (this.writeDataIsInBuffer) {
                this.flushWrite();
            }
            this.raf.close();
        }
        this.raf = null;
        this.rafChannel = null;
        this.buffer.clear();
    }

    public boolean isClosed() {
        return this.raf == null;
    }

    public void flush() throws IOException {
        if (this.raf != null && this.writeDataIsInBuffer) {
            this.flushWrite();
        }
    }

    public long getFileSize() {
        return this.virtualLength;
    }

    public long getFilePosition() {
        return this.virtualPosition;
    }

    public File getFile() {
        return this.file;
    }

    public double leReadDouble() throws IOException {
        this.prepRead(8);
        return this.buffer.getDouble();
    }

    public float leReadFloat() throws IOException {
        this.prepRead(4);
        return this.buffer.getFloat();
    }

    public int leReadInt() throws IOException {
        this.prepRead(4);
        return this.buffer.getInt();
    }

    public long leReadLong() throws IOException {
        this.prepRead(8);
        return this.buffer.getLong();
    }

    public short leReadShort() throws IOException {
        this.prepRead(2);
        return this.buffer.getShort();
    }

    public int leReadUnsignedShort() throws IOException {
        this.prepRead(2);
        return this.buffer.getShort() & 0xFFFF;
    }

    public void leWriteShort(int v) throws IOException {
        this.prepWrite(2);
        this.buffer.putShort((short)(v & 0xFFFF));
    }

    public void leWriteInt(int value) throws IOException {
        this.prepWrite(4);
        this.buffer.putInt(value);
    }

    public void leWriteLong(long v) throws IOException {
        this.prepWrite(8);
        this.buffer.putLong(v);
    }

    public void leWriteFloat(float v) throws IOException {
        this.prepWrite(4);
        this.buffer.putFloat(v);
    }

    public void leWriteDouble(double v) throws IOException {
        this.prepWrite(8);
        this.buffer.putDouble(v);
    }

    public void leReadIntArray(int[] array, int arrayOffset, int length) throws IOException {
        int offset = arrayOffset;
        int nIntToRead = length;
        if (length <= 0) {
            return;
        }
        if (this.readDataIsInBuffer) {
            int remaining = this.buffer.remaining();
            int n = remaining / 4;
            if (n >= nIntToRead) {
                this.buffer.asIntBuffer().get(array, offset, nIntToRead);
                this.buffer.position(this.buffer.position() + nIntToRead * 4);
                this.virtualPosition += (long)(nIntToRead * 4);
                return;
            }
            this.buffer.asIntBuffer().get(array, offset, n);
            this.buffer.position(this.buffer.position() + n * 4);
            offset += n;
            nIntToRead -= n;
            this.virtualPosition += (long)(n * 4);
            if ((remaining -= n * 4) == 0) {
                this.buffer.clear();
            } else {
                this.buffer.compact();
            }
        } else {
            if (this.writeDataIsInBuffer) {
                this.flushWrite();
            }
            if (this.virtualPosition != this.truePosition) {
                this.rafChannel.position(this.virtualPosition);
                this.truePosition = this.virtualPosition;
            }
            this.buffer.clear();
        }
        while (true) {
            if (this.virtualPosition >= this.virtualLength) {
                throw new EOFException();
            }
            int nBytesRead = this.rafChannel.read(this.buffer);
            if (nBytesRead < 0) {
                throw new EOFException();
            }
            this.truePosition += (long)nBytesRead;
            this.buffer.flip();
            this.readDataIsInBuffer = true;
            this.truePosition += (long)nBytesRead;
            int remaining = this.buffer.remaining();
            int n = remaining / 4;
            if (n >= nIntToRead) {
                this.buffer.asIntBuffer().get(array, offset, nIntToRead);
                this.buffer.position(this.buffer.position() + nIntToRead * 4);
                this.virtualPosition += (long)(nIntToRead * 4);
                return;
            }
            this.buffer.asIntBuffer().get(array, offset, n);
            this.buffer.position(this.buffer.position() + n * 4);
            offset += n;
            nIntToRead -= n;
            this.virtualPosition += (long)(n * 4);
            if ((remaining -= n * 4) == 0) {
                this.buffer.clear();
                continue;
            }
            this.buffer.compact();
        }
    }

    public void leReadFloatArray(float[] array, int arrayOffset, int length) throws IOException {
        int offset = arrayOffset;
        int nIntToRead = length;
        if (length <= 0) {
            return;
        }
        if (this.readDataIsInBuffer) {
            int remaining = this.buffer.remaining();
            int n = remaining / 4;
            if (n >= nIntToRead) {
                this.buffer.asFloatBuffer().get(array, offset, nIntToRead);
                this.buffer.position(this.buffer.position() + nIntToRead * 4);
                this.virtualPosition += (long)(nIntToRead * 4);
                return;
            }
            this.buffer.asFloatBuffer().get(array, offset, n);
            this.buffer.position(this.buffer.position() + n * 4);
            offset += n;
            nIntToRead -= n;
            this.virtualPosition += (long)(n * 4);
            if ((remaining -= 4) == 0) {
                this.buffer.clear();
            } else {
                this.buffer.compact();
            }
        } else {
            if (this.writeDataIsInBuffer) {
                this.flushWrite();
            }
            if (this.virtualPosition != this.truePosition) {
                this.rafChannel.position(this.virtualPosition);
                this.truePosition = this.virtualPosition;
            }
            this.buffer.clear();
        }
        while (true) {
            if (this.virtualPosition >= this.virtualLength) {
                throw new EOFException();
            }
            int nBytesRead = this.rafChannel.read(this.buffer);
            if (nBytesRead < 0) {
                throw new EOFException();
            }
            this.truePosition += (long)nBytesRead;
            this.buffer.flip();
            this.readDataIsInBuffer = true;
            this.truePosition += (long)nBytesRead;
            int remaining = this.buffer.remaining();
            int n = remaining / 4;
            if (n >= nIntToRead) {
                this.buffer.asFloatBuffer().get(array, offset, nIntToRead);
                this.buffer.position(this.buffer.position() + nIntToRead * 4);
                this.virtualPosition += (long)(nIntToRead * 4);
                return;
            }
            this.buffer.asFloatBuffer().get(array, offset, n);
            this.buffer.position(this.buffer.position() + n * 4);
            offset += n;
            nIntToRead -= n;
            this.virtualPosition += (long)(n * 4);
            if ((remaining -= n * 4) == 0) {
                this.buffer.clear();
                continue;
            }
            this.buffer.compact();
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.prepRead(1);
        byte test = this.buffer.get();
        return test != 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.prepRead(1);
        return this.buffer.get();
    }

    public char readCharASCII() throws IOException {
        return (char)this.readUnsignedByte();
    }

    @Override
    public void readFully(byte[] array) throws IOException {
        this.readFully(array, 0, array.length);
    }

    @Override
    public void readFully(byte[] array, int arrayOffset, int length) throws IOException {
        int offset = arrayOffset;
        int nByteToRead = length;
        if (length <= 0) {
            return;
        }
        if (this.readDataIsInBuffer) {
            int remaining = this.buffer.remaining();
            int n = remaining;
            if (n >= nByteToRead) {
                this.buffer.get(array, offset, nByteToRead);
                this.virtualPosition += (long)nByteToRead;
                return;
            }
            this.buffer.get(array, offset, n);
            offset += n;
            nByteToRead -= n;
            this.virtualPosition += (long)n;
            if ((remaining -= n) == 0) {
                this.buffer.clear();
            } else {
                this.buffer.compact();
            }
        } else {
            if (this.writeDataIsInBuffer) {
                this.flushWrite();
            }
            if (this.virtualPosition != this.truePosition) {
                this.rafChannel.position(this.virtualPosition);
                this.truePosition = this.virtualPosition;
            }
            this.buffer.clear();
        }
        while (true) {
            int remaining;
            if (this.virtualPosition >= this.virtualLength) {
                throw new EOFException();
            }
            int nBytesRead = this.rafChannel.read(this.buffer);
            if (nBytesRead < 0) {
                throw new EOFException();
            }
            this.truePosition += (long)nBytesRead;
            this.buffer.flip();
            this.readDataIsInBuffer = true;
            this.truePosition += (long)nBytesRead;
            int n = remaining = this.buffer.remaining();
            if (n >= nByteToRead) {
                this.buffer.get(array, offset, nByteToRead);
                this.virtualPosition += (long)nByteToRead;
                return;
            }
            this.buffer.get(array, offset, n);
            offset += n;
            nByteToRead -= n;
            this.virtualPosition += (long)n;
            if ((remaining -= n) == 0) {
                this.buffer.clear();
                continue;
            }
            this.buffer.compact();
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.prepRead(1);
        int i = this.buffer.get() & 0xFF;
        return i;
    }

    public int readASCII(StringBuilder builder, int nBytesToRead) throws IOException {
        int nValid = 0;
        int nRead = 0;
        while (nRead < nBytesToRead) {
            int b = this.readUnsignedByte();
            ++nRead;
            if (b == 0) break;
            if (b < 0) {
                b += 256;
            }
            nValid = nRead;
            char c = (char)b;
            builder.append(c);
        }
        if (nRead < nBytesToRead) {
            this.skipBytes(nBytesToRead - nRead);
        }
        return nValid;
    }

    public String readASCII(int nBytesToRead) throws IOException {
        if (nBytesToRead <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(nBytesToRead);
        this.readASCII(builder, nBytesToRead);
        return builder.toString();
    }

    public void seek(long position) throws IOException {
        if (this.writeDataIsInBuffer) {
            this.flushWrite();
        } else if (this.readDataIsInBuffer) {
            int bufferPosition = this.buffer.position();
            int bufferRemaining = this.buffer.remaining();
            long pos0 = this.virtualPosition - (long)bufferPosition;
            long pos1 = this.virtualPosition + (long)bufferRemaining - 1L;
            if (pos0 <= position && position <= pos1) {
                this.virtualPosition = position;
                long bufferPos = position - pos0;
                this.buffer.position((int)bufferPos);
                return;
            }
        }
        this.readDataIsInBuffer = false;
        this.buffer.clear();
        this.virtualPosition = position;
        this.truePosition = position;
        this.rafChannel.position(position);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (this.readDataIsInBuffer && this.buffer.remaining() > n) {
            int position = this.buffer.position();
            this.buffer.position(position + n);
            this.virtualPosition += (long)n;
            return n;
        }
        this.seek(this.virtualPosition + (long)n);
        return n;
    }

    @Override
    public void writeByte(int value) throws IOException {
        this.prepWrite(1);
        this.buffer.put((byte)(value & 0xFF));
    }

    public void writeFully(byte[] array) throws IOException {
        this.writeFully(array, 0, array.length);
    }

    public void writeFully(byte[] array, int arrayOffset, int length) throws IOException {
        assert (!this.readDataIsInBuffer || !this.writeDataIsInBuffer) : "Write/Read conflict";
        int offset = arrayOffset;
        if (length == 0) {
            return;
        }
        if (array == null) {
            throw new NullPointerException();
        }
        if (array.length < offset + length) {
            throw new IllegalArgumentException("Input array is smaller than required by specified parameters");
        }
        if (this.raf == null) {
            throw new IOException("Reading from a file that was closed");
        }
        if (this.readDataIsInBuffer) {
            this.buffer.clear();
            this.readDataIsInBuffer = false;
        }
        this.writeDataIsInBuffer = true;
        int needed = length;
        while (needed > 0) {
            int nCopy;
            int remaining = this.buffer.remaining();
            if (remaining == 0) {
                int pos = this.buffer.position();
                this.buffer.flip();
                this.rafChannel.write(this.buffer, this.virtualPosition - (long)pos);
                this.buffer.clear();
                remaining = this.buffer.remaining();
                this.truePosition = -1L;
            }
            if ((nCopy = needed) > remaining) {
                nCopy = remaining;
            }
            this.buffer.put(array, offset, nCopy);
            needed -= nCopy;
            offset += nCopy;
            this.virtualPosition += (long)nCopy;
            if (this.virtualPosition <= this.virtualLength) continue;
            this.virtualLength = this.virtualPosition;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.prepWrite(1);
        this.buffer.put((byte)(b & 0xFF));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeFully(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.writeFully(b, offset, length);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.prepWrite(1);
        if (v) {
            this.buffer.put((byte)1);
        } else {
            this.buffer.put((byte)0);
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.length() == 0) {
            return;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c;
            char x = c = s.charAt(i);
            this.writeByte(x);
        }
    }

    public void writeASCII(String s, int nBytes) throws IOException {
        if (s == null) {
            throw new NullPointerException();
        }
        int n = s.length();
        if (n > nBytes) {
            n = nBytes;
        }
        byte[] b = new byte[nBytes];
        for (int i = 0; i < n; ++i) {
            char c;
            char x = c = s.charAt(i);
            b[i] = (byte)(x & 0xFF);
        }
        this.write(b);
    }

    @Override
    public void writeShort(int s) throws IOException {
        this.prepWrite(2);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.putShort((short)s);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.prepWrite(4);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.putInt(value);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("Null string passed to writeUTF");
        }
        byte[] b = s.getBytes("UTF-8");
        if (b.length > 65535) {
            throw new UTFDataFormatException("String passed to writeUTF exceeds 65535 byte maximum");
        }
        this.writeShort(b.length);
        this.writeFully(b, 0, b.length);
    }

    @Override
    public double readDouble() throws IOException {
        this.prepRead(8);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        double test = this.buffer.getDouble();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        return test;
    }

    @Override
    public float readFloat() throws IOException {
        this.prepRead(4);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        float test = this.buffer.getFloat();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        return test;
    }

    @Override
    public int readInt() throws IOException {
        this.prepRead(4);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int test = this.buffer.getInt();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        return test;
    }

    @Override
    public long readLong() throws IOException {
        this.prepRead(8);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        long test = this.buffer.getLong();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        return test;
    }

    @Override
    public short readShort() throws IOException {
        this.prepRead(2);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        short test = this.buffer.getShort();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        return test;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.prepRead(2);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        short test = this.buffer.getShort();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        return test & 0xFFFF;
    }

    @Override
    public String readUTF() throws IOException {
        int length = this.readUnsignedShort();
        if (length == 0) {
            return "";
        }
        byte[] b = new byte[length];
        this.readFully(b, 0, length);
        return new String(b, "UTF-8");
    }

    @Override
    public String readLine() throws IOException {
        byte b;
        StringBuilder sb = new StringBuilder();
        boolean foundAtLeastOneByte = false;
        while ((b = this.readByte()) >= 0) {
            foundAtLeastOneByte = true;
            if (b == 10 || b == 0) break;
            if (b == 13) continue;
            sb.append((char)b);
        }
        if (foundAtLeastOneByte) {
            return sb.toString();
        }
        return null;
    }

    public void printDiagnostics(PrintStream ps) {
        long position = 0L;
        long length = 0L;
        if (this.raf == null) {
            ps.println("File is closed");
        } else {
            try {
                position = this.rafChannel.position();
                length = this.raf.length();
            }
            catch (IOException ioex) {
                ps.println("I/O Exception accessing file " + ioex.getMessage());
            }
        }
        ps.format("Virtual Length:      %12d%n", this.virtualLength);
        ps.format("Virtual Position:    %12d%n", this.virtualPosition);
        ps.format("RAF Channel Position:%12d%n", this.truePosition);
        ps.format("Actual Position:     %12d%n", position);
        ps.format("Actual Length:       %12d%n", length);
        ps.format("Buffer position:     %12d%n", this.buffer.position());
        ps.format("Buffer remainder     %12d%n", this.buffer.remaining());
        ps.format("Write data buffered: %12s%n", this.writeDataIsInBuffer ? "true" : "false");
        ps.format("Read data buffered:  %12s%n", this.readDataIsInBuffer ? "true" : "false");
    }

    @Override
    public char readChar() throws IOException {
        byte a = this.readByte();
        byte b = this.readByte();
        return (char)(a << 8 | b & 0xFF);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.write(v >> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.prepWrite(8);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.putLong(v);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.prepWrite(4);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.putFloat(v);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.prepWrite(8);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.putDouble(v);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void writeChars(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("Null string passed to writeChars");
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.writeChar(c);
        }
    }
}

