/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tinfour.common.Vertex;
import org.tinfour.common.VertexMergerGroup;
import org.tinfour.utils.Tincalc;

public class NearestNeighborPointCollector {
    private static final int TARGET_SAMPLES_PER_BIN = 200;
    private static final int MAX_BIN_COUNT = 10000;
    final int nBins;
    final Vertex[][] bins;
    final double xmin;
    final double xmax;
    final double ymin;
    final double ymax;
    final double sBin;
    final int nRow;
    final int nCol;
    final int nTier;
    VertexMergerGroup.ResolutionRule resolutionRule;

    public NearestNeighborPointCollector(List<Vertex> vList, boolean mergeDuplicates) {
        block17: {
            int iCol;
            int iRow;
            double y;
            double x;
            int[] iCount;
            block16: {
                this.resolutionRule = VertexMergerGroup.ResolutionRule.MinValue;
                Vertex a = vList.get(0);
                double x0 = a.getX();
                double x1 = a.getX();
                double y0 = a.getY();
                double y1 = a.getY();
                for (Vertex v : vList) {
                    double x2 = v.getX();
                    double y2 = v.getY();
                    if (x2 < x0) {
                        x0 = x2;
                    } else if (x2 > x1) {
                        x1 = x2;
                    }
                    if (y2 < y0) {
                        y0 = y2;
                        continue;
                    }
                    if (!(y2 > y1)) continue;
                    y1 = y2;
                }
                this.xmin = x0;
                this.xmax = x1;
                this.ymin = y0;
                this.ymax = y1;
                double xDelta = this.xmax - this.xmin;
                double yDelta = this.ymax - this.ymin;
                int nV = vList.size();
                double nBinEst = (double)nV / 200.0;
                if (nBinEst < 1.0) {
                    this.sBin = 1.01 * Math.max(xDelta, yDelta);
                    this.nRow = 1;
                    this.nCol = 1;
                    this.nTier = 0;
                } else {
                    if (nBinEst > 10000.0) {
                        nBinEst = 10000.0;
                    }
                    double area = xDelta * yDelta;
                    this.sBin = Math.sqrt(area / nBinEst);
                    this.nRow = (int)Math.ceil(yDelta / this.sBin + 1.0E-4);
                    this.nCol = (int)Math.ceil(xDelta / this.sBin + 1.0E-4);
                    this.nTier = this.nRow > this.nCol ? this.nRow : this.nCol;
                }
                this.nBins = this.nRow * this.nCol;
                iCount = new int[this.nBins];
                for (Vertex v : vList) {
                    x = v.getX();
                    y = v.getY();
                    iRow = (int)((y - this.ymin) / this.sBin);
                    iCol = (int)((x - this.xmin) / this.sBin);
                    int n = iRow * this.nCol + iCol;
                    iCount[n] = iCount[n] + 1;
                }
                this.bins = new Vertex[this.nBins][];
                for (int i = 0; i < this.nBins; ++i) {
                    this.bins[i] = new Vertex[iCount[i]];
                    iCount[i] = 0;
                }
                if (!mergeDuplicates) break block16;
                double averageSpacing = Tincalc.sampleSpacing(xDelta * yDelta, nV);
                double mergeThreshold = averageSpacing / 100000.0;
                double m2 = mergeThreshold * mergeThreshold;
                boolean mergeFound = false;
                block3: for (Vertex v : vList) {
                    double x3 = v.getX();
                    double y3 = v.getY();
                    int iRow2 = (int)((y3 - this.ymin) / this.sBin);
                    int iCol2 = (int)((x3 - this.xmin) / this.sBin);
                    int index = iRow2 * this.nCol + iCol2;
                    int n = iCount[index];
                    Vertex[] b = this.bins[index];
                    for (int i = 0; i < n; ++i) {
                        VertexMergerGroup g;
                        double dy;
                        double dx = x3 - b[i].getX();
                        if (!(dx * dx + (dy = y3 - b[i].getY()) * dy < m2)) continue;
                        mergeFound = true;
                        if (b[i] instanceof VertexMergerGroup) {
                            g = (VertexMergerGroup)b[i];
                        } else {
                            g = new VertexMergerGroup(b[i]);
                            g.setResolutionRule(this.resolutionRule);
                        }
                        g.addVertex(v);
                        continue block3;
                    }
                    b[n] = v;
                    int n2 = index;
                    iCount[n2] = iCount[n2] + 1;
                }
                if (!mergeFound) break block17;
                for (int i = 0; i < this.nBins; ++i) {
                    if (iCount[i] >= this.bins[i].length) continue;
                    this.bins[i] = Arrays.copyOf(this.bins[i], iCount[i]);
                }
                break block17;
            }
            for (Vertex v : vList) {
                x = v.getX();
                y = v.getY();
                iRow = (int)((y - this.ymin) / this.sBin);
                iCol = (int)((x - this.xmin) / this.sBin);
                int index = iRow * this.nCol + iCol;
                this.bins[index][iCount[index]] = v;
                int n = index;
                iCount[n] = iCount[n] + 1;
            }
        }
    }

    public void setResolutionRule(VertexMergerGroup.ResolutionRule rule) {
        if (rule == null || rule == this.resolutionRule) {
            return;
        }
        this.resolutionRule = rule;
        for (int i = 0; i < this.nBins; ++i) {
            Vertex[] vArray;
            for (Vertex v : vArray = this.bins[i]) {
                if (!(v instanceof VertexMergerGroup)) continue;
                ((VertexMergerGroup)v).setResolutionRule(rule);
            }
        }
    }

    private int limitedIndex(int index, int n) {
        if (index < 0) {
            return 0;
        }
        if (index >= n) {
            return n - 1;
        }
        return index;
    }

    private boolean isBinWorthSearching(int n, int k, double x, double y, int iRow, int iCol, double[] d) {
        double dMax;
        double dc;
        double cy;
        if (n < k) {
            return true;
        }
        double cx = x - (this.xmin + (double)iCol * this.sBin);
        if (cx > 0.0) {
            cx = cx > this.sBin ? (cx -= this.sBin) : 0.0;
        }
        if ((cy = y - (this.ymin + (double)iRow * this.sBin)) > 0.0) {
            cy = cy > this.sBin ? (cy -= this.sBin) : 0.0;
        }
        return (dc = cx * cx + cy * cy) <= 1.000001 * (dMax = d[n - 1]);
    }

    int gather(int pn, int k, double x, double y, double[] d, Vertex[] v, Vertex[] bin) {
        int j;
        Vertex vTest;
        double dTest;
        int index;
        if (bin.length == 0) {
            return pn;
        }
        int n = pn;
        int i = 0;
        if (n < k) {
            if (n == 0) {
                d[0] = bin[0].getDistanceSq(x, y);
                v[0] = bin[0];
                n = 1;
                i = 1;
            }
            while (i < bin.length && n < k) {
                if ((index = Arrays.binarySearch(d, 0, n, dTest = (vTest = bin[i++]).getDistanceSq(x, y))) < 0) {
                    index = -(index + 1);
                }
                if (index >= n) {
                    d[n] = dTest;
                    v[n] = vTest;
                } else {
                    for (j = n; j > index; --j) {
                        d[j] = d[j - 1];
                        v[j] = v[j - 1];
                    }
                    d[index] = dTest;
                    v[index] = vTest;
                }
                ++n;
            }
        }
        while (i < bin.length) {
            int n2 = i++;
            vTest = bin[n2];
            dTest = vTest.getDistanceSq(x, y);
            if (!(dTest < d[n - 1])) continue;
            index = Arrays.binarySearch(d, 0, n - 1, dTest);
            if (index < 0) {
                index = -(index + 1);
            }
            for (j = n - 1; j > index; --j) {
                d[j] = d[j - 1];
                v[j] = v[j - 1];
            }
            d[index] = dTest;
            v[index] = vTest;
        }
        return n;
    }

    public int getNearestNeighbors(double x, double y, int k, double[] d, Vertex[] v) {
        boolean[] binSearched = new boolean[this.bins.length];
        int iRow = (int)((y - this.ymin) / this.sBin);
        int iCol = (int)((x - this.xmin) / this.sBin);
        iRow = this.limitedIndex(iRow, this.nRow);
        iCol = this.limitedIndex(iCol, this.nCol);
        int bIndex = iRow * this.nCol + iCol;
        binSearched[bIndex] = true;
        int n = this.gather(0, k, x, y, d, v, this.bins[bIndex]);
        for (int iTier = 1; iTier < this.nTier; ++iTier) {
            boolean searched = n < k;
            int i0 = this.limitedIndex(iRow - iTier, this.nRow);
            int i1 = this.limitedIndex(iRow + iTier, this.nRow);
            int j0 = this.limitedIndex(iCol - iTier, this.nCol);
            int j1 = this.limitedIndex(iCol + iTier, this.nCol);
            for (int i = i0; i <= i1; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    bIndex = i * this.nCol + j;
                    if (binSearched[bIndex]) continue;
                    binSearched[bIndex] = true;
                    if (!this.isBinWorthSearching(n, k, x, y, i, j, d)) continue;
                    searched = true;
                    n = this.gather(n, k, x, y, d, v, this.bins[bIndex]);
                }
            }
            if (!searched) break;
        }
        return n;
    }

    public List<Vertex> getVertices() {
        int n = 0;
        for (int i = 0; i < this.nBins; ++i) {
            n += this.bins[i].length;
        }
        ArrayList<Vertex> list = new ArrayList<Vertex>(n);
        for (int i = 0; i < this.nBins; ++i) {
            list.addAll(Arrays.asList(this.bins[i]));
        }
        return list;
    }
}

