/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.util.ArrayDeque;
import java.util.function.Consumer;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Vertex;

public final class TriangleCollector {
    private static final int INT_BITS = 32;
    private static final int MOD_BY_32 = 31;
    private static final int DIV_BY_32 = 5;
    private static final int N_SIDES = 2;
    private static final int BIT1 = 1;

    private TriangleCollector() {
        throw new InternalError("Utility class - should not reach here");
    }

    private static int getMarkBit(int[] map, IQuadEdge edge) {
        int index = edge.getIndex();
        return map[index >> 5] >> (index & 0x1F) & 1;
    }

    private static void setMarkBit(int[] map, IQuadEdge edge) {
        int index = edge.getIndex();
        int n = index >> 5;
        map[n] = map[n] | 1 << (index & 0x1F);
    }

    public static void visitTrianglesConstrained(IIncrementalTin tin, Consumer<Vertex[]> consumer) {
        if (tin.isBootstrapped()) {
            for (SimpleTriangle t : tin.triangles()) {
                IConstraint constraint = t.getContainingRegion();
                if (constraint == null || !constraint.definesConstrainedRegion()) continue;
                Vertex[] v = new Vertex[]{t.getVertexA(), t.getVertexB(), t.getVertexC()};
                consumer.accept(v);
            }
        }
    }

    public static void visitTrianglesForConstrainedRegion(IConstraint constraint, Consumer<Vertex[]> consumer) {
        IIncrementalTin tin = constraint.getManagingTin();
        if (tin == null) {
            throw new IllegalArgumentException("Constraint is not under TIN management");
        }
        if (!constraint.definesConstrainedRegion()) {
            throw new IllegalArgumentException("Constraint does not define constrained region");
        }
        IQuadEdge linkEdge = constraint.getConstraintLinkingEdge();
        if (linkEdge == null) {
            throw new IllegalArgumentException("Constraint does not have linking edge");
        }
        int maxMapIndex = tin.getMaximumEdgeAllocationIndex() + 2;
        int mapSize = (maxMapIndex + 32 - 1) / 32;
        int[] map = new int[mapSize];
        if (TriangleCollector.getMarkBit(map, linkEdge) == 0) {
            TriangleCollector.visitTrianglesUsingStack(linkEdge, map, consumer);
        }
    }

    private static void visitTrianglesUsingStack(IQuadEdge firstEdge, int[] map, Consumer<Vertex[]> consumer) {
        ArrayDeque<IQuadEdge> deque = new ArrayDeque<IQuadEdge>();
        deque.push(firstEdge);
        while (!deque.isEmpty()) {
            IQuadEdge e = (IQuadEdge)deque.pop();
            if (TriangleCollector.getMarkBit(map, e) != 0) continue;
            IQuadEdge f = e.getForward();
            IQuadEdge r = e.getReverse();
            TriangleCollector.setMarkBit(map, e);
            TriangleCollector.setMarkBit(map, f);
            TriangleCollector.setMarkBit(map, r);
            Vertex a = e.getA();
            Vertex b = f.getA();
            Vertex c = r.getA();
            if (a != null && b != null && c != null) {
                consumer.accept(new Vertex[]{a, b, c});
            }
            IQuadEdge df = f.getDual();
            IQuadEdge dr = r.getDual();
            if (TriangleCollector.getMarkBit(map, df) == 0 && !f.isConstrainedRegionBorder()) {
                deque.push(df);
            }
            if (TriangleCollector.getMarkBit(map, dr) != 0 || r.isConstrainedRegionBorder()) continue;
            deque.push(dr);
        }
    }

    public static void visitTriangles(IIncrementalTin tin, Consumer<Vertex[]> consumer) {
        if (!tin.isBootstrapped()) {
            return;
        }
        for (SimpleTriangle t : tin.triangles()) {
            Vertex[] v = new Vertex[]{t.getVertexA(), t.getVertexB(), t.getVertexC()};
            consumer.accept(v);
        }
    }

    public static void visitSimpleTriangles(IIncrementalTin tin, Consumer<SimpleTriangle> consumer) {
        if (!tin.isBootstrapped()) {
            return;
        }
        for (SimpleTriangle t : tin.triangles()) {
            consumer.accept(t);
        }
    }
}

