/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.matrix;

import Jama.Matrix;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.Dump;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Reporter;
import org.nlogo.core.CompilerException;
import org.nlogo.core.ExtensionObject;
import org.nlogo.core.LogoList;
import org.nlogo.core.Primitive;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;
import org.nlogo.extensions.matrix.Operator;
import org.nlogo.nvm.AnonymousReporter;
import scala.collection.Iterable;

public class MatrixExtension
extends DefaultClassManager {
    private static final WeakHashMap<LogoMatrix, Long> matrices = new WeakHashMap();
    private static long next = 0L;
    public static final Operator timesElementsOp = new TimesElementsOp();
    public static final Operator timesOp = new TimesOp();
    public static final Operator plusOp = new PlusOp();
    public static final Operator minusOp = new MinusOp();

    public void clearAll() {
        matrices.clear();
        next = 0L;
    }

    public StringBuilder exportWorld() {
        StringBuilder buffer = new StringBuilder();
        for (LogoMatrix mat : matrices.keySet()) {
            buffer.append(Dump.csv().encode(Dump.extensionObject((ExtensionObject)mat, (boolean)true, (boolean)true, (boolean)false)) + "\n");
        }
        return buffer;
    }

    public void importWorld(List<String[]> lines, ExtensionManager reader, ImportErrorHandler handler) {
        for (String[] line : lines) {
            try {
                reader.readFromString(line[0]);
            }
            catch (CompilerException e) {
                handler.showError("Error importing matrices", e.getMessage(), "This matrix will be ignored");
            }
        }
    }

    public ExtensionObject readExtensionObject(ExtensionManager reader, String typeName, String value) throws CompilerException, ExtensionException {
        String[] s = value.split(":");
        long id = Long.parseLong(s[0]);
        LogoMatrix mat = this.getOrCreateMatrixFromId(id);
        if (s.length > 1) {
            LogoList nestedL = (LogoList)reader.readFromString(s[1]);
            double[][] newData = MatrixExtension.convertNestedLogoListToArray(nestedL);
            mat.replaceData(newData);
        }
        return mat;
    }

    private static double[][] convertNestedLogoListToArray(LogoList nestedLogoList) throws ExtensionException {
        int numRows = nestedLogoList.size();
        if (numRows == 0) {
            throw new ExtensionException("input list was empty");
        }
        int numCols = -1;
        for (Object obj : nestedLogoList.toJava()) {
            if (obj instanceof LogoList) {
                LogoList rowList = (LogoList)obj;
                if (numCols == -1) {
                    numCols = rowList.size();
                    continue;
                }
                if (numCols == rowList.size()) continue;
                throw new ExtensionException("To convert a nested list into a matrix, all nested lists must be the same length -- e.g. [[1 2 3 4] [1 2 3]] is invalid, because row 1 has one more entry.");
            }
            throw new ExtensionException("To convert a nested list into a matrix, there must be exactly two levels of nesting -- e.g. [[1 2 3] [4 5 6]] creates a good 2x3 matrix.");
        }
        if (numCols == 0) {
            throw new ExtensionException("input list contained only empty lists");
        }
        double[][] array = new double[numRows][numCols];
        int row = 0;
        for (Object obj : nestedLogoList.toJava()) {
            int col = 0;
            LogoList rowList = (LogoList)obj;
            for (Object obj2 : rowList.toJava()) {
                if (!(obj2 instanceof Number)) continue;
                array[row][col] = ((Number)obj2).doubleValue();
                ++col;
            }
            while (col < numCols) {
                array[row][col] = 0.0;
                ++col;
            }
            ++row;
        }
        return array;
    }

    private static double[][] convertSimpleLogoListToArray(LogoList SimpleLogoList) throws ExtensionException {
        int numRows = 1;
        int numCols = SimpleLogoList.size();
        double[][] array = new double[numRows][numCols];
        int row = 0;
        for (int i = 0; i < numCols; ++i) {
            array[row][i] = ((Number)SimpleLogoList.get(i)).doubleValue();
        }
        return array;
    }

    private static LogoList convertArrayToNestedLogoList(double[][] dArray) {
        LogoListBuilder lst = new LogoListBuilder();
        for (double[] row : dArray) {
            LogoListBuilder rowLst = new LogoListBuilder();
            for (double elem : row) {
                rowLst.add((Object)elem);
            }
            lst.add((Object)rowLst.toLogoList());
        }
        return lst.toLogoList();
    }

    private static LogoList convertArrayToSimpleLogoList(double[][] dArray) {
        LogoListBuilder lst = new LogoListBuilder();
        double[][] dArray2 = dArray;
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double elem : row = dArray2[i]) {
                lst.add((Object)elem);
            }
        }
        return lst.toLogoList();
    }

    private LogoMatrix getOrCreateMatrixFromId(long id) {
        for (LogoMatrix mat : matrices.keySet()) {
            if (mat.id != id) continue;
            return mat;
        }
        return new LogoMatrix(id);
    }

    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("get", (Primitive)new Get());
        primManager.addPrimitive("set", (Primitive)new Set());
        primManager.addPrimitive("set-row", (Primitive)new SetRow());
        primManager.addPrimitive("swap-rows", (Primitive)new SwapRows());
        primManager.addPrimitive("set-column", (Primitive)new SetColumn());
        primManager.addPrimitive("swap-columns", (Primitive)new SwapColumns());
        primManager.addPrimitive("set-and-report", (Primitive)new SetAndReport());
        primManager.addPrimitive("dimensions", (Primitive)new Dimensions());
        primManager.addPrimitive("to-row-list", (Primitive)new ToRowList());
        primManager.addPrimitive("from-row-list", (Primitive)new FromRowList());
        primManager.addPrimitive("to-column-list", (Primitive)new ToColumnList());
        primManager.addPrimitive("from-column-list", (Primitive)new FromColumnList());
        primManager.addPrimitive("make-constant", (Primitive)new MakeConstant());
        primManager.addPrimitive("make-identity", (Primitive)new MakeIdentity());
        primManager.addPrimitive("copy", (Primitive)new Copy());
        primManager.addPrimitive("pretty-print-text", (Primitive)new PrettyPrintText());
        primManager.addPrimitive("times-scalar", (Primitive)new TimesScalar());
        primManager.addPrimitive("times", (Primitive)new VariadicOperator(timesOp, "matrix:times"));
        primManager.addPrimitive("*", (Primitive)new InfixOperator(timesOp, "matrix:*", InfixOperator.TIMES_PRECEDENCE));
        primManager.addPrimitive("times-element-wise", (Primitive)new VariadicOperator(timesElementsOp, "matrix:times-element-wise"));
        primManager.addPrimitive("plus", (Primitive)new VariadicOperator(plusOp, "matrix:plus"));
        primManager.addPrimitive("+", (Primitive)new InfixOperator(plusOp, "matrix:+", InfixOperator.PLUS_PRECEDENCE));
        primManager.addPrimitive("minus", (Primitive)new VariadicOperator(minusOp, "matrix:minus"));
        primManager.addPrimitive("-", (Primitive)new InfixOperator(minusOp, "matrix:-", InfixOperator.PLUS_PRECEDENCE));
        primManager.addPrimitive("map", (Primitive)new MapElements());
        primManager.addPrimitive("plus-scalar", (Primitive)new PlusScalar());
        primManager.addPrimitive("det", (Primitive)new Det());
        primManager.addPrimitive("rank", (Primitive)new Rank());
        primManager.addPrimitive("cond", (Primitive)new Cond());
        primManager.addPrimitive("trace", (Primitive)new Trace());
        primManager.addPrimitive("inverse", (Primitive)new Inverse());
        primManager.addPrimitive("transpose", (Primitive)new Transpose());
        primManager.addPrimitive("submatrix", (Primitive)new Submatrix());
        primManager.addPrimitive("get-row", (Primitive)new GetRow());
        primManager.addPrimitive("get-column", (Primitive)new GetColumn());
        primManager.addPrimitive("real-eigenvalues", (Primitive)new RealEigenvalues());
        primManager.addPrimitive("imaginary-eigenvalues", (Primitive)new ImaginaryEigenvalues());
        primManager.addPrimitive("eigenvectors", (Primitive)new Eigenvectors());
        primManager.addPrimitive("solve", (Primitive)new Solve());
        primManager.addPrimitive("forecast-linear-growth", (Primitive)new ForecastLinearTrend());
        primManager.addPrimitive("forecast-compound-growth", (Primitive)new ForecastCompoundTrend());
        primManager.addPrimitive("forecast-continuous-growth", (Primitive)new ForecastContinuousTrend());
        primManager.addPrimitive("regress", (Primitive)new Regress());
    }

    private static LogoMatrix getMatrixFromArgument(Argument arg) throws ExtensionException, LogoException {
        Object obj = arg.get();
        if (!(obj instanceof LogoMatrix)) {
            throw new ExtensionException("not a matrix: " + Dump.logoObject((Object)obj));
        }
        return (LogoMatrix)obj;
    }

    private static Object[] getNumericsFromArguments(Argument[] args) throws ExtensionException, LogoException {
        Object[] objs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            objs[i] = MatrixExtension.getNumericFromArgument(args[i]);
        }
        return objs;
    }

    private static Object getNumericFromArgument(Argument arg) throws ExtensionException, LogoException {
        Object obj = arg.get();
        if (obj instanceof Double) {
            return obj;
        }
        if (obj instanceof LogoMatrix) {
            return ((LogoMatrix)obj).matrix;
        }
        throw new ExtensionException("Inputs must be matrices or numbers but found a " + obj.getClass());
    }

    private static LogoMatrix getMatrixFromNumeric(Object obj, String message) throws ExtensionException {
        if (obj instanceof Matrix) {
            return new LogoMatrix((Matrix)obj);
        }
        throw new ExtensionException(message);
    }

    private static class LogoMatrix
    implements ExtensionObject {
        Matrix matrix = null;
        private final long id;

        LogoMatrix(long id) {
            this.matrix = null;
            this.id = id;
            matrices.put(this, id);
            next = StrictMath.max(next, id + 1L);
        }

        LogoMatrix(Matrix matrixData) {
            this.matrix = matrixData;
            matrices.put(this, next);
            this.id = next++;
        }

        public void replaceData(double[][] dArray) {
            this.matrix = new Matrix(dArray);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String dump(boolean readable, boolean exporting, boolean reference) {
            StringBuilder buf = new StringBuilder();
            if (exporting) {
                buf.append(this.id);
                if (!reference) {
                    buf.append(":");
                }
            }
            if (!reference || !exporting) {
                double[][] dArray = this.matrix.getArray();
                buf.append(" [ ");
                for (double[] row : dArray) {
                    buf.append("[");
                    for (double elem : row) {
                        buf.append(" ");
                        buf.append(Dump.number((double)elem));
                    }
                    buf.append(" ]");
                }
                buf.append(" ]");
            }
            return buf.toString();
        }

        public String getExtensionName() {
            return "matrix";
        }

        public String getNLTypeName() {
            return "";
        }

        public boolean recursivelyEqual(Object o) {
            if (!(o instanceof LogoMatrix)) {
                return false;
            }
            LogoMatrix otherMatrix = (LogoMatrix)o;
            double[][] otherArray = otherMatrix.matrix.getArray();
            return Arrays.deepEquals((Object[])this.matrix.getArray(), (Object[])otherArray);
        }
    }

    public static class Get
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex = args[1].getIntValue();
            int colIndex = args[2].getIntValue();
            if (rowIndex < 0 || rowIndex >= mat.matrix.getRowDimension() || colIndex < 0 || colIndex >= mat.matrix.getColumnDimension()) {
                throw new ExtensionException("(" + rowIndex + "," + colIndex + ") are not valid indices for a matrix with dimensions  " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            return mat.matrix.get(rowIndex, colIndex);
        }
    }

    public static class Set
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.WildcardType()});
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex = args[1].getIntValue();
            int colIndex = args[2].getIntValue();
            if (rowIndex < 0 || rowIndex >= mat.matrix.getRowDimension() || colIndex < 0 || colIndex >= mat.matrix.getColumnDimension()) {
                throw new ExtensionException("(" + rowIndex + "," + colIndex + ") are not valid indices for a matrix with dimensions  " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            mat.matrix.set(rowIndex, colIndex, args[3].getDoubleValue());
        }
    }

    public static class SetRow
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.ListType()});
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex = args[1].getIntValue();
            Matrix newRow = new Matrix(MatrixExtension.convertSimpleLogoListToArray(args[2].getList()));
            int newRowLength = newRow.getColumnDimension();
            if (rowIndex < 0 || rowIndex >= mat.matrix.getRowDimension()) {
                throw new ExtensionException(rowIndex + " is not valid row index for a matrix with dimensions " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            if (newRowLength != mat.matrix.getColumnDimension()) {
                throw new ExtensionException("The length of the given list (" + newRowLength + ") is different from the length of the matrix row (" + mat.matrix.getColumnDimension() + ").");
            }
            mat.matrix.setMatrix(rowIndex, rowIndex, 0, newRowLength - 1, newRow);
        }
    }

    public static class SwapRows
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType()});
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex1 = args[1].getIntValue();
            int rowIndex2 = args[2].getIntValue();
            int numCols = mat.matrix.getColumnDimension();
            int numRows = mat.matrix.getRowDimension();
            if (rowIndex1 < 0 || rowIndex1 >= numRows) {
                throw new ExtensionException("The first row index, " + rowIndex1 + ", is not valid for a " + numRows + " x " + numCols + " matrix.");
            }
            if (rowIndex2 < 0 || rowIndex2 >= numRows) {
                throw new ExtensionException("The second row index, " + rowIndex2 + ", is not valid for a " + numRows + " x " + numCols + " matrix.");
            }
            Matrix row1 = mat.matrix.getMatrix(rowIndex1, rowIndex1, 0, numCols - 1);
            mat.matrix.setMatrix(rowIndex1, rowIndex1, 0, numCols - 1, mat.matrix.getMatrix(rowIndex2, rowIndex2, 0, numCols - 1));
            mat.matrix.setMatrix(rowIndex2, rowIndex2, 0, numCols - 1, row1);
        }
    }

    public static class SetColumn
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.ListType()});
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int colIndex = args[1].getIntValue();
            Matrix newCol = new Matrix(MatrixExtension.convertSimpleLogoListToArray(args[2].getList())).transpose();
            int newColLength = newCol.getRowDimension();
            if (colIndex < 0 || colIndex >= mat.matrix.getColumnDimension()) {
                throw new ExtensionException(colIndex + " is not valid column index for a matrix with dimensions " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            if (newColLength != mat.matrix.getRowDimension()) {
                throw new ExtensionException("The length of the given list (" + newColLength + ") is different from the length of the matrix column (" + mat.matrix.getRowDimension() + ").");
            }
            mat.matrix.setMatrix(0, newColLength - 1, colIndex, colIndex, newCol);
        }
    }

    public static class SwapColumns
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType()});
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int colIndex1 = args[1].getIntValue();
            int colIndex2 = args[2].getIntValue();
            int numCols = mat.matrix.getColumnDimension();
            int numRows = mat.matrix.getRowDimension();
            if (colIndex1 < 0 || colIndex1 >= numCols) {
                throw new ExtensionException("The first column index, " + colIndex1 + ", is not valid for a " + numRows + " x " + numCols + " matrix.");
            }
            if (colIndex2 < 0 || colIndex2 >= numCols) {
                throw new ExtensionException("The second column index, " + colIndex2 + ", is not valid for a " + numRows + " x " + numCols + " matrix.");
            }
            Matrix col1 = mat.matrix.getMatrix(0, numRows - 1, colIndex1, colIndex1);
            mat.matrix.setMatrix(0, numRows - 1, colIndex1, colIndex1, mat.matrix.getMatrix(0, numRows - 1, colIndex2, colIndex2));
            mat.matrix.setMatrix(0, numRows - 1, colIndex2, colIndex2, col1);
        }
    }

    public static class SetAndReport
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex = args[1].getIntValue();
            int colIndex = args[2].getIntValue();
            if (rowIndex < 0 || rowIndex >= mat.matrix.getRowDimension() || colIndex < 0 || colIndex >= mat.matrix.getColumnDimension()) {
                throw new ExtensionException("(" + rowIndex + "," + colIndex + ") are not valid indices for a matrix with dimensions  " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            LogoMatrix matcopy = new LogoMatrix(MatrixExtension.getMatrixFromArgument((Argument)args[0]).matrix.copy());
            matcopy.matrix.set(rowIndex, colIndex, args[3].getDoubleValue());
            return matcopy;
        }
    }

    public static class Dimensions
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            LogoListBuilder dims = new LogoListBuilder();
            dims.add((Object)mat.matrix.getRowDimension());
            dims.add((Object)mat.matrix.getColumnDimension());
            return dims.toLogoList();
        }
    }

    public static class ToRowList
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return MatrixExtension.convertArrayToNestedLogoList(MatrixExtension.getMatrixFromArgument((Argument)args[0]).matrix.getArray());
        }
    }

    public static class FromRowList
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return new LogoMatrix(new Matrix(MatrixExtension.convertNestedLogoListToArray(args[0].getList())));
        }
    }

    public static class ToColumnList
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return MatrixExtension.convertArrayToNestedLogoList(MatrixExtension.getMatrixFromArgument((Argument)args[0]).matrix.transpose().getArray());
        }
    }

    public static class FromColumnList
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return new LogoMatrix(new Matrix(MatrixExtension.convertNestedLogoListToArray(args[0].getList())).transpose());
        }
    }

    public static class MakeConstant
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return new LogoMatrix(new Matrix(args[0].getIntValue(), args[1].getIntValue(), args[2].getDoubleValue()));
        }
    }

    public static class MakeIdentity
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            int size = args[0].getIntValue();
            return new LogoMatrix(Matrix.identity((int)size, (int)size));
        }
    }

    public static class Copy
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return new LogoMatrix(MatrixExtension.getMatrixFromArgument((Argument)args[0]).matrix.copy());
        }
    }

    public static class PrettyPrintText
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.StringType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            double[][] dArray = MatrixExtension.getMatrixFromArgument((Argument)args[0]).matrix.getArray();
            int[] maxLen = new int[dArray[0].length];
            for (int j = 0; j < dArray[0].length; ++j) {
                maxLen[j] = 0;
            }
            for (double[] row : dArray) {
                for (int j = 0; j < row.length; ++j) {
                    int len = Dump.number((double)row[j]).length();
                    if (len <= maxLen[j]) continue;
                    maxLen[j] = len;
                }
            }
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    buf.append(" ");
                }
                buf.append("[");
                for (int j = 0; j < dArray[i].length; ++j) {
                    if (j != 0) {
                        buf.append(" ");
                    }
                    buf.append(" ");
                    buf.append(String.format("%" + maxLen[j] + "s", Dump.number((double)dArray[i][j])));
                }
                buf.append(" ]");
                if (i >= dArray.length - 1) continue;
                buf.append("\n");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    public static class TimesScalar
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                return MatrixExtension.getMatrixFromNumeric(timesElementsOp.applyEquals(MatrixExtension.getNumericFromArgument(args[0]), MatrixExtension.getNumericFromArgument(args[1])), "You must give matrix:times-scalar a matrix as the first input.");
            }
            catch (IllegalArgumentException e) {
                throw new ExtensionException((Exception)e);
            }
        }
    }

    public static class VariadicOperator
    implements Reporter {
        private Operator operator;
        private String name;

        public VariadicOperator(Operator operator, String name) {
            this.operator = operator;
            this.name = name;
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType() | Syntax.RepeatableType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                return MatrixExtension.getMatrixFromNumeric(this.operator.reduce(Arrays.asList(MatrixExtension.getNumericsFromArguments(args)).iterator()), "You must give " + this.name + " at least one matrix argument.");
            }
            catch (IllegalArgumentException e) {
                throw new ExtensionException((Exception)e);
            }
        }
    }

    public static class InfixOperator
    implements Reporter {
        public static final int PLUS_PRECEDENCE = Syntax.NormalPrecedence() - 3;
        public static final int TIMES_PRECEDENCE = Syntax.NormalPrecedence() - 2;
        private Operator operator;
        private String name;
        private int precedence;

        public InfixOperator(Operator operator, String name, int precedence) {
            this.operator = operator;
            this.name = name;
            this.precedence = precedence;
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.WildcardType(), (int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType(), (int)this.precedence);
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                return MatrixExtension.getMatrixFromNumeric(this.operator.apply(MatrixExtension.getNumericFromArgument(args[0]), MatrixExtension.getNumericFromArgument(args[1])), "You must give " + this.name + " at least one matrix argument.");
            }
            catch (IllegalArgumentException e) {
                throw new ExtensionException((Exception)e);
            }
        }
    }

    public static class MapElements
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ReporterType(), Syntax.WildcardType() | Syntax.RepeatableType()}, (int)Syntax.WildcardType(), (int)2);
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            AnonymousReporter mapFnctn = (AnonymousReporter)args[0].getReporter();
            double[][][] mats = new double[args.length - 1][][];
            for (int i = 1; i < args.length; ++i) {
                mats[i - 1] = MatrixExtension.getMatrixFromArgument((Argument)args[i]).matrix.getArray();
            }
            if (mapFnctn.formals().length > mats.length) {
                throw new ExtensionException("Task expected " + mapFnctn.formals().length + " matrix inputs but only got " + mats.length + ".");
            }
            int nmats = mats.length;
            int nrows = mats[0].length;
            int ncols = mats[0][0].length;
            for (double[][] mat : mats) {
                if (mat.length == nrows && mat[0].length == ncols) continue;
                throw new ExtensionException("All matrices must have the same dimmensions: the first was " + nrows + "x" + ncols + " and another was " + mat.length + "x" + mat[0].length + ".");
            }
            double[][] destmat = new double[nrows][ncols];
            Object[] taskArgs = new Object[nmats];
            try {
                for (int i = 0; i < nrows; ++i) {
                    for (int j = 0; j < ncols; ++j) {
                        for (int n = 0; n < nmats; ++n) {
                            taskArgs[n] = mats[n][i][j];
                        }
                        destmat[i][j] = (Double)mapFnctn.report(context, taskArgs);
                    }
                }
                return new LogoMatrix(new Matrix(destmat));
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class PlusScalar
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                return MatrixExtension.getMatrixFromNumeric(plusOp.apply(MatrixExtension.getNumericFromArgument(args[0]), MatrixExtension.getNumericFromArgument(args[1])), "You must give matrix:plus-scalar a matrix as the first input.");
            }
            catch (IllegalArgumentException e) {
                throw new ExtensionException((Exception)e);
            }
        }
    }

    public static class Det
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            try {
                return mat.matrix.det();
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Rank
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            try {
                return (double)mat.matrix.rank();
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Cond
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            try {
                return mat.matrix.cond();
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Trace
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            try {
                return mat.matrix.trace();
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Inverse
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            try {
                return new LogoMatrix(mat.matrix.inverse());
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Transpose
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            return new LogoMatrix(mat.matrix.transpose());
        }
    }

    public static class Submatrix
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int r1 = args[1].getIntValue();
            int c1 = args[2].getIntValue();
            int r2 = args[3].getIntValue();
            int c2 = args[4].getIntValue();
            int numRows = mat.matrix.getRowDimension();
            int numCols = mat.matrix.getColumnDimension();
            if (r1 < 0 || r1 >= numRows) {
                throw new ExtensionException("Start row index (" + r1 + ") is invalid.  Should be between 0 and " + (numRows - 1) + " inclusive.");
            }
            if (c1 < 0 || c1 >= numCols) {
                throw new ExtensionException("Start column index (" + c1 + ") is invalid.  Should be between 0 and " + (numCols - 1) + " inclusive.");
            }
            if (r2 < 1 || r2 > numRows) {
                throw new ExtensionException("End row index (" + r2 + ") is invalid.  Should be between 1 and " + numRows + " inclusive.");
            }
            if (c2 < 1 || c2 > numCols) {
                throw new ExtensionException("End column index (" + c2 + ") is invalid.  Should be between 1 and " + numCols + " inclusive.");
            }
            return new LogoMatrix(mat.matrix.getMatrix(r1, r2 - 1, c1, c2 - 1));
        }
    }

    public static class GetRow
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex = args[1].getIntValue();
            int ncols = mat.matrix.getColumnDimension();
            if (rowIndex < 0 || rowIndex >= mat.matrix.getRowDimension()) {
                throw new ExtensionException("(" + rowIndex + ") is not valid indices for a matrix with dimensions  " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            LogoMatrix rowArray = new LogoMatrix(mat.matrix.getMatrix(rowIndex, rowIndex, 0, ncols - 1));
            return MatrixExtension.convertArrayToSimpleLogoList(rowArray.matrix.getArray());
        }
    }

    public static class GetColumn
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int colIndex = args[1].getIntValue();
            int nrows = mat.matrix.getRowDimension();
            if (colIndex < 0 || colIndex >= mat.matrix.getColumnDimension()) {
                throw new ExtensionException("(" + colIndex + ") is not valid indices for a matrix with dimensions  " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            LogoMatrix colArray = new LogoMatrix(mat.matrix.getMatrix(0, nrows - 1, colIndex, colIndex));
            return MatrixExtension.convertArrayToSimpleLogoList(colArray.matrix.getArray());
        }
    }

    public static class RealEigenvalues
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            double[] eigenVals;
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            LogoListBuilder retList = new LogoListBuilder();
            for (double d : eigenVals = mat.matrix.eig().getRealEigenvalues()) {
                retList.add((Object)d);
            }
            return retList.toLogoList();
        }
    }

    public static class ImaginaryEigenvalues
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            double[] eigenVals;
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            LogoListBuilder retList = new LogoListBuilder();
            for (double d : eigenVals = mat.matrix.eig().getImagEigenvalues()) {
                retList.add((Object)d);
            }
            return retList.toLogoList();
        }
    }

    public static class Eigenvectors
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            return new LogoMatrix(mat.matrix.eig().getV());
        }
    }

    public static class Solve
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            LogoMatrix mat2 = MatrixExtension.getMatrixFromArgument(args[1]);
            try {
                return new LogoMatrix(mat.matrix.solve(mat2.matrix));
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class ForecastLinearTrend
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Matrix Y = new Matrix(MatrixExtension.convertSimpleLogoListToArray(args[0].getList())).transpose();
            int numObsv = Y.getRowDimension();
            if (numObsv < 1) {
                throw new ExtensionException("The input list is empty.");
            }
            LogoListBuilder forecast = new LogoListBuilder();
            if (numObsv == 1) {
                forecast.add((Object)Y.get(0, 0));
                forecast.add((Object)Y.get(0, 0));
                forecast.add((Object)0.0);
                forecast.add((Object)0.0);
                return forecast.toLogoList();
            }
            Matrix X = new Matrix(numObsv, 2);
            for (int i = 0; i < numObsv; ++i) {
                X.set(i, 0, 1.0);
                X.set(i, 1, (double)i);
            }
            Matrix A = X.solve(Y);
            double constant = A.get(0, 0);
            double slope = A.get(1, 0);
            double Yforecast = constant + slope * (double)numObsv;
            Matrix Ysum = new Matrix(1, numObsv, 1.0).times(Y);
            double Ybar = Ysum.get(0, 0) / (double)numObsv;
            Matrix Ydiff = Y.minus(new Matrix(numObsv, 1, Ybar));
            double TotalSumSq = Ydiff.transpose().times(Ydiff).get(0, 0);
            Matrix Resid = X.times(A).minus(Y);
            double ResidSumSq = Resid.transpose().times(Resid).get(0, 0);
            double RSquared = TotalSumSq > 0.0 ? 1.0 - ResidSumSq / TotalSumSq : 1.0;
            forecast.add((Object)Yforecast);
            forecast.add((Object)constant);
            forecast.add((Object)slope);
            forecast.add((Object)RSquared);
            return forecast.toLogoList();
        }
    }

    public static class ForecastCompoundTrend
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Matrix Yin = new Matrix(MatrixExtension.convertSimpleLogoListToArray(args[0].getList())).transpose();
            int numObsv = Yin.getRowDimension();
            if (numObsv < 1) {
                throw new ExtensionException("The input list is empty.");
            }
            for (int i = 0; i < numObsv; ++i) {
                if (!(Yin.get(i, 0) <= 0.0)) continue;
                throw new ExtensionException("Item " + i + " of the input list is zero or negative.");
            }
            LogoListBuilder forecast = new LogoListBuilder();
            if (numObsv == 1) {
                forecast.add((Object)Yin.get(0, 0));
                forecast.add((Object)Yin.get(0, 0));
                forecast.add((Object)1.0);
                forecast.add((Object)0.0);
                return forecast.toLogoList();
            }
            Matrix Y = new Matrix(numObsv, 1);
            Matrix X = new Matrix(numObsv, 2);
            for (int i = 0; i < numObsv; ++i) {
                Y.set(i, 0, Math.log(Yin.get(i, 0)));
                X.set(i, 0, 1.0);
                X.set(i, 1, (double)i);
            }
            Matrix A = X.solve(Y);
            double constant = Math.exp(A.get(0, 0));
            double onePlusRate = Math.exp(A.get(1, 0));
            double Yforecast = constant * Math.pow(onePlusRate, numObsv);
            Matrix Ysum = new Matrix(1, numObsv, 1.0).times(Y);
            double Ybar = Ysum.get(0, 0) / (double)numObsv;
            Matrix Ydiff = Y.minus(new Matrix(numObsv, 1, Ybar));
            double TotalSumSq = Ydiff.transpose().times(Ydiff).get(0, 0);
            Matrix Resid = X.times(A).minus(Y);
            double ResidSumSq = Resid.transpose().times(Resid).get(0, 0);
            double RSquared = TotalSumSq > 0.0 ? 1.0 - ResidSumSq / TotalSumSq : 1.0;
            forecast.add((Object)Yforecast);
            forecast.add((Object)constant);
            forecast.add((Object)onePlusRate);
            forecast.add((Object)RSquared);
            return forecast.toLogoList();
        }
    }

    public static class ForecastContinuousTrend
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Matrix Yin = new Matrix(MatrixExtension.convertSimpleLogoListToArray(args[0].getList())).transpose();
            int numObsv = Yin.getRowDimension();
            if (numObsv < 1) {
                throw new ExtensionException("The input list is empty.");
            }
            for (int i = 0; i < numObsv; ++i) {
                if (!(Yin.get(i, 0) <= 0.0)) continue;
                throw new ExtensionException("Item " + i + " of the input list is zero or negative.");
            }
            LogoListBuilder forecast = new LogoListBuilder();
            if (numObsv == 1) {
                forecast.add((Object)Yin.get(0, 0));
                forecast.add((Object)Yin.get(0, 0));
                forecast.add((Object)0.0);
                forecast.add((Object)0.0);
                return forecast.toLogoList();
            }
            Matrix Y = new Matrix(numObsv, 1);
            Matrix X = new Matrix(numObsv, 2);
            for (int i = 0; i < numObsv; ++i) {
                Y.set(i, 0, Math.log(Yin.get(i, 0)));
                X.set(i, 0, 1.0);
                X.set(i, 1, (double)i);
            }
            Matrix A = X.solve(Y);
            double constant = Math.exp(A.get(0, 0));
            double rate = A.get(1, 0);
            double Yforecast = constant * Math.exp(rate * (double)numObsv);
            Matrix Ysum = new Matrix(1, numObsv, 1.0).times(Y);
            double Ybar = Ysum.get(0, 0) / (double)numObsv;
            Matrix Ydiff = Y.minus(new Matrix(numObsv, 1, Ybar));
            double TotalSumSq = Ydiff.transpose().times(Ydiff).get(0, 0);
            Matrix Resid = X.times(A).minus(Y);
            double ResidSumSq = Resid.transpose().times(Resid).get(0, 0);
            double RSquared = TotalSumSq > 0.0 ? 1.0 - ResidSumSq / TotalSumSq : 1.0;
            forecast.add((Object)Yforecast);
            forecast.add((Object)constant);
            forecast.add((Object)rate);
            forecast.add((Object)RSquared);
            return forecast.toLogoList();
        }
    }

    public static class Regress
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            Matrix X = mat.matrix.copy();
            int numObsv = X.getRowDimension();
            int numVars = X.getColumnDimension() - 1;
            if (numVars >= numObsv) {
                throw new ExtensionException("The system is overdetermined.");
            }
            Matrix Y = new Matrix(numObsv, 1);
            for (int i = 0; i < numObsv; ++i) {
                Y.set(i, 0, X.get(i, 0));
                X.set(i, 0, 1.0);
            }
            Matrix A = X.solve(Y);
            Matrix Ysum = new Matrix(1, numObsv, 1.0).times(Y);
            double Ybar = Ysum.get(0, 0) / (double)numObsv;
            Matrix Ydiff = Y.minus(new Matrix(numObsv, 1, Ybar));
            double TotalSumSq = Ydiff.transpose().times(Ydiff).get(0, 0);
            Matrix Resid = X.times(A).minus(Y);
            double ResidSumSq = Resid.transpose().times(Resid).get(0, 0);
            double RSquared = 1.0 - ResidSumSq / TotalSumSq;
            LogoListBuilder stats = new LogoListBuilder();
            stats.add((Object)RSquared);
            stats.add((Object)TotalSumSq);
            stats.add((Object)ResidSumSq);
            LogoList returnList = MatrixExtension.convertArrayToNestedLogoList(A.transpose().getArray());
            LogoListBuilder result = new LogoListBuilder();
            result.addAll((Iterable)returnList);
            result.add((Object)stats.toLogoList());
            return result.toLogoList();
        }
    }

    private static class TimesElementsOp
    extends Operator {
        private TimesElementsOp() {
        }

        @Override
        public double apply(double accumulator, double elem) {
            return accumulator * elem;
        }
    }

    private static class TimesOp
    extends TimesElementsOp {
        private TimesOp() {
        }

        @Override
        public Matrix applyEquals(Matrix accumulator, Matrix elem) {
            return accumulator.times(elem);
        }
    }

    private static class PlusOp
    extends Operator {
        private PlusOp() {
        }

        @Override
        public double apply(double accumulator, double elem) {
            return accumulator + elem;
        }
    }

    private static class MinusOp
    extends Operator {
        private MinusOp() {
        }

        @Override
        public double apply(double accumulator, double elem) {
            return accumulator - elem;
        }
    }
}

