/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.lifecycle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.lifecycle.AbstractMonitoringLifecycleStrategy;

public class ReflectionLifecycleStrategy
extends AbstractMonitoringLifecycleStrategy {
    private static final int START = 0;
    private static final int STOP = 1;
    private static final int DISPOSE = 2;
    private final String[] methodNames;
    private final transient Map<Class<?>, Method[]> methodMap = new HashMap();

    public ReflectionLifecycleStrategy(ComponentMonitor monitor) {
        this(monitor, "start", "stop", "dispose");
    }

    public ReflectionLifecycleStrategy(ComponentMonitor monitor, String startMethodName, String stopMethodName, String disposeMethodName) {
        super(monitor);
        this.methodNames = new String[]{startMethodName, stopMethodName, disposeMethodName};
    }

    @Override
    public void start(Object component) {
        Method[] methods = this.init(component.getClass());
        this.invokeMethod(component, methods[0]);
    }

    @Override
    public void stop(Object component) {
        Method[] methods = this.init(component.getClass());
        this.invokeMethod(component, methods[1]);
    }

    @Override
    public void dispose(Object component) {
        Method[] methods = this.init(component.getClass());
        this.invokeMethod(component, methods[2]);
    }

    private void invokeMethod(Object component, Method method) {
        if (component != null && method != null) {
            try {
                long str = System.currentTimeMillis();
                this.currentMonitor().invoking(null, null, method, component, new Object[0]);
                method.invoke(component, new Object[0]);
                this.currentMonitor().invoked(null, null, method, component, System.currentTimeMillis() - str, new Object[0], null);
            }
            catch (IllegalAccessException e) {
                this.monitorAndThrowReflectionLifecycleException(method, e, component);
            }
            catch (InvocationTargetException e) {
                this.monitorAndThrowReflectionLifecycleException(method, e.getCause(), component);
            }
        }
    }

    protected void monitorAndThrowReflectionLifecycleException(Method method, Throwable e, Object component) {
        RuntimeException re = e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException("wrapper", e);
        this.currentMonitor().lifecycleInvocationFailed(null, null, method, component, re);
    }

    @Override
    public boolean hasLifecycle(Class<?> type) {
        Method[] methods;
        for (Method method : methods = this.init(type)) {
            if (method == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method[] init(Class<?> type) {
        Method[] methods;
        Map<Class<?>, Method[]> map = this.methodMap;
        synchronized (map) {
            methods = this.methodMap.get(type);
            if (methods == null) {
                methods = new Method[this.methodNames.length];
                for (int i = 0; i < methods.length; ++i) {
                    try {
                        String methodName = this.methodNames[i];
                        if (methodName == null) continue;
                        methods[i] = type.getMethod(methodName, new Class[0]);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                this.methodMap.put(type, methods);
            }
        }
        return methods;
    }
}

