/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Cancellable$;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.actor.CoordinatedShutdown$Phase$;
import org.apache.pekko.actor.CoordinatedShutdown$UnknownReason$;
import org.apache.pekko.actor.CoordinatedShutdown$tasks$;
import org.apache.pekko.actor.CoordinatedShutdownTerminationWatcher;
import org.apache.pekko.actor.CoordinatedShutdownTerminationWatcher$;
import org.apache.pekko.actor.CoordinatedShutdownTerminationWatcher$Watch$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.JVMShutdownHooks;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.FutureConverters$CompletionStageOps$;
import org.apache.pekko.util.FutureConverters$FutureOps$;
import org.apache.pekko.util.OptionConverters$;
import org.apache.pekko.util.OptionConverters$RichOption$;
import org.apache.pekko.util.OptionConverters$RichOptional$;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class CoordinatedShutdown
implements Extension {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(CoordinatedShutdown.class.getDeclaredField("terminationWatcher$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CoordinatedShutdown.class.getDeclaredField("tasks$lzy1"));
    private final ExtendedActorSystem system;
    private final Map<String, Phase> phases;
    public final JVMShutdownHooks org$apache$pekko$actor$CoordinatedShutdown$$jvmShutdownHooks;
    private final LoggingAdapter log;
    private final Set<String> knownPhases;
    private final List orderedPhases;
    private volatile Object tasks$lzy1;
    private final AtomicReference<Option<Reason>> runStarted;
    private final Promise<Done> runPromise;
    public final AtomicReference<CountDownLatch> org$apache$pekko$actor$CoordinatedShutdown$$_jvmHooksLatch;
    private volatile Cancellable actorSystemJvmHook;
    private volatile Object terminationWatcher$lzy1;

    public static String PhaseActorSystemTerminate() {
        return CoordinatedShutdown$.MODULE$.PhaseActorSystemTerminate();
    }

    public static String PhaseBeforeActorSystemTerminate() {
        return CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate();
    }

    public static String PhaseBeforeClusterShutdown() {
        return CoordinatedShutdown$.MODULE$.PhaseBeforeClusterShutdown();
    }

    public static String PhaseBeforeServiceUnbind() {
        return CoordinatedShutdown$.MODULE$.PhaseBeforeServiceUnbind();
    }

    public static String PhaseClusterExiting() {
        return CoordinatedShutdown$.MODULE$.PhaseClusterExiting();
    }

    public static String PhaseClusterExitingDone() {
        return CoordinatedShutdown$.MODULE$.PhaseClusterExitingDone();
    }

    public static String PhaseClusterLeave() {
        return CoordinatedShutdown$.MODULE$.PhaseClusterLeave();
    }

    public static String PhaseClusterShardingShutdownRegion() {
        return CoordinatedShutdown$.MODULE$.PhaseClusterShardingShutdownRegion();
    }

    public static String PhaseClusterShutdown() {
        return CoordinatedShutdown$.MODULE$.PhaseClusterShutdown();
    }

    public static String PhaseServiceRequestsDone() {
        return CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone();
    }

    public static String PhaseServiceStop() {
        return CoordinatedShutdown$.MODULE$.PhaseServiceStop();
    }

    public static String PhaseServiceUnbind() {
        return CoordinatedShutdown$.MODULE$.PhaseServiceUnbind();
    }

    public static Reason actorSystemTerminateReason() {
        return CoordinatedShutdown$.MODULE$.actorSystemTerminateReason();
    }

    public static Extension apply(ActorSystem actorSystem) {
        return CoordinatedShutdown$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return CoordinatedShutdown$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Reason clusterDowningReason() {
        return CoordinatedShutdown$.MODULE$.clusterDowningReason();
    }

    public static Reason clusterJoinUnsuccessfulReason() {
        return CoordinatedShutdown$.MODULE$.clusterJoinUnsuccessfulReason();
    }

    public static Reason clusterLeavingReason() {
        return CoordinatedShutdown$.MODULE$.clusterLeavingReason();
    }

    @InternalApi
    public static Config confWithOverrides(Config config, Option<Reason> option) {
        return CoordinatedShutdown$.MODULE$.confWithOverrides(config, option);
    }

    public static CoordinatedShutdown createExtension(ExtendedActorSystem extendedActorSystem) {
        return CoordinatedShutdown$.MODULE$.createExtension(extendedActorSystem);
    }

    public static CoordinatedShutdown get(ActorSystem actorSystem) {
        return CoordinatedShutdown$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return CoordinatedShutdown$.MODULE$.get(actorSystem);
    }

    public static CoordinatedShutdown get(ClassicActorSystemProvider classicActorSystemProvider) {
        return CoordinatedShutdown$.MODULE$.get(classicActorSystemProvider);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return CoordinatedShutdown$.MODULE$.get(classicActorSystemProvider);
    }

    public static Reason incompatibleConfigurationDetectedReason() {
        return CoordinatedShutdown$.MODULE$.incompatibleConfigurationDetectedReason();
    }

    @InternalApi
    public static void init(ExtendedActorSystem extendedActorSystem, Config config, CoordinatedShutdown coordinatedShutdown) {
        CoordinatedShutdown$.MODULE$.init(extendedActorSystem, config, coordinatedShutdown);
    }

    public static Reason jvmExitReason() {
        return CoordinatedShutdown$.MODULE$.jvmExitReason();
    }

    public static ExtensionId<? extends Extension> lookup() {
        return CoordinatedShutdown$.MODULE$.lookup();
    }

    public static Map<String, Phase> phasesFromConfig(Config config) {
        return CoordinatedShutdown$.MODULE$.phasesFromConfig(config);
    }

    public static List<String> topologicalSort(Map<String, Phase> map) {
        return CoordinatedShutdown$.MODULE$.topologicalSort(map);
    }

    public static Reason unknownReason() {
        return CoordinatedShutdown$.MODULE$.unknownReason();
    }

    public static JVMShutdownHooks $lessinit$greater$default$3() {
        return CoordinatedShutdown$.MODULE$.$lessinit$greater$default$3();
    }

    public CoordinatedShutdown(ExtendedActorSystem system, Map<String, Phase> phases, JVMShutdownHooks jvmShutdownHooks) {
        this.system = system;
        this.phases = phases;
        this.org$apache$pekko$actor$CoordinatedShutdown$$jvmShutdownHooks = jvmShutdownHooks;
        this.log = Logging$.MODULE$.apply(system, CoordinatedShutdown.class, LogSource$.MODULE$.fromAnyClass());
        this.knownPhases = (Set)phases.keySet().$plus$plus((IterableOnce)phases.values().flatMap((Function1 & Serializable)_$3 -> _$3.dependsOn()));
        this.orderedPhases = CoordinatedShutdown$.MODULE$.topologicalSort(phases);
        this.runStarted = new AtomicReference<None$>(None$.MODULE$);
        this.runPromise = Promise$.MODULE$.apply();
        this.org$apache$pekko$actor$CoordinatedShutdown$$_jvmHooksLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(0));
        OptionVal$.MODULE$.None();
        this.actorSystemJvmHook = null;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public List<String> orderedPhases() {
        return this.orderedPhases;
    }

    private final CoordinatedShutdown$tasks$ tasks() {
        Object object = this.tasks$lzy1;
        if (object instanceof CoordinatedShutdown$tasks$) {
            return (CoordinatedShutdown$tasks$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CoordinatedShutdown$tasks$)this.tasks$lzyINIT1();
    }

    private Object tasks$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.tasks$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CoordinatedShutdown$tasks$ coordinatedShutdown$tasks$ = null;
                    try {
                        coordinatedShutdown$tasks$ = new CoordinatedShutdown$tasks$(this);
                        object2 = coordinatedShutdown$tasks$ == null ? LazyVals.NullValue$.MODULE$ : coordinatedShutdown$tasks$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.tasks$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return coordinatedShutdown$tasks$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Cancellable org$apache$pekko$actor$CoordinatedShutdown$$actorSystemJvmHook() {
        return this.actorSystemJvmHook;
    }

    public void org$apache$pekko$actor$CoordinatedShutdown$$actorSystemJvmHook_$eq(Cancellable x$0) {
        this.actorSystemJvmHook = x$0;
    }

    public ActorRef terminationWatcher() {
        Object object = this.terminationWatcher$lzy1;
        if (object instanceof ActorRef) {
            return (ActorRef)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ActorRef)this.terminationWatcher$lzyINIT1();
    }

    private Object terminationWatcher$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.terminationWatcher$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ActorRef actorRef = null;
                    try {
                        actorRef = this.system.systemActorOf(CoordinatedShutdownTerminationWatcher$.MODULE$.props(), "coordinatedShutdownTerminationWatcher");
                        object2 = actorRef == null ? LazyVals.NullValue$.MODULE$ : actorRef;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.terminationWatcher$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return actorRef;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public CountDownLatch jvmHooksLatch() {
        return this.org$apache$pekko$actor$CoordinatedShutdown$$_jvmHooksLatch.get();
    }

    public Cancellable addCancellableTask(String phase, String taskName, Function0<Future<Done>> task) {
        Predef$.MODULE$.require(this.knownPhases.apply((Object)phase), () -> this.addCancellableTask$$anonfun$1(phase));
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(taskName)), CoordinatedShutdown::addCancellableTask$$anonfun$2);
        return this.tasks().register(phase, task, taskName);
    }

    public Cancellable addCancellableTask(String phase, String taskName, Supplier<CompletionStage<Done>> task) {
        return this.addCancellableTask(phase, taskName, (Function0<Future<Done>>)(Function0 & Serializable)() -> {
            CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)task.get());
            return FutureConverters$CompletionStageOps$.MODULE$.asScala$extension(completionStage);
        });
    }

    public void addTask(String phase, String taskName, Function0<Future<Done>> task) {
        Predef$.MODULE$.require(this.knownPhases.apply((Object)phase), () -> this.addTask$$anonfun$1(phase));
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(taskName)), CoordinatedShutdown::addTask$$anonfun$2);
        this.tasks().register(phase, task, taskName);
    }

    public void addTask(String phase, String taskName, Supplier<CompletionStage<Done>> task) {
        this.addTask(phase, taskName, (Function0<Future<Done>>)(Function0 & Serializable)() -> {
            CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)task.get());
            return FutureConverters$CompletionStageOps$.MODULE$.asScala$extension(completionStage);
        });
    }

    public void addActorTerminationTask(String phase, String taskName, ActorRef actor, Option<Object> stopMsg) {
        this.addTask(phase, taskName, (Function0<Future<Done>>)(Function0 & Serializable)() -> {
            stopMsg.foreach((Function1)(JProcedure1 & Serializable)msg -> actor.$bang(msg, actor.$bang$default$2(msg)));
            Deadline deadline = ((Phase)this.phases.apply((Object)phase)).timeout().fromNow();
            Promise completionPromise = Promise$.MODULE$.apply();
            CoordinatedShutdownTerminationWatcher.Watch watch = CoordinatedShutdownTerminationWatcher$Watch$.MODULE$.apply(actor, deadline, (Promise<Done>)completionPromise);
            this.terminationWatcher().$bang(watch, this.terminationWatcher().$bang$default$2(watch));
            return completionPromise.future();
        });
    }

    public void addActorTerminationTask(String phase, String taskName, ActorRef actor, Optional<Object> stopMsg) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(stopMsg);
        this.addActorTerminationTask(phase, taskName, actor, OptionConverters$RichOptional$.MODULE$.toScala$extension(optional));
    }

    public Option<Reason> shutdownReason() {
        return this.runStarted.get();
    }

    public Optional<Reason> getShutdownReason() {
        Option option = OptionConverters$.MODULE$.RichOption(this.shutdownReason());
        return OptionConverters$RichOption$.MODULE$.toJava$extension(option);
    }

    public Future<Done> run(Reason reason) {
        return this.run(reason, (Option<String>)None$.MODULE$);
    }

    public Future<Done> run() {
        return this.run(CoordinatedShutdown$UnknownReason$.MODULE$);
    }

    public CompletionStage<Done> runAll(Reason reason) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.run(reason));
        return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
    }

    public CompletionStage<Done> runAll() {
        return this.runAll(CoordinatedShutdown$UnknownReason$.MODULE$);
    }

    public Future<Done> run(Reason reason, Option<String> fromPhase) {
        if (this.runStarted.compareAndSet((Option<Reason>)None$.MODULE$, (Option<Reason>)Some$.MODULE$.apply((Object)reason))) {
            List list;
            MessageDispatcher ec = this.system.dispatchers().internalDispatcher();
            boolean debugEnabled = this.log().isDebugEnabled();
            this.log().info("Running CoordinatedShutdown with reason [{}]", reason);
            Option<String> option = fromPhase;
            if (None$.MODULE$.equals(option)) {
                list = this.orderedPhases();
            } else if (option instanceof Some) {
                String p = (String)((Some)option).value();
                list = (List)this.orderedPhases().dropWhile((Function1 & Serializable)_$8 -> {
                    String string = _$8;
                    String string2 = p;
                    return string == null ? string2 != null : !string.equals(string2);
                });
            } else {
                throw new MatchError(option);
            }
            List remainingPhases = list;
            Future done = this.loop$1(debugEnabled, ec, remainingPhases);
            this.runPromise.completeWith(done);
        }
        return this.runPromise.future();
    }

    public Future<Done> run(Option<String> fromPhase) {
        return this.run((Reason)CoordinatedShutdown$UnknownReason$.MODULE$, fromPhase);
    }

    public CompletionStage<Done> run(Reason reason, Optional<String> fromPhase) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(fromPhase);
        Future future = FutureConverters$.MODULE$.FutureOps(this.run(reason, OptionConverters$RichOptional$.MODULE$.toScala$extension(optional)));
        return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
    }

    public CompletionStage<Done> run(Optional<String> fromPhase) {
        return this.run((Reason)CoordinatedShutdown$UnknownReason$.MODULE$, fromPhase);
    }

    public FiniteDuration timeout(String phase) {
        Option option = this.phases.get((Object)phase);
        if (option instanceof Some) {
            Phase p = (Phase)((Some)option).value();
            return p.timeout();
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(61).append("Unknown phase [").append(phase).append("]. All phases must be defined in configuration").toString());
        }
        throw new MatchError((Object)option);
    }

    public FiniteDuration totalTimeout() {
        return this.tasks().totalDuration();
    }

    public <T> void addJvmShutdownHook(Function0<T> hook) {
        this.addCancellableJvmShutdownHook(hook);
    }

    public <T> Cancellable addCancellableJvmShutdownHook(Function0<T> hook) {
        while (this.runStarted.get().isEmpty()) {
            Cancellable cancellable;
            CountDownLatch newLatch;
            CountDownLatch currentLatch = this.org$apache$pekko$actor$CoordinatedShutdown$$_jvmHooksLatch.get();
            if (!this.org$apache$pekko$actor$CoordinatedShutdown$$_jvmHooksLatch.compareAndSet(currentLatch, newLatch = new CountDownLatch((int)currentLatch.getCount() + 1))) continue;
            Thread thread = new Thread(hook, this){
                private final Function0 hook$1;
                private final /* synthetic */ CoordinatedShutdown $outer;
                {
                    this.hook$1 = hook$4;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    try {
                        this.hook$1.apply();
                    }
                    finally {
                        this.$outer.org$apache$pekko$actor$CoordinatedShutdown$$_jvmHooksLatch.get().countDown();
                    }
                }
            };
            thread.setName(new StringBuilder(15).append(this.system.name()).append("-shutdown-hook-").append(newLatch.getCount()).toString());
            try {
                this.org$apache$pekko$actor$CoordinatedShutdown$$jvmShutdownHooks.addHook(thread);
                cancellable = new Cancellable(thread, this){
                    private final Thread thread$1;
                    private volatile boolean cancelled;
                    private final /* synthetic */ CoordinatedShutdown $outer;
                    {
                        this.thread$1 = thread$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cancelled = false;
                    }

                    public boolean cancelled() {
                        return this.cancelled;
                    }

                    public void cancelled_$eq(boolean x$1) {
                        this.cancelled = x$1;
                    }

                    public boolean cancel() {
                        boolean bl;
                        block3: {
                            try {
                                if (this.$outer.org$apache$pekko$actor$CoordinatedShutdown$$jvmShutdownHooks.removeHook(this.thread$1)) {
                                    this.cancelled_$eq(true);
                                    this.$outer.org$apache$pekko$actor$CoordinatedShutdown$$_jvmHooksLatch.get().countDown();
                                    bl = true;
                                    break block3;
                                }
                                bl = false;
                            }
                            catch (IllegalStateException illegalStateException) {
                                bl = false;
                            }
                        }
                        return bl;
                    }

                    public boolean isCancelled() {
                        return this.cancelled();
                    }
                };
            }
            catch (IllegalStateException e) {
                this.log().warning("Could not addJvmShutdownHook, due to: {}", (Object)e.getMessage());
                this.org$apache$pekko$actor$CoordinatedShutdown$$_jvmHooksLatch.get().countDown();
                cancellable = Cancellable$.MODULE$.alreadyCancelled();
            }
            return cancellable;
        }
        return Cancellable$.MODULE$.alreadyCancelled();
    }

    public void addJvmShutdownHook(Runnable hook) {
        this.addJvmShutdownHook((Function0 & Serializable)() -> {
            CoordinatedShutdown.addJvmShutdownHook$$anonfun$1(hook);
            return BoxedUnit.UNIT;
        });
    }

    public Cancellable addCancellableJvmShutdownHook(Runnable hook) {
        return this.addCancellableJvmShutdownHook((Function0 & Serializable)() -> {
            CoordinatedShutdown.addCancellableJvmShutdownHook$$anonfun$1(hook);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ tasks.StrictPhaseDefinition org$apache$pekko$actor$CoordinatedShutdown$$anon$1$$_$cancel$$anonfun$1(tasks.StrictPhaseDefinition previous, tasks.StrictPhaseDefinition incoming) {
        return previous.merge(incoming);
    }

    public static final /* synthetic */ Future org$apache$pekko$actor$CoordinatedShutdown$tasks$StrictPhaseDefinition$$_$run$$anonfun$1(boolean recoverEnabled$2, ExecutionContext ec$1, tasks.TaskDefinition _$4) {
        return _$4.run(recoverEnabled$2, ec$1);
    }

    public static final /* synthetic */ Done$ org$apache$pekko$actor$CoordinatedShutdown$tasks$StrictPhaseDefinition$$_$run$$anonfun$2(Set _$5) {
        return Done$.MODULE$;
    }

    public static final /* synthetic */ boolean org$apache$pekko$actor$CoordinatedShutdown$tasks$StrictPhaseDefinition$$_$_$$anonfun$3(tasks.TaskDefinition _$6) {
        return _$6.isCancelled();
    }

    public static final /* synthetic */ tasks.StrictPhaseDefinition org$apache$pekko$actor$CoordinatedShutdown$tasks$$$_$register$$anonfun$1(tasks.StrictPhaseDefinition previous, tasks.StrictPhaseDefinition incoming) {
        return previous.merge(incoming);
    }

    private final Object addCancellableTask$$anonfun$1(String phase$1) {
        return new StringBuilder(119).append("Unknown phase [").append(phase$1).append("], known phases [").append(this.knownPhases).append("]. All phases (along with their optional dependencies) must be defined in configuration").toString();
    }

    private static final Object addCancellableTask$$anonfun$2() {
        return "Set a task name when adding tasks to the Coordinated Shutdown. Try to use unique, self-explanatory names.";
    }

    private final Object addTask$$anonfun$1(String phase$2) {
        return new StringBuilder(119).append("Unknown phase [").append(phase$2).append("], known phases [").append(this.knownPhases).append("]. ").append("All phases (along with their optional dependencies) must be defined in configuration").toString();
    }

    private static final Object addTask$$anonfun$2() {
        return "Set a task name when adding tasks to the Coordinated Shutdown. Try to use unique, self-explanatory names.";
    }

    private final Future $anonfun$4(String phaseName$3, Deadline deadline$1, Future result$1, boolean recoverEnabled$3, FiniteDuration timeout$1) {
        String string = phaseName$3;
        String string2 = CoordinatedShutdown$.MODULE$.PhaseActorSystemTerminate();
        if (!(string != null ? !string.equals(string2) : string2 != null) && deadline$1.hasTimeLeft()) {
            return result$1;
        }
        if (result$1.isCompleted()) {
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        if (recoverEnabled$3) {
            this.log().warning("Coordinated shutdown phase [{}] timed out after {}", (Object)phaseName$3, (Object)timeout$1);
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return Future$.MODULE$.failed((Throwable)new TimeoutException(new StringBuilder(46).append("Coordinated shutdown phase [").append(phaseName$3).append("] timed out after ").append(timeout$1).toString()));
    }

    private final Future loop$1(boolean debugEnabled$1, ExecutionContext ec$2, List remainingPhases) {
        List list;
        block11: {
            Future future;
            List list2;
            String string;
            while (true) {
                list = remainingPhases;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list3 = list;
                if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                    return Future$.MODULE$.successful((Object)Done$.MODULE$);
                }
                if (!(list instanceof .colon.colon)) break block11;
                .colon.colon colon2 = (.colon.colon)list;
                string = (String)colon2.head();
                list2 = colon2.next$access$1();
                String phaseName = string;
                List remaining = list2;
                if (((Phase)this.phases.apply((Object)phaseName)).enabled()) break;
                this.tasks().get(phaseName).foreach((Function1)(JProcedure1 & Serializable)phaseDef -> this.log().info("Phase [{}] disabled through configuration, skipping [{}] tasks.", phaseName, BoxesRunTime.boxToInteger((int)phaseDef.size())));
                remainingPhases = remaining;
            }
            String phaseName = string;
            List remaining = list2;
            Option<PhaseDefinition> option = this.tasks().get(phaseName);
            if (None$.MODULE$.equals(option)) {
                if (debugEnabled$1) {
                    this.log().debug("Performing phase [{}] with [0] tasks", phaseName);
                }
                future = Future$.MODULE$.successful((Object)Done$.MODULE$);
            } else if (option instanceof Some) {
                Future future2;
                PhaseDefinition phaseDef2 = (PhaseDefinition)((Some)option).value();
                if (debugEnabled$1) {
                    this.log().debug("Performing phase [{}] with [{}] tasks.", phaseName, BoxesRunTime.boxToInteger((int)phaseDef2.size()));
                }
                boolean recoverEnabled = ((Phase)this.phases.apply((Object)phaseName)).recover();
                Future result = phaseDef2.run(recoverEnabled, ec$2);
                FiniteDuration timeout = ((Phase)this.phases.apply((Object)phaseName)).timeout();
                Deadline deadline = Deadline$.MODULE$.now().$plus(timeout);
                try {
                    future2 = org.apache.pekko.pattern.package$.MODULE$.after(timeout, this.system.scheduler(), () -> this.$anonfun$4(phaseName, deadline, result, recoverEnabled, timeout), ec$2);
                }
                catch (IllegalStateException illegalStateException) {
                    future2 = result;
                }
                Future timeoutFut = future2;
                future = Future$.MODULE$.firstCompletedOf((IterableOnce)new .colon.colon((Object)result, (List)new .colon.colon((Object)timeoutFut, (List)Nil$.MODULE$)), ec$2);
            } else {
                throw new MatchError(option);
            }
            Future phaseResult = future;
            if (remaining.isEmpty()) {
                return phaseResult;
            }
            return phaseResult.flatMap((Function1 & Serializable)_$7 -> this.loop$1(debugEnabled$1, ec$2, remaining), ec$2);
        }
        throw new MatchError((Object)list);
    }

    private static final void addJvmShutdownHook$$anonfun$1(Runnable hook$2) {
        hook$2.run();
    }

    private static final void addCancellableJvmShutdownHook$$anonfun$1(Runnable hook$3) {
        hook$3.run();
    }

    public static final class Phase
    implements Product,
    Serializable {
        private final Set dependsOn;
        private final FiniteDuration timeout;
        private final boolean recover;
        private final boolean enabled;

        public static Phase apply(Set<String> set, FiniteDuration finiteDuration, boolean bl, boolean bl2) {
            return CoordinatedShutdown$Phase$.MODULE$.apply(set, finiteDuration, bl, bl2);
        }

        public static Phase fromProduct(Product product) {
            return CoordinatedShutdown$Phase$.MODULE$.fromProduct(product);
        }

        public static Phase unapply(Phase phase) {
            return CoordinatedShutdown$Phase$.MODULE$.unapply(phase);
        }

        public Phase(Set<String> dependsOn, FiniteDuration timeout, boolean recover, boolean enabled) {
            this.dependsOn = dependsOn;
            this.timeout = timeout;
            this.recover = recover;
            this.enabled = enabled;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.dependsOn()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeout()));
            n = Statics.mix((int)n, (int)(this.recover() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.enabled() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Phase)) return false;
            Phase phase = (Phase)object;
            if (this.recover() != phase.recover()) return false;
            if (this.enabled() != phase.enabled()) return false;
            Set<String> set = this.dependsOn();
            Set<String> set2 = phase.dependsOn();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = phase.timeout();
            if (finiteDuration == null) {
                if (finiteDuration2 == null) return true;
                return false;
            } else {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Phase;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Phase";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "dependsOn";
                }
                case 1: {
                    return "timeout";
                }
                case 2: {
                    return "recover";
                }
                case 3: {
                    return "enabled";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<String> dependsOn() {
            return this.dependsOn;
        }

        public FiniteDuration timeout() {
            return this.timeout;
        }

        public boolean recover() {
            return this.recover;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Phase copy(Set<String> dependsOn, FiniteDuration timeout, boolean recover, boolean enabled) {
            return new Phase(dependsOn, timeout, recover, enabled);
        }

        public Set<String> copy$default$1() {
            return this.dependsOn();
        }

        public FiniteDuration copy$default$2() {
            return this.timeout();
        }

        public boolean copy$default$3() {
            return this.recover();
        }

        public boolean copy$default$4() {
            return this.enabled();
        }

        public Set<String> _1() {
            return this.dependsOn();
        }

        public FiniteDuration _2() {
            return this.timeout();
        }

        public boolean _3() {
            return this.recover();
        }

        public boolean _4() {
            return this.enabled();
        }
    }

    public interface PhaseDefinition {
        public int size();

        public Future<Done> run(boolean var1, ExecutionContext var2);
    }

    public static interface Reason {
    }
}

