/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.ActorWithLogClass;
import org.apache.pekko.event.DummyClassForStringSources;
import org.apache.pekko.event.LogSource;
import org.apache.pekko.event.Logging$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class LogSource$
implements Serializable {
    private static final LogSource fromString;
    private static final LogSource fromActor;
    private static final LogSource fromActorRef;
    @InternalApi
    private static final LogSource fromActorWithLoggerClass;
    private static final LogSource fromClass;
    public static final LogSource$ MODULE$;

    private LogSource$() {
    }

    static {
        MODULE$ = new LogSource$();
        fromString = new LogSource<String>(){

            public String genString(String s) {
                return s;
            }

            public String genString(String s, ActorSystem system) {
                return new StringBuilder(2).append(s).append("(").append(system).append(")").toString();
            }

            public Class getClazz(String s) {
                return DummyClassForStringSources.class;
            }
        };
        fromActor = new LogSource<Actor>(){

            public String genString(Actor a) {
                return LogSource$.MODULE$.fromActorRef().genString(a.self());
            }

            public String genString(Actor a, ActorSystem system) {
                return LogSource$.MODULE$.fromActorRef().genString(a.self(), system);
            }
        };
        fromActorRef = new LogSource<ActorRef>(){

            public String genString(ActorRef a) {
                return a.path().toString();
            }

            public String genString(ActorRef a, ActorSystem system) {
                String string;
                try {
                    string = a.path().toStringWithAddress(((ExtendedActorSystem)system).provider().getDefaultAddress());
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                        string = a.path().toString();
                    }
                    throw throwable;
                }
                return string;
            }
        };
        fromActorWithLoggerClass = new LogSource<ActorWithLogClass>(){

            public String genString(ActorWithLogClass a) {
                return LogSource$.MODULE$.fromActor().genString(a.actor());
            }

            public String genString(ActorWithLogClass a, ActorSystem system) {
                return LogSource$.MODULE$.fromActor().genString(a.actor(), system);
            }

            public Class getClazz(ActorWithLogClass a) {
                return a.logClass();
            }
        };
        fromClass = new LogSource<Class<?>>(){

            public String genString(Class c) {
                return Logging$.MODULE$.simpleName(c);
            }

            public String genString(Class c, ActorSystem system) {
                return new StringBuilder(2).append(this.genString(c)).append("(").append(system).append(")").toString();
            }

            public Class getClazz(Class c) {
                return c;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LogSource$.class);
    }

    public LogSource<String> fromString() {
        return fromString;
    }

    public LogSource<Actor> fromActor() {
        return fromActor;
    }

    public LogSource<ActorRef> fromActorRef() {
        return fromActorRef;
    }

    public LogSource<ActorWithLogClass> fromActorWithLoggerClass() {
        return fromActorWithLoggerClass;
    }

    public LogSource<Class<?>> fromClass() {
        return fromClass;
    }

    public <T> LogSource<Class<T>> fromAnyClass() {
        return this.fromClass();
    }

    public <T> Tuple2<String, Class<?>> apply(T o, LogSource<T> evidence$1) {
        LogSource ls = (LogSource)Predef$.MODULE$.implicitly(evidence$1);
        return Tuple2$.MODULE$.apply((Object)ls.genString(o), ls.getClazz(o));
    }

    public <T> Tuple2<String, Class<?>> apply(T o, ActorSystem system, LogSource<T> evidence$1) {
        LogSource ls = (LogSource)Predef$.MODULE$.implicitly(evidence$1);
        return Tuple2$.MODULE$.apply((Object)ls.genString(o, system), ls.getClazz(o));
    }

    public Tuple2<String, Class<?>> fromAnyRef(Object o) {
        Object object = o;
        if (object instanceof Class) {
            Class c = (Class)object;
            return this.apply(c, this.fromAnyClass());
        }
        if (object instanceof Actor) {
            Actor a = (Actor)object;
            return this.apply(a, this.fromActor());
        }
        if (object instanceof ActorRef) {
            ActorRef a = (ActorRef)object;
            return this.apply(a, this.fromActorRef());
        }
        if (object instanceof String) {
            String s = (String)object;
            return this.apply(s, this.fromString());
        }
        Object x = object;
        return Tuple2$.MODULE$.apply((Object)Logging$.MODULE$.simpleName(x), x.getClass());
    }

    public Tuple2<String, Class<?>> fromAnyRef(Object o, ActorSystem system) {
        Object object = o;
        if (object instanceof Class) {
            Class c = (Class)object;
            return this.apply(c, this.fromAnyClass());
        }
        if (object instanceof Actor) {
            Actor a = (Actor)object;
            return this.apply(a, this.fromActor());
        }
        if (object instanceof ActorRef) {
            ActorRef a = (ActorRef)object;
            return this.apply(a, this.fromActorRef());
        }
        if (object instanceof String) {
            String s = (String)object;
            return this.apply(s, this.fromString());
        }
        Object x = object;
        return Tuple2$.MODULE$.apply((Object)new StringBuilder(2).append(Logging$.MODULE$.simpleName(x)).append("(").append(system).append(")").toString(), x.getClass());
    }
}

