/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event;

import java.io.Serializable;
import org.apache.pekko.event.BusLogging;
import org.apache.pekko.event.DefaultLoggingFilter;
import org.apache.pekko.event.LogMarker;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$Debug$;
import org.apache.pekko.event.Logging$Error$;
import org.apache.pekko.event.Logging$Info$;
import org.apache.pekko.event.Logging$Warning$;
import org.apache.pekko.event.LoggingBus;
import org.apache.pekko.event.LoggingFilter;
import org.apache.pekko.event.LoggingFilterWithMarker;
import org.apache.pekko.event.LoggingFilterWithMarker$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public class MarkerLoggingAdapter
extends BusLogging {
    private final LoggingBus bus;
    private final String logSource;
    private final Class logClass;
    private final LoggingFilterWithMarker loggingFilterWithMarker;

    public MarkerLoggingAdapter(LoggingBus bus, String logSource, Class<?> logClass, LoggingFilter loggingFilter) {
        this.bus = bus;
        this.logSource = logSource;
        this.logClass = logClass;
        super(bus, logSource, logClass, loggingFilter);
        this.loggingFilterWithMarker = LoggingFilterWithMarker$.MODULE$.wrap(loggingFilter);
    }

    @Override
    public LoggingBus bus() {
        return this.bus;
    }

    @Override
    public String logSource() {
        return this.logSource;
    }

    @Override
    public Class<?> logClass() {
        return this.logClass;
    }

    public MarkerLoggingAdapter(LoggingBus bus, String logSource, Class<?> logClass) {
        this(bus, logSource, logClass, MarkerLoggingAdapter.MarkerLoggingAdapter$superArg$1(bus, logSource, logClass));
    }

    public LoggingFilterWithMarker loggingFilterWithMarker() {
        return this.loggingFilterWithMarker;
    }

    public boolean isErrorEnabled(LogMarker marker) {
        return this.loggingFilterWithMarker().isErrorEnabled(this.logClass(), this.logSource(), marker);
    }

    public boolean isWarningEnabled(LogMarker marker) {
        return this.loggingFilterWithMarker().isWarningEnabled(this.logClass(), this.logSource(), marker);
    }

    public boolean isInfoEnabled(LogMarker marker) {
        return this.loggingFilterWithMarker().isInfoEnabled(this.logClass(), this.logSource(), marker);
    }

    public boolean isDebugEnabled(LogMarker marker) {
        return this.loggingFilterWithMarker().isDebugEnabled(this.logClass(), this.logSource(), marker);
    }

    public void error(LogMarker marker, Throwable cause, String message) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void error(LogMarker marker, Throwable cause, String template, Object arg1) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), this.format1(template, arg1), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void error(LogMarker marker, Throwable cause, String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void error(LogMarker marker, Throwable cause, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void error(LogMarker marker, Throwable cause, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void error(LogMarker marker, String message) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void error(LogMarker marker, String template, Object arg1) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), this.format1(template, arg1), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void error(LogMarker marker, String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void error(LogMarker marker, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void error(LogMarker marker, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void warning(LogMarker marker, String message) {
        if (this.isWarningEnabled(marker)) {
            this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void warning(LogMarker marker, String template, Object arg1) {
        if (this.isWarningEnabled(marker)) {
            this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), this.format1(template, arg1), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void warning(LogMarker marker, String template, Object arg1, Object arg2) {
        if (this.isWarningEnabled(marker)) {
            this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void warning(LogMarker marker, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isWarningEnabled(marker)) {
            this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void warning(LogMarker marker, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isWarningEnabled(marker)) {
            this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void info(LogMarker marker, String message) {
        if (this.isInfoEnabled(marker)) {
            this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void info(LogMarker marker, String template, Object arg1) {
        if (this.isInfoEnabled(marker)) {
            this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), this.format1(template, arg1), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void info(LogMarker marker, String template, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void info(LogMarker marker, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled(marker)) {
            this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void info(LogMarker marker, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isInfoEnabled(marker)) {
            this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void debug(LogMarker marker, String message) {
        if (this.isDebugEnabled(marker)) {
            this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void debug(LogMarker marker, String template, Object arg1) {
        if (this.isDebugEnabled(marker)) {
            this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), this.format1(template, arg1), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void debug(LogMarker marker, String template, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void debug(LogMarker marker, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled(marker)) {
            this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void debug(LogMarker marker, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isDebugEnabled(marker)) {
            this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})), (Map<String, Object>)this.mdc(), marker));
            return;
        }
    }

    public void log(LogMarker marker, int level, String message) {
        int n = level;
        if (Logging$.MODULE$.DebugLevel() == n) {
            this.debug(marker, message);
            return;
        }
        if (Logging$.MODULE$.InfoLevel() == n) {
            this.info(marker, message);
            return;
        }
        if (Logging$.MODULE$.WarningLevel() == n) {
            this.warning(marker, message);
            return;
        }
        if (Logging$.MODULE$.ErrorLevel() == n) {
            this.error(marker, message);
            return;
        }
    }

    private String format1(String t, Object arg) {
        Object a;
        Object object = arg;
        if (ScalaRunTime$.MODULE$.isArray(object, 1) && !(a = object).getClass().getComponentType().isPrimitive()) {
            Object[] objectArray = new Object[1];
            Object object2 = Predef$.MODULE$.genericArrayOps(a);
            objectArray[0] = ArrayOps$.MODULE$.toIndexedSeq$extension(object2);
            return this.format(t, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object a2 = object;
            Object[] objectArray = new Object[1];
            Object object3 = Predef$.MODULE$.genericArrayOps(a2);
            Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$5 -> _$5, ClassTag$.MODULE$.apply(Object.class)));
            objectArray[0] = ArrayOps$.MODULE$.toIndexedSeq$extension(object4);
            return this.format(t, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
        }
        Object x = object;
        return this.format(t, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x}));
    }

    private static DefaultLoggingFilter MarkerLoggingAdapter$superArg$1(LoggingBus bus, String logSource, Class<?> logClass) {
        return new DefaultLoggingFilter((Function0<Logging.LogLevel>)(Function0 & Serializable)() -> new Logging.LogLevel(bus.logLevel()));
    }
}

