/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns.internal;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.TimerSchedulerImpl;
import org.apache.pekko.actor.Timers;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMessageQueueSemantics;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.Dns;
import org.apache.pekko.io.Dns$Resolve$;
import org.apache.pekko.io.Dns$Resolved$;
import org.apache.pekko.io.DnsExt;
import org.apache.pekko.io.DnsProvider;
import org.apache.pekko.io.PeriodicCacheCleanup;
import org.apache.pekko.io.dns.AAAARecord;
import org.apache.pekko.io.dns.ARecord;
import org.apache.pekko.io.dns.DnsProtocol;
import org.apache.pekko.io.dns.DnsProtocol$Resolve$;
import org.apache.pekko.io.dns.DnsSettings;
import org.apache.pekko.io.dns.ResourceRecord;
import org.apache.pekko.io.dns.internal.AsyncDnsManager$CacheCleanup$;
import org.apache.pekko.io.dns.internal.AsyncDnsManager$GetCache$;
import org.apache.pekko.io.dns.internal.DnsClient;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.routing.FromConfig$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class AsyncDnsManager
implements RequiresMessageQueue<UnboundedMessageQueueSemantics>,
ActorLogging,
Timers {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers;
    private final Config resolverConfig;
    public final Dns org$apache$pekko$io$dns$internal$AsyncDnsManager$$cache;
    private final ExecutionContextExecutor ec;
    private final DnsSettings settings;
    private final Timeout timeout;
    public final ActorRef org$apache$pekko$io$dns$internal$AsyncDnsManager$$resolver;
    public final Option<Dns> org$apache$pekko$io$dns$internal$AsyncDnsManager$$cacheCleanup;

    public AsyncDnsManager(String name, ExtendedActorSystem system, Config resolverConfig, Dns cache, String dispatcher, DnsProvider provider) {
        None$ none$;
        this.resolverConfig = resolverConfig;
        this.org$apache$pekko$io$dns$internal$AsyncDnsManager$$cache = cache;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        Timers.$init$(this);
        this.ec = this.context().dispatcher();
        this.settings = new DnsSettings(system, resolverConfig);
        this.timeout = Timeout$.MODULE$.apply(this.settings().ResolveTimeout());
        Props props = FromConfig$.MODULE$.props(Props$.MODULE$.apply(provider.actorClass(), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.settings(), cache, (Function2 & Serializable)(factory, dns) -> dns.map((Function1 & Serializable)ns -> factory.actorOf(Props$.MODULE$.apply(() -> AsyncDnsManager.$anonfun$1$$anonfun$1$$anonfun$1(ns), ClassTag$.MODULE$.apply(DnsClient.class))))})).withDeploy(Deploy$.MODULE$.local()).withDispatcher(dispatcher));
        this.org$apache$pekko$io$dns$internal$AsyncDnsManager$$resolver = this.context().actorOf(props, name);
        Dns dns2 = cache;
        if (dns2 instanceof PeriodicCacheCleanup) {
            Dns cleanup = (Dns)((Object)((PeriodicCacheCleanup)((Object)dns2)));
            none$ = Some$.MODULE$.apply((Object)cleanup);
        } else {
            none$ = None$.MODULE$;
        }
        this.org$apache$pekko$io$dns$internal$AsyncDnsManager$$cacheCleanup = none$;
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers() {
        return this.org$apache$pekko$actor$Timers$$_timers;
    }

    @Override
    public void org$apache$pekko$actor$Timers$_setter_$org$apache$pekko$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$0) {
        this.org$apache$pekko$actor$Timers$$_timers = x$0;
    }

    @Override
    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundReceive(PartialFunction receive, Object msg) {
        Actor.aroundReceive$(this, receive, msg);
    }

    public AsyncDnsManager(DnsExt ext) {
        this(ext.Settings().Resolver(), ext.system(), ext.Settings().ResolverConfig(), ext.cache(), ext.Settings().Dispatcher(), ext.provider());
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public DnsSettings settings() {
        return this.settings;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    @Override
    public void preStart() {
        this.org$apache$pekko$io$dns$internal$AsyncDnsManager$$cacheCleanup.foreach((Function1)(JProcedure1 & Serializable)_$1 -> {
            FiniteDuration interval = Duration$.MODULE$.apply(this.resolverConfig.getDuration("cache-cleanup-interval", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            this.timers().startTimerWithFixedDelay((Object)AsyncDnsManager$CacheCleanup$.MODULE$, (Object)AsyncDnsManager$CacheCleanup$.MODULE$, interval);
        });
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ AsyncDnsManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve r = (DnsProtocol.Resolve)object;
                    return true;
                }
                if (object instanceof Dns.Resolve) {
                    String string;
                    Dns.Resolve resolve = Dns$Resolve$.MODULE$.unapply((Dns.Resolve)object);
                    String name = string = resolve._1();
                    return true;
                }
                if (AsyncDnsManager$CacheCleanup$.MODULE$.equals(object)) {
                    return true;
                }
                return AsyncDnsManager$GetCache$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve r = (DnsProtocol.Resolve)object;
                    this.$outer.log().debug("Resolution request for {} {} from {}", r.name(), r.requestType(), this.$outer.sender());
                    this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsManager$$resolver.forward(r, this.$outer.context());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Dns.Resolve) {
                    String string;
                    Dns.Resolve resolve = Dns$Resolve$.MODULE$.unapply((Dns.Resolve)object);
                    String name = string = resolve._1();
                    this.$outer.log().debug("(deprecated) Resolution request for {} from {}", name, this.$outer.sender());
                    DnsProtocol.Resolve adapted = DnsProtocol$Resolve$.MODULE$.apply(name);
                    Future reply = AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsManager$$resolver), adapted, this.$outer.timeout(), this.$outer.self()).mapTo(ClassTag$.MODULE$.apply(DnsProtocol.Resolved.class)).map(AsyncDnsManager::org$apache$pekko$io$dns$internal$AsyncDnsManager$$anon$1$$_$_$$anonfun$2, (ExecutionContext)this.$outer.ec());
                    package$.MODULE$.pipe(reply, (ExecutionContext)this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (AsyncDnsManager$CacheCleanup$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsManager$$cacheCleanup.foreach((Function1)((JProcedure1 & Serializable)AsyncDnsManager::org$apache$pekko$io$dns$internal$AsyncDnsManager$$anon$1$$_$applyOrElse$$anonfun$1));
                    return BoxedUnit.UNIT;
                }
                if (AsyncDnsManager$GetCache$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang(this.$outer.org$apache$pekko$io$dns$internal$AsyncDnsManager$$cache, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$io$dns$internal$AsyncDnsManager$$anon$1$$_$_$$anonfun$2(org.apache.pekko.io.dns.DnsProtocol$Resolved ), org$apache$pekko$io$dns$internal$AsyncDnsManager$$anon$1$$_$applyOrElse$$anonfun$1(org.apache.pekko.io.Dns )}, serializedLambda);
            }
        };
    }

    private static final DnsClient $anonfun$1$$anonfun$1$$anonfun$1(InetSocketAddress ns$1) {
        return new DnsClient(ns$1);
    }

    public static final /* synthetic */ Dns.Resolved org$apache$pekko$io$dns$internal$AsyncDnsManager$$anon$1$$_$_$$anonfun$2(DnsProtocol.Resolved asyncResolved) {
        Seq ips = (Seq)asyncResolved.records().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(ResourceRecord x) {
                ResourceRecord resourceRecord = x;
                if (resourceRecord instanceof ARecord) {
                    ARecord a = (ARecord)resourceRecord;
                    return true;
                }
                if (resourceRecord instanceof AAAARecord) {
                    AAAARecord a = (AAAARecord)resourceRecord;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(ResourceRecord x, Function1 function1) {
                ResourceRecord resourceRecord = x;
                if (resourceRecord instanceof ARecord) {
                    ARecord a = (ARecord)resourceRecord;
                    return a.ip();
                }
                if (resourceRecord instanceof AAAARecord) {
                    AAAARecord a = (AAAARecord)resourceRecord;
                    return a.ip();
                }
                return function1.apply((Object)x);
            }
        });
        return Dns$Resolved$.MODULE$.apply(asyncResolved.name(), (Iterable<InetAddress>)ips);
    }

    public static final /* synthetic */ void org$apache$pekko$io$dns$internal$AsyncDnsManager$$anon$1$$_$applyOrElse$$anonfun$1(Dns _$2) {
        ((PeriodicCacheCleanup)((Object)_$2)).cleanup();
    }
}

