/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns.internal;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.io.dns.RecordClass;
import org.apache.pekko.io.dns.RecordType;
import org.apache.pekko.io.dns.internal.DomainName$;
import org.apache.pekko.io.dns.internal.Question$;
import org.apache.pekko.io.dns.internal.RecordClassSerializer$;
import org.apache.pekko.io.dns.internal.RecordTypeSerializer$;
import org.apache.pekko.util.ByteIterator;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteStringBuilder;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class Question
implements Product,
Serializable {
    private final String name;
    private final RecordType qType;
    private final RecordClass qClass;

    public static Question apply(String string, RecordType recordType, RecordClass recordClass) {
        return Question$.MODULE$.apply(string, recordType, recordClass);
    }

    public static Question fromProduct(Product product) {
        return Question$.MODULE$.fromProduct(product);
    }

    public static Question parse(ByteIterator byteIterator, ByteString byteString) {
        return Question$.MODULE$.parse(byteIterator, byteString);
    }

    public static Question unapply(Question question) {
        return Question$.MODULE$.unapply(question);
    }

    public Question(String name, RecordType qType, RecordClass qClass) {
        this.name = name;
        this.qType = qType;
        this.qClass = qClass;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Question)) return false;
        Question question = (Question)object;
        String string = this.name();
        String string2 = question.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        RecordType recordType = this.qType();
        RecordType recordType2 = question.qType();
        if (recordType == null) {
            if (recordType2 != null) {
                return false;
            }
        } else if (!((Object)recordType).equals(recordType2)) return false;
        RecordClass recordClass = this.qClass();
        RecordClass recordClass2 = question.qClass();
        if (recordClass == null) {
            if (recordClass2 == null) return true;
            return false;
        } else {
            if (!((Object)recordClass).equals(recordClass2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Question;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "Question";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "name";
            }
            case 1: {
                return "qType";
            }
            case 2: {
                return "qClass";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String name() {
        return this.name;
    }

    public RecordType qType() {
        return this.qType;
    }

    public RecordClass qClass() {
        return this.qClass;
    }

    public void write(ByteStringBuilder out) {
        DomainName$.MODULE$.write(out, this.name());
        RecordTypeSerializer$.MODULE$.write(out, this.qType());
        RecordClassSerializer$.MODULE$.write(out, this.qClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSame(Question that) {
        String string = Question.addDot$1(this.name());
        String string2 = Question.addDot$1(that.name());
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        RecordType recordType = this.qType();
        RecordType recordType2 = that.qType();
        if (recordType == null) {
            if (recordType2 != null) {
                return false;
            }
        } else if (!((Object)recordType).equals(recordType2)) return false;
        RecordClass recordClass = this.qClass();
        RecordClass recordClass2 = that.qClass();
        if (recordClass == null) {
            if (recordClass2 == null) return true;
            return false;
        } else {
            if (!((Object)recordClass).equals(recordClass2)) return false;
            return true;
        }
    }

    public Question copy(String name, RecordType qType, RecordClass qClass) {
        return new Question(name, qType, qClass);
    }

    public String copy$default$1() {
        return this.name();
    }

    public RecordType copy$default$2() {
        return this.qType();
    }

    public RecordClass copy$default$3() {
        return this.qClass();
    }

    public String _1() {
        return this.name();
    }

    public RecordType _2() {
        return this.qType();
    }

    public RecordClass _3() {
        return this.qClass();
    }

    private static final String addDot$1(String name) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name)) && !name.endsWith(".")) {
            return name.concat(".");
        }
        return name;
    }
}

