/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.routing.ActorRefRoutee;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.DefaultResizer$;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.Routee;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class DefaultResizer
implements Resizer,
Product,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int lowerBound;
    private final int upperBound;
    private final int pressureThreshold;
    private final double rampupRate;
    private final double backoffThreshold;
    private final double backoffRate;
    private final int messagesPerResize;

    public static DefaultResizer apply(Config config) {
        return DefaultResizer$.MODULE$.apply(config);
    }

    public static DefaultResizer apply(int n, int n2, int n3, double d, double d2, double d3, int n4) {
        return DefaultResizer$.MODULE$.apply(n, n2, n3, d, d2, d3, n4);
    }

    public static Option<DefaultResizer> fromConfig(Config config) {
        return DefaultResizer$.MODULE$.fromConfig(config);
    }

    public static Mirror.Singleton fromProduct(Product product) {
        return DefaultResizer$.MODULE$.fromProduct(product);
    }

    public static DefaultResizer unapply(DefaultResizer defaultResizer) {
        return DefaultResizer$.MODULE$.unapply(defaultResizer);
    }

    public static int $lessinit$greater$default$1() {
        return DefaultResizer$.MODULE$.$lessinit$greater$default$1();
    }

    public static int $lessinit$greater$default$2() {
        return DefaultResizer$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$3() {
        return DefaultResizer$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$4() {
        return DefaultResizer$.MODULE$.$lessinit$greater$default$4();
    }

    public static double $lessinit$greater$default$5() {
        return DefaultResizer$.MODULE$.$lessinit$greater$default$5();
    }

    public static double $lessinit$greater$default$6() {
        return DefaultResizer$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$7() {
        return DefaultResizer$.MODULE$.$lessinit$greater$default$7();
    }

    public DefaultResizer(int lowerBound, int upperBound, int pressureThreshold, double rampupRate, double backoffThreshold, double backoffRate, int messagesPerResize) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.pressureThreshold = pressureThreshold;
        this.rampupRate = rampupRate;
        this.backoffThreshold = backoffThreshold;
        this.backoffRate = backoffRate;
        this.messagesPerResize = messagesPerResize;
        if (lowerBound < 0) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("lowerBound must be >= 0, was: [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)lowerBound)})));
        }
        if (upperBound < 0) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("upperBound must be >= 0, was: [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)upperBound)})));
        }
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("upperBound must be >= lowerBound, was: [%s] < [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)upperBound), BoxesRunTime.boxToInteger((int)lowerBound)})));
        }
        if (rampupRate < 0.0) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("rampupRate must be >= 0.0, was [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rampupRate)})));
        }
        if (backoffThreshold > 1.0) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("backoffThreshold must be <= 1.0, was [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)backoffThreshold)})));
        }
        if (backoffRate < 0.0) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("backoffRate must be >= 0.0, was [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)backoffRate)})));
        }
        if (messagesPerResize <= 0) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("messagesPerResize must be > 0, was [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messagesPerResize)})));
        }
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.lowerBound());
        n = Statics.mix((int)n, (int)this.upperBound());
        n = Statics.mix((int)n, (int)this.pressureThreshold());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.rampupRate()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.backoffThreshold()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.backoffRate()));
        n = Statics.mix((int)n, (int)this.messagesPerResize());
        return Statics.finalizeHash((int)n, (int)7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DefaultResizer)) return false;
        DefaultResizer defaultResizer = (DefaultResizer)object;
        if (this.lowerBound() != defaultResizer.lowerBound()) return false;
        if (this.upperBound() != defaultResizer.upperBound()) return false;
        if (this.pressureThreshold() != defaultResizer.pressureThreshold()) return false;
        if (this.rampupRate() != defaultResizer.rampupRate()) return false;
        if (this.backoffThreshold() != defaultResizer.backoffThreshold()) return false;
        if (this.backoffRate() != defaultResizer.backoffRate()) return false;
        if (this.messagesPerResize() != defaultResizer.messagesPerResize()) return false;
        if (!defaultResizer.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DefaultResizer;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "DefaultResizer";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
            case 3: {
                return BoxesRunTime.boxToDouble((double)this._4());
            }
            case 4: {
                return BoxesRunTime.boxToDouble((double)this._5());
            }
            case 5: {
                return BoxesRunTime.boxToDouble((double)this._6());
            }
            case 6: {
                return BoxesRunTime.boxToInteger((int)this._7());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "lowerBound";
            }
            case 1: {
                return "upperBound";
            }
            case 2: {
                return "pressureThreshold";
            }
            case 3: {
                return "rampupRate";
            }
            case 4: {
                return "backoffThreshold";
            }
            case 5: {
                return "backoffRate";
            }
            case 6: {
                return "messagesPerResize";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int lowerBound() {
        return this.lowerBound;
    }

    public int upperBound() {
        return this.upperBound;
    }

    public int pressureThreshold() {
        return this.pressureThreshold;
    }

    public double rampupRate() {
        return this.rampupRate;
    }

    public double backoffThreshold() {
        return this.backoffThreshold;
    }

    public double backoffRate() {
        return this.backoffRate;
    }

    public int messagesPerResize() {
        return this.messagesPerResize;
    }

    public DefaultResizer(int lower, int upper) {
        this(lower, upper, DefaultResizer$.MODULE$.$lessinit$greater$default$3(), DefaultResizer$.MODULE$.$lessinit$greater$default$4(), DefaultResizer$.MODULE$.$lessinit$greater$default$5(), DefaultResizer$.MODULE$.$lessinit$greater$default$6(), DefaultResizer$.MODULE$.$lessinit$greater$default$7());
    }

    @Override
    public boolean isTimeForResize(long messageCounter) {
        return messageCounter % (long)this.messagesPerResize() == 0L;
    }

    @Override
    public int resize(IndexedSeq<Routee> currentRoutees) {
        return this.capacity(currentRoutees);
    }

    public int capacity(IndexedSeq<Routee> routees) {
        int press;
        int delta;
        int currentSize = routees.size();
        int proposed = currentSize + (delta = this.filter(press = this.pressure(routees), currentSize));
        if (proposed < this.lowerBound()) {
            return delta + (this.lowerBound() - proposed);
        }
        if (proposed > this.upperBound()) {
            return delta - (proposed - this.upperBound());
        }
        return delta;
    }

    public int pressure(IndexedSeq<Routee> routees) {
        return routees.count((Function1 & Serializable)x$1 -> {
            ActorRefRoutee actorRefRoutee;
            ActorRef actorRef;
            Routee routee = x$1;
            if (routee instanceof ActorRefRoutee && (actorRef = (actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee))._1()) instanceof ActorRefWithCell) {
                ActorRefWithCell a = (ActorRefWithCell)actorRef;
                Cell cell = a.underlying();
                if (cell instanceof ActorCell) {
                    ActorCell cell2 = (ActorCell)cell;
                    int n = this.pressureThreshold();
                    if (1 == n) {
                        return cell2.mailbox().isScheduled() && cell2.mailbox().hasMessages();
                    }
                    int i = n;
                    if (i < 1) {
                        return cell2.mailbox().isScheduled() && cell2.currentMessage() != null;
                    }
                    int threshold = n;
                    return cell2.mailbox().numberOfMessages() >= threshold;
                }
                Cell cell3 = cell;
                int n = this.pressureThreshold();
                if (1 == n) {
                    return cell3.hasMessages();
                }
                int i = n;
                if (i < 1) {
                    return true;
                }
                int threshold = n;
                return cell3.numberOfMessages() >= threshold;
            }
            return false;
        });
    }

    public int filter(int pressure, int capacity) {
        return this.rampup(pressure, capacity) + this.backoff(pressure, capacity);
    }

    public int rampup(int pressure, int capacity) {
        if (pressure < capacity) {
            return 0;
        }
        return (int)package$.MODULE$.ceil(this.rampupRate() * (double)capacity);
    }

    public int backoff(int pressure, int capacity) {
        if (this.backoffThreshold() > 0.0 && this.backoffRate() > 0.0 && capacity > 0 && (double)pressure / (double)capacity < this.backoffThreshold()) {
            return (int)package$.MODULE$.floor(-1.0 * this.backoffRate() * (double)capacity);
        }
        return 0;
    }

    public DefaultResizer copy(int lowerBound, int upperBound, int pressureThreshold, double rampupRate, double backoffThreshold, double backoffRate, int messagesPerResize) {
        return new DefaultResizer(lowerBound, upperBound, pressureThreshold, rampupRate, backoffThreshold, backoffRate, messagesPerResize);
    }

    public int copy$default$1() {
        return this.lowerBound();
    }

    public int copy$default$2() {
        return this.upperBound();
    }

    public int copy$default$3() {
        return this.pressureThreshold();
    }

    public double copy$default$4() {
        return this.rampupRate();
    }

    public double copy$default$5() {
        return this.backoffThreshold();
    }

    public double copy$default$6() {
        return this.backoffRate();
    }

    public int copy$default$7() {
        return this.messagesPerResize();
    }

    public int _1() {
        return this.lowerBound();
    }

    public int _2() {
        return this.upperBound();
    }

    public int _3() {
        return this.pressureThreshold();
    }

    public double _4() {
        return this.rampupRate();
    }

    public double _5() {
        return this.backoffThreshold();
    }

    public double _6() {
        return this.backoffRate();
    }

    public int _7() {
        return this.messagesPerResize();
    }
}

