/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.routing.ActorRefRoutee;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.NoRoutee$;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.RoutingLogic;
import org.apache.pekko.routing.SmallestMailboxRoutingLogic$;
import scala.Int$;
import scala.collection.immutable.IndexedSeq;

public class SmallestMailboxRoutingLogic
implements RoutingLogic {
    private static final long serialVersionUID = 1L;

    public static SmallestMailboxRoutingLogic apply() {
        return SmallestMailboxRoutingLogic$.MODULE$.apply();
    }

    @Override
    public Routee select(Object message, IndexedSeq<Routee> routees) {
        if (routees.isEmpty()) {
            return NoRoutee$.MODULE$;
        }
        return this.selectNext(routees, this.selectNext$default$2(), this.selectNext$default$3(), this.selectNext$default$4(), this.selectNext$default$5());
    }

    private Routee selectNext(IndexedSeq<Routee> targets, Routee proposedTarget, long currentScore, int at, boolean deep) {
        while (!targets.isEmpty()) {
            long newScore;
            long l;
            if (at >= targets.size()) {
                if (deep) {
                    if (this.isTerminated(proposedTarget)) {
                        return (Routee)targets.apply(ThreadLocalRandom.current().nextInt(targets.size()));
                    }
                    return proposedTarget;
                }
                int n = 0;
                boolean bl = true;
                at = n;
                deep = bl;
                continue;
            }
            Routee target = (Routee)targets.apply(at);
            if (this.isSuspended(target)) {
                l = 0x7FFFFFFFFFFFFFFEL;
            } else {
                long l2;
                long l3 = this.isProcessingMessage(target) ? 1L : 0L;
                if (!this.hasMessages(target)) {
                    l2 = 0L;
                } else {
                    long noOfMsgs = deep ? Int$.MODULE$.int2long(this.numberOfMessages(target)) : 0L;
                    l2 = noOfMsgs > 0L ? noOfMsgs : 0x7FFFFFFFFFFFFFFCL;
                }
                l = newScore = l3 + l2;
            }
            if (newScore == 0L) {
                return target;
            }
            if (newScore < 0L || newScore >= currentScore) {
                ++at;
                continue;
            }
            Routee routee = target;
            long l4 = newScore;
            int n = at + 1;
            proposedTarget = routee;
            currentScore = l4;
            at = n;
        }
        return NoRoutee$.MODULE$;
    }

    private Routee selectNext$default$2() {
        return NoRoutee$.MODULE$;
    }

    private long selectNext$default$3() {
        return Long.MAX_VALUE;
    }

    private int selectNext$default$4() {
        return 0;
    }

    private boolean selectNext$default$5() {
        return false;
    }

    public boolean isTerminated(Routee a) {
        Routee routee = a;
        if (routee instanceof ActorRefRoutee) {
            ActorRef actorRef;
            ActorRefRoutee actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee);
            ActorRef ref = actorRef = actorRefRoutee._1();
            return ref.isTerminated();
        }
        return false;
    }

    public boolean isProcessingMessage(Routee a) {
        ActorRefRoutee actorRefRoutee;
        ActorRef actorRef;
        Routee routee = a;
        if (routee instanceof ActorRefRoutee && (actorRef = (actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee))._1()) instanceof ActorRefWithCell) {
            ActorRefWithCell x = (ActorRefWithCell)actorRef;
            Cell cell = x.underlying();
            if (cell instanceof ActorCell) {
                ActorCell cell2 = (ActorCell)cell;
                return cell2.mailbox().isScheduled() && cell2.currentMessage() != null;
            }
            return false;
        }
        return false;
    }

    public boolean hasMessages(Routee a) {
        ActorRefRoutee actorRefRoutee;
        ActorRef actorRef;
        Routee routee = a;
        if (routee instanceof ActorRefRoutee && (actorRef = (actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee))._1()) instanceof ActorRefWithCell) {
            ActorRefWithCell x = (ActorRefWithCell)actorRef;
            return x.underlying().hasMessages();
        }
        return false;
    }

    public boolean isSuspended(Routee a) {
        ActorRefRoutee actorRefRoutee;
        ActorRef actorRef;
        Routee routee = a;
        if (routee instanceof ActorRefRoutee && (actorRef = (actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee))._1()) instanceof ActorRefWithCell) {
            ActorRefWithCell x = (ActorRefWithCell)actorRef;
            Cell cell = x.underlying();
            if (cell instanceof ActorCell) {
                ActorCell cell2 = (ActorCell)cell;
                return cell2.mailbox().isSuspended();
            }
            return true;
        }
        return false;
    }

    public int numberOfMessages(Routee a) {
        ActorRefRoutee actorRefRoutee;
        ActorRef actorRef;
        Routee routee = a;
        if (routee instanceof ActorRefRoutee && (actorRef = (actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee))._1()) instanceof ActorRefWithCell) {
            ActorRefWithCell x = (ActorRefWithCell)actorRef;
            return x.underlying().numberOfMessages();
        }
        return 0;
    }
}

