/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.serialization.AsyncSerializer;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import scala.concurrent.Await$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;

public abstract class AsyncSerializerWithStringManifest
extends SerializerWithStringManifest
implements AsyncSerializer {
    private final LoggingAdapter log;

    public AsyncSerializerWithStringManifest(ExtendedActorSystem system) {
        this.log = Logging$.MODULE$.apply(system, AsyncSerializerWithStringManifest.class, LogSource$.MODULE$.fromAnyClass());
    }

    @Override
    public final byte[] toBinary(Object o) {
        this.log.warning("Async serializer called synchronously. This will block. Async serializers should only be used for pekko persistence plugins that support them. Class: {}", o.getClass());
        return (byte[])Await$.MODULE$.result(this.toBinaryAsync(o), (Duration)Duration$.MODULE$.Inf());
    }

    @Override
    public final Object fromBinary(byte[] bytes, String manifest) {
        this.log.warning("Async serializer called synchronously. This will block. Async serializers should only be used for Pekko persistence plugins that support them. Manifest: [{}]", (Object)manifest);
        return Await$.MODULE$.result(this.fromBinaryAsync(bytes, manifest), (Duration)Duration$.MODULE$.Inf());
    }
}

