/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import java.nio.ByteBuffer;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.serialization.BaseSerializer$;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.Serializer;
import scala.Option;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class IntSerializer
implements Serializer,
ByteBufferSerializer {
    private final ExtendedActorSystem system;
    private final int identifier;

    public IntSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig("primitive-int", system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        buf.putInt(BoxesRunTime.unboxToInt((Object)o));
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        return BoxesRunTime.boxToInteger((int)buf.getInt());
    }

    @Override
    public byte[] toBinary(Object o) {
        byte[] result = new byte[4];
        int i = 0;
        for (int j = BoxesRunTime.unboxToInt((Object)o); j != 0; j >>>= 8) {
            result[i] = (byte)(j & 0xFF);
            ++i;
        }
        return result;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        int result = 0;
        for (int i = 3; i >= 0; --i) {
            result <<= 8;
            result |= bytes[i] & 0xFF;
        }
        return BoxesRunTime.boxToInteger((int)result);
    }
}

