/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import scala.MatchError;
import scala.Predef$;

public class BoundedBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final int maxCapacity;
    private final Queue backing;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    public BoundedBlockingQueue(int maxCapacity, Queue<E> backing) {
        this.maxCapacity = maxCapacity;
        this.backing = backing;
        Queue<E> queue = backing;
        if (queue == null) {
            throw new IllegalArgumentException("Backing Queue may not be null");
        }
        if (queue instanceof BlockingQueue) {
            BlockingQueue b = (BlockingQueue)queue;
            Predef$.MODULE$.require(maxCapacity > 0);
            Predef$.MODULE$.require(b.size() == 0);
            Predef$.MODULE$.require(b.remainingCapacity() >= maxCapacity);
        } else if (queue != null) {
            Queue<E> b = queue;
            Predef$.MODULE$.require(b.size() == 0);
            Predef$.MODULE$.require(maxCapacity > 0);
        } else {
            throw new MatchError(queue);
        }
        this.lock = this.createLock();
        this.notEmpty = this.createNotEmptyCondition();
        this.notFull = this.createNotFullCondition();
    }

    public int maxCapacity() {
        return this.maxCapacity;
    }

    public Queue<E> org$apache$pekko$util$BoundedBlockingQueue$$backing() {
        return this.backing;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public Condition notEmpty() {
        return this.notEmpty;
    }

    public Condition notFull() {
        return this.notFull;
    }

    public ReentrantLock createLock() {
        return new ReentrantLock(false);
    }

    public Condition createNotEmptyCondition() {
        return this.lock().newCondition();
    }

    public Condition createNotFullCondition() {
        return this.lock().newCondition();
    }

    @Override
    public void put(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock().lockInterruptibly();
        try {
            this.putElement$1(e);
        }
        finally {
            this.lock().unlock();
        }
    }

    @Override
    public E take() {
        Object object;
        this.lock().lockInterruptibly();
        try {
            object = this.takeElement$1();
        }
        finally {
            this.lock().unlock();
        }
        return (E)object;
    }

    @Override
    public boolean offer(E e) {
        boolean bl;
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock().lock();
        try {
            if (this.org$apache$pekko$util$BoundedBlockingQueue$$backing().size() == this.maxCapacity()) {
                bl = false;
            } else {
                Predef$.MODULE$.require(this.org$apache$pekko$util$BoundedBlockingQueue$$backing().offer(e));
                this.notEmpty().signal();
                bl = true;
            }
        }
        finally {
            this.lock().unlock();
        }
        return bl;
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        boolean bl;
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock().lockInterruptibly();
        try {
            bl = this.offerElement$1(e, unit.toNanos(timeout));
        }
        finally {
            this.lock().unlock();
        }
        return bl;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) {
        Object object;
        this.lock().lockInterruptibly();
        try {
            object = this.pollElement$1(unit.toNanos(timeout));
        }
        finally {
            this.lock().unlock();
        }
        return (E)object;
    }

    @Override
    public E poll() {
        E e;
        this.lock().lock();
        try {
            E e2 = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().poll();
            if (e2 == null) {
                e = null;
            } else {
                E e3 = e2;
                this.notFull().signal();
                e = e3;
            }
        }
        finally {
            this.lock().unlock();
        }
        return e;
    }

    @Override
    public boolean remove(Object e) {
        boolean bl;
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock().lock();
        try {
            if (this.org$apache$pekko$util$BoundedBlockingQueue$$backing().remove(e)) {
                this.notFull().signal();
                bl = true;
            } else {
                bl = false;
            }
        }
        finally {
            this.lock().unlock();
        }
        return bl;
    }

    @Override
    public boolean contains(Object e) {
        boolean bl;
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock().lock();
        try {
            bl = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().contains(e);
        }
        finally {
            this.lock().unlock();
        }
        return bl;
    }

    @Override
    public void clear() {
        this.lock().lock();
        try {
            this.org$apache$pekko$util$BoundedBlockingQueue$$backing().clear();
            this.notFull().signalAll();
        }
        finally {
            this.lock().unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        int n;
        this.lock().lock();
        try {
            n = this.maxCapacity() - this.org$apache$pekko$util$BoundedBlockingQueue$$backing().size();
        }
        finally {
            this.lock().unlock();
        }
        return n;
    }

    @Override
    public int size() {
        int n;
        this.lock().lock();
        try {
            n = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().size();
        }
        finally {
            this.lock().unlock();
        }
        return n;
    }

    @Override
    public E peek() {
        E e;
        this.lock().lock();
        try {
            e = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().peek();
        }
        finally {
            this.lock().unlock();
        }
        return e;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        void v0;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (c == this.org$apache$pekko$util$BoundedBlockingQueue$$backing()) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        this.lock().lock();
        try {
            void var3_3;
            int n = this.drainOne$1(maxElements, c, BoundedBlockingQueue.drainOne$default$1$1());
            if (n > 0) {
                this.notFull().signalAll();
            }
            v0 = var3_3;
        }
        finally {
            this.lock().unlock();
        }
        return (int)v0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean bl;
        this.lock().lock();
        try {
            bl = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().containsAll(c);
        }
        finally {
            this.lock().unlock();
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean bl;
        this.lock().lock();
        try {
            if (this.org$apache$pekko$util$BoundedBlockingQueue$$backing().removeAll(c)) {
                int sz = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().size();
                if (sz < this.maxCapacity()) {
                    this.notFull().signal();
                }
                if (sz > 0) {
                    this.notEmpty().signal();
                }
                bl = true;
            } else {
                bl = false;
            }
        }
        finally {
            this.lock().unlock();
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean bl;
        this.lock().lock();
        try {
            if (this.org$apache$pekko$util$BoundedBlockingQueue$$backing().retainAll(c)) {
                int sz = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().size();
                if (sz < this.maxCapacity()) {
                    this.notFull().signal();
                }
                if (sz > 0) {
                    this.notEmpty().signal();
                }
                bl = true;
            } else {
                bl = false;
            }
        }
        finally {
            this.lock().unlock();
        }
        return bl;
    }

    @Override
    public Iterator<E> iterator() {
        Iterator iterator;
        this.lock().lock();
        try {
            Object[] elements = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().toArray();
            iterator = new Iterator<E>(elements, this){
                private final Object[] elements$1;
                private int at;
                private int last;
                private final /* synthetic */ BoundedBlockingQueue $outer;
                {
                    this.elements$1 = elements$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.at = 0;
                    this.last = -1;
                }

                public int at() {
                    return this.at;
                }

                public void at_$eq(int x$1) {
                    this.at = x$1;
                }

                public int last() {
                    return this.last;
                }

                public void last_$eq(int x$1) {
                    this.last = x$1;
                }

                public boolean hasNext() {
                    return this.at() < this.elements$1.length;
                }

                public Object next() {
                    if (this.at() >= this.elements$1.length) {
                        throw new NoSuchElementException();
                    }
                    this.last_$eq(this.at());
                    this.at_$eq(this.at() + 1);
                    return this.elements$1[this.last()];
                }

                public void remove() {
                    if (this.last() < 0) {
                        throw new IllegalStateException();
                    }
                    Object target = this.elements$1[this.last()];
                    this.last_$eq(-1);
                    this.$outer.lock().lock();
                    try {
                        this.removeTarget$1(target, this.removeTarget$default$1$1());
                    }
                    finally {
                        this.$outer.lock().unlock();
                    }
                }

                private final void removeTarget$1(Object target$1, Iterator i) {
                    while (i.hasNext()) {
                        if (i.next() != target$1) continue;
                        i.remove();
                        this.$outer.notFull().signal();
                        return;
                    }
                }

                private final Iterator removeTarget$default$1$1() {
                    return this.$outer.org$apache$pekko$util$BoundedBlockingQueue$$backing().iterator();
                }
            };
        }
        finally {
            this.lock().unlock();
        }
        return iterator;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        this.lock().lock();
        try {
            objectArray = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().toArray();
        }
        finally {
            this.lock().unlock();
        }
        return objectArray;
    }

    @Override
    public boolean isEmpty() {
        boolean bl;
        this.lock().lock();
        try {
            bl = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().isEmpty();
        }
        finally {
            this.lock().unlock();
        }
        return bl;
    }

    @Override
    public <X> Object[] toArray(X[] a) {
        Object[] objectArray;
        this.lock().lock();
        try {
            objectArray = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().toArray(a);
        }
        finally {
            this.lock().unlock();
        }
        return objectArray;
    }

    private final void putElement$1(Object e$1) {
        while (true) {
            if (this.org$apache$pekko$util$BoundedBlockingQueue$$backing().size() < this.maxCapacity()) {
                Predef$.MODULE$.require(this.org$apache$pekko$util$BoundedBlockingQueue$$backing().offer(e$1));
                this.notEmpty().signal();
                return;
            }
            this.notFull().await();
        }
    }

    private final Object takeElement$1() {
        while (true) {
            if (!this.org$apache$pekko$util$BoundedBlockingQueue$$backing().isEmpty()) {
                E e = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().poll();
                Predef$.MODULE$.require(e != null);
                this.notFull().signal();
                return e;
            }
            this.notEmpty().await();
        }
    }

    private final boolean offerElement$1(Object e$2, long remainingNanos) {
        while (true) {
            if (this.org$apache$pekko$util$BoundedBlockingQueue$$backing().size() < this.maxCapacity()) {
                Predef$.MODULE$.require(this.org$apache$pekko$util$BoundedBlockingQueue$$backing().offer(e$2));
                this.notEmpty().signal();
                return true;
            }
            if (remainingNanos <= 0L) {
                return false;
            }
            remainingNanos = this.notFull().awaitNanos(remainingNanos);
        }
    }

    private final Object pollElement$1(long remainingNanos) {
        E e;
        while ((e = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().poll()) == null) {
            if (remainingNanos <= 0L) {
                return null;
            }
            remainingNanos = this.notEmpty().awaitNanos(remainingNanos);
        }
        E e2 = e;
        this.notFull().signal();
        return e2;
    }

    private final int drainOne$1(int maxElements$1, Collection c$1, int n) {
        while (n < maxElements$1) {
            E e = this.org$apache$pekko$util$BoundedBlockingQueue$$backing().poll();
            if (e == null) {
                return n;
            }
            E e2 = e;
            c$1.add(e2);
            ++n;
        }
        return n;
    }

    private static final int drainOne$default$1$1() {
        return 0;
    }
}

