/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteString$ByteString1$;
import org.apache.pekko.util.ByteString$ByteStrings$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeq;
import scala.collection.IterableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class ByteStringBuilder
implements Builder<Object, ByteString> {
    private int _length;
    private final VectorBuilder<ByteString.ByteString1> _builder;
    private byte[] _temp;
    private int _tempLength;
    private int _tempCapacity;

    public ByteStringBuilder() {
        Growable.$init$((Growable)this);
        Builder.$init$((Builder)this);
        this._length = 0;
        this._builder = new VectorBuilder();
        this._tempLength = 0;
        this._tempCapacity = 0;
    }

    public ByteStringBuilder fillArray(int len, Function2<byte[], Object, BoxedUnit> fill) {
        this.ensureTempSize(this._tempLength + len);
        fill.apply((Object)this._temp, (Object)BoxesRunTime.boxToInteger((int)this._tempLength));
        this._tempLength += len;
        this._length += len;
        return this;
    }

    public final ByteStringBuilder fillByteBuffer(int len, ByteOrder byteOrder, Function1<ByteBuffer, BoxedUnit> fill) {
        return this.fillArray(len, (Function2<byte[], Object, BoxedUnit>)(Function2 & Serializable)(v1, v2) -> {
            ByteStringBuilder.fillByteBuffer$$anonfun$1(len, byteOrder, fill, (byte[])v1, BoxesRunTime.unboxToInt((Object)v2));
            return BoxedUnit.UNIT;
        });
    }

    public int length() {
        return this._length;
    }

    public void sizeHint(int len) {
        this.resizeTemp(len - (this._length - this._tempLength));
    }

    private void clearTemp() {
        if (this._tempLength > 0) {
            byte[] arr = new byte[this._tempLength];
            System.arraycopy(this._temp, 0, arr, 0, this._tempLength);
            this._builder.$plus$eq((Object)ByteString$ByteString1$.MODULE$.apply(arr));
            this._tempLength = 0;
            return;
        }
    }

    private void resizeTemp(int size) {
        byte[] newtemp = new byte[size];
        if (this._tempLength > 0) {
            System.arraycopy(this._temp, 0, newtemp, 0, this._tempLength);
        }
        this._temp = newtemp;
        this._tempCapacity = this._temp.length;
    }

    private boolean shouldResizeTempFor(int size) {
        return this._tempCapacity < size || this._tempCapacity == 0;
    }

    private void ensureTempSize(int size) {
        if (this.shouldResizeTempFor(size)) {
            int newSize;
            int n = newSize = this._tempCapacity == 0 ? 16 : this._tempCapacity * 2;
            while (newSize < size) {
                newSize *= 2;
            }
            this.resizeTemp(newSize);
            return;
        }
    }

    public ByteStringBuilder addOne(byte elem) {
        this.ensureTempSize(this._tempLength + 1);
        this._temp[this._tempLength] = elem;
        ++this._tempLength;
        ++this._length;
        return this;
    }

    public ByteStringBuilder $plus$plus$eq(ByteString bytes) {
        return this.addAll(bytes);
    }

    public ByteStringBuilder addAll(ByteString bytes) {
        if (bytes.nonEmpty()) {
            this.clearTemp();
            ByteString byteString = bytes;
            if (byteString instanceof ByteString.ByteString1C) {
                ByteString.ByteString1C b = (ByteString.ByteString1C)byteString;
                this._builder.$plus$eq((Object)b.toByteString1());
                this._length += b.length();
            } else if (byteString instanceof ByteString.ByteString1) {
                ByteString.ByteString1 b = (ByteString.ByteString1)byteString;
                this._builder.$plus$eq((Object)b);
                this._length += b.length();
            } else if (byteString instanceof ByteString.ByteStrings) {
                ByteString.ByteStrings bs = (ByteString.ByteStrings)byteString;
                this._builder.$plus$plus$eq(bs.bytestrings());
                this._length += bs.length();
            } else {
                throw new MatchError((Object)byteString);
            }
        }
        return this;
    }

    public ByteStringBuilder addAll(IterableOnce<Object> xs) {
        ByteStringBuilder byteStringBuilder;
        IterableOnce<Object> iterableOnce = xs;
        if (iterableOnce instanceof ByteString) {
            ByteString bs = (ByteString)iterableOnce;
            byteStringBuilder = this.addAll(bs);
        } else if (iterableOnce instanceof ArraySeq.ofByte) {
            ArraySeq.ofByte xs2 = (ArraySeq.ofByte)iterableOnce;
            if (xs2.nonEmpty()) {
                this.putByteArrayUnsafe((byte[])xs2.array().clone());
                byteStringBuilder = BoxedUnit.UNIT;
            } else {
                byteStringBuilder = BoxedUnit.UNIT;
            }
        } else if (iterableOnce instanceof IndexedSeq) {
            IndexedSeq indexedSeq = (IndexedSeq)iterableOnce;
            IndexedSeq seq = indexedSeq;
            if (this.shouldResizeTempFor(seq.length())) {
                if (seq.nonEmpty()) {
                    byte[] copied = (byte[])Array$.MODULE$.from(xs, ClassTag$.MODULE$.apply(Byte.TYPE));
                    this.clearTemp();
                    this._builder.$plus$eq((Object)ByteString$ByteString1$.MODULE$.apply(copied));
                    this._length += seq.length();
                    byteStringBuilder = BoxedUnit.UNIT;
                } else {
                    byteStringBuilder = BoxedUnit.UNIT;
                }
            } else {
                IndexedSeq seq2 = indexedSeq;
                if (seq2.nonEmpty()) {
                    this.ensureTempSize(this._tempLength + seq2.size());
                    seq2.copyToArray((Object)this._temp, this._tempLength);
                    this._tempLength += seq2.length();
                    this._length += seq2.length();
                    byteStringBuilder = BoxedUnit.UNIT;
                } else {
                    byteStringBuilder = BoxedUnit.UNIT;
                }
            }
        } else {
            byteStringBuilder = Growable.addAll$((Growable)this, xs);
        }
        return this;
    }

    public ByteStringBuilder putByteArrayUnsafe(byte[] xs) {
        this.clearTemp();
        this._builder.$plus$eq((Object)ByteString$ByteString1$.MODULE$.apply(xs));
        this._length += xs.length;
        return this;
    }

    public ByteStringBuilder append(ByteString bs) {
        if (bs.isEmpty()) {
            return this;
        }
        return this.$plus$plus$eq(bs);
    }

    public ByteStringBuilder putByte(byte x) {
        return (ByteStringBuilder)this.$plus$eq(BoxesRunTime.boxToByte((byte)x));
    }

    public ByteStringBuilder putShort(int x, ByteOrder byteOrder) {
        ByteOrder byteOrder2 = byteOrder;
        ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            this.$plus$eq(BoxesRunTime.boxToByte((byte)((byte)(x >>> 8))));
            return (ByteStringBuilder)this.$plus$eq(BoxesRunTime.boxToByte((byte)((byte)(x >>> 0))));
        }
        ByteOrder byteOrder4 = byteOrder;
        ByteOrder byteOrder5 = ByteOrder.LITTLE_ENDIAN;
        if (!(byteOrder4 != null ? !byteOrder4.equals(byteOrder5) : byteOrder5 != null)) {
            this.$plus$eq(BoxesRunTime.boxToByte((byte)((byte)(x >>> 0))));
            return (ByteStringBuilder)this.$plus$eq(BoxesRunTime.boxToByte((byte)((byte)(x >>> 8))));
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unknown byte order ").append(byteOrder).toString());
    }

    public ByteStringBuilder putInt(int x, ByteOrder byteOrder) {
        this.fillArray(4, (Function2<byte[], Object, BoxedUnit>)(Function2 & Serializable)(v1, v2) -> {
            ByteStringBuilder.putInt$$anonfun$1(byteOrder, x, (byte[])v1, BoxesRunTime.unboxToInt((Object)v2));
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ByteStringBuilder putLong(long x, ByteOrder byteOrder) {
        this.fillArray(8, (Function2<byte[], Object, BoxedUnit>)(Function2 & Serializable)(v1, v2) -> {
            ByteStringBuilder.putLong$$anonfun$1(byteOrder, x, (byte[])v1, BoxesRunTime.unboxToInt((Object)v2));
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public ByteStringBuilder putLongPart(long x, int n, ByteOrder byteOrder) {
        return this.fillArray(n, (Function2<byte[], Object, BoxedUnit>)(Function2 & Serializable)(v1, v2) -> {
            ByteStringBuilder.putLongPart$$anonfun$1(byteOrder, n, x, (byte[])v1, BoxesRunTime.unboxToInt((Object)v2));
            return BoxedUnit.UNIT;
        });
    }

    public ByteStringBuilder putFloat(float x, ByteOrder byteOrder) {
        return this.putInt(Float.floatToRawIntBits(x), byteOrder);
    }

    public ByteStringBuilder putDouble(double x, ByteOrder byteOrder) {
        return this.putLong(Double.doubleToRawLongBits(x), byteOrder);
    }

    public ByteStringBuilder putBytes(byte[] array) {
        return this.putBytes(array, 0, array.length);
    }

    public ByteStringBuilder putBytes(byte[] array, int start, int len) {
        return this.fillArray(len, (Function2<byte[], Object, BoxedUnit>)(Function2 & Serializable)(v1, v2) -> {
            ByteStringBuilder.putBytes$$anonfun$1(array, start, len, (byte[])v1, BoxesRunTime.unboxToInt((Object)v2));
            return BoxedUnit.UNIT;
        });
    }

    public ByteStringBuilder putShorts(short[] array, ByteOrder byteOrder) {
        return this.putShorts(array, 0, array.length, byteOrder);
    }

    public ByteStringBuilder putShorts(short[] array, int start, int len, ByteOrder byteOrder) {
        return this.fillByteBuffer(len * 2, byteOrder, (Function1<ByteBuffer, BoxedUnit>)(JProcedure1 & Serializable)_$12 -> _$12.asShortBuffer().put(array, start, len));
    }

    public ByteStringBuilder putInts(int[] array, ByteOrder byteOrder) {
        return this.putInts(array, 0, array.length, byteOrder);
    }

    public ByteStringBuilder putInts(int[] array, int start, int len, ByteOrder byteOrder) {
        return this.fillByteBuffer(len * 4, byteOrder, (Function1<ByteBuffer, BoxedUnit>)(JProcedure1 & Serializable)_$13 -> _$13.asIntBuffer().put(array, start, len));
    }

    public ByteStringBuilder putLongs(long[] array, ByteOrder byteOrder) {
        return this.putLongs(array, 0, array.length, byteOrder);
    }

    public ByteStringBuilder putLongs(long[] array, int start, int len, ByteOrder byteOrder) {
        return this.fillByteBuffer(len * 8, byteOrder, (Function1<ByteBuffer, BoxedUnit>)(JProcedure1 & Serializable)_$14 -> _$14.asLongBuffer().put(array, start, len));
    }

    public ByteStringBuilder putFloats(float[] array, ByteOrder byteOrder) {
        return this.putFloats(array, 0, array.length, byteOrder);
    }

    public ByteStringBuilder putFloats(float[] array, int start, int len, ByteOrder byteOrder) {
        return this.fillByteBuffer(len * 4, byteOrder, (Function1<ByteBuffer, BoxedUnit>)(JProcedure1 & Serializable)_$15 -> _$15.asFloatBuffer().put(array, start, len));
    }

    public ByteStringBuilder putDoubles(double[] array, ByteOrder byteOrder) {
        return this.putDoubles(array, 0, array.length, byteOrder);
    }

    public ByteStringBuilder putDoubles(double[] array, int start, int len, ByteOrder byteOrder) {
        return this.fillByteBuffer(len * 8, byteOrder, (Function1<ByteBuffer, BoxedUnit>)(JProcedure1 & Serializable)_$16 -> _$16.asDoubleBuffer().put(array, start, len));
    }

    public void clear() {
        this._builder.clear();
        this._length = 0;
        this._tempLength = 0;
    }

    public ByteString result() {
        if (this._length == 0) {
            return ByteString$.MODULE$.empty();
        }
        this.clearTemp();
        Vector bytestrings = this._builder.result();
        if (bytestrings.size() == 1) {
            return (ByteString)bytestrings.head();
        }
        return ByteString$ByteStrings$.MODULE$.apply((Vector<ByteString.ByteString1>)bytestrings, this._length);
    }

    public OutputStream asOutputStream() {
        return new OutputStream(this){
            private final /* synthetic */ ByteStringBuilder $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void write(int b) {
                this.$outer.$plus$eq(BoxesRunTime.boxToByte((byte)((byte)b)));
            }

            public void write(byte[] b, int off, int len) {
                this.$outer.putBytes(b, off, len);
            }
        };
    }

    public boolean isEmpty() {
        return this._length == 0;
    }

    public boolean nonEmpty() {
        return this._length > 0;
    }

    private static final /* synthetic */ void fillByteBuffer$$anonfun$1(int len$1, ByteOrder byteOrder$1, Function1 fill$1, byte[] x$1, int x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToInteger((int)x$2));
        if (tuple2 != null) {
            byte[] array = (byte[])tuple2._1();
            int start = BoxesRunTime.unboxToInt((Object)tuple2._2());
            ByteBuffer buffer = ByteBuffer.wrap(array, start, len$1);
            buffer.order(byteOrder$1);
            fill$1.apply((Object)buffer);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ void putInt$$anonfun$1(ByteOrder byteOrder$2, int x$1, byte[] target, int offset) {
        ByteOrder byteOrder = byteOrder$2;
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null)) {
            target[offset + 0] = (byte)(x$1 >>> 24);
            target[offset + 1] = (byte)(x$1 >>> 16);
            target[offset + 2] = (byte)(x$1 >>> 8);
            target[offset + 3] = (byte)(x$1 >>> 0);
            return;
        }
        ByteOrder byteOrder3 = byteOrder$2;
        ByteOrder byteOrder4 = ByteOrder.LITTLE_ENDIAN;
        if (!(byteOrder3 != null ? !byteOrder3.equals(byteOrder4) : byteOrder4 != null)) {
            target[offset + 0] = (byte)(x$1 >>> 0);
            target[offset + 1] = (byte)(x$1 >>> 8);
            target[offset + 2] = (byte)(x$1 >>> 16);
            target[offset + 3] = (byte)(x$1 >>> 24);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unknown byte order ").append(byteOrder$2).toString());
    }

    private static final /* synthetic */ void putLong$$anonfun$1(ByteOrder byteOrder$3, long x$2, byte[] target, int offset) {
        ByteOrder byteOrder = byteOrder$3;
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null)) {
            target[offset + 0] = (byte)(x$2 >>> 56);
            target[offset + 1] = (byte)(x$2 >>> 48);
            target[offset + 2] = (byte)(x$2 >>> 40);
            target[offset + 3] = (byte)(x$2 >>> 32);
            target[offset + 4] = (byte)(x$2 >>> 24);
            target[offset + 5] = (byte)(x$2 >>> 16);
            target[offset + 6] = (byte)(x$2 >>> 8);
            target[offset + 7] = (byte)(x$2 >>> 0);
            return;
        }
        ByteOrder byteOrder3 = byteOrder$3;
        ByteOrder byteOrder4 = ByteOrder.LITTLE_ENDIAN;
        if (!(byteOrder3 != null ? !byteOrder3.equals(byteOrder4) : byteOrder4 != null)) {
            target[offset + 0] = (byte)(x$2 >>> 0);
            target[offset + 1] = (byte)(x$2 >>> 8);
            target[offset + 2] = (byte)(x$2 >>> 16);
            target[offset + 3] = (byte)(x$2 >>> 24);
            target[offset + 4] = (byte)(x$2 >>> 32);
            target[offset + 5] = (byte)(x$2 >>> 40);
            target[offset + 6] = (byte)(x$2 >>> 48);
            target[offset + 7] = (byte)(x$2 >>> 56);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unknown byte order ").append(byteOrder$3).toString());
    }

    private static final /* synthetic */ void putLongPart$$anonfun$1(ByteOrder byteOrder$4, int n$2, long x$3, byte[] target, int offset) {
        ByteOrder byteOrder = byteOrder$4;
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null)) {
            int start = n$2 * 8 - 8;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n$2).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                target$1[offset$1 + i] = (byte)(x$3 >>> start - 8 * i);
            });
            return;
        }
        ByteOrder byteOrder3 = byteOrder$4;
        ByteOrder byteOrder4 = ByteOrder.LITTLE_ENDIAN;
        if (!(byteOrder3 != null ? !byteOrder3.equals(byteOrder4) : byteOrder4 != null)) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n$2).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                target$2[offset$2 + i] = (byte)(x$3 >>> 8 * i);
            });
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unknown byte order ").append(byteOrder$4).toString());
    }

    private static final /* synthetic */ void putBytes$$anonfun$1(byte[] array$1, int start$2, int len$2, byte[] x$1, int x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToInteger((int)x$2));
        if (tuple2 != null) {
            byte[] target = (byte[])tuple2._1();
            int targetOffset = BoxesRunTime.unboxToInt((Object)tuple2._2());
            System.arraycopy(array$1, start$2, target, targetOffset, len$2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

