/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.FastFrequencySketch$;
import org.apache.pekko.util.FrequencySketch$Bits$;
import org.apache.pekko.util.FrequencySketchUtil$;
import scala.Array$;
import scala.Predef$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class FastFrequencySketch<A> {
    private final int resetSize;
    private final int rowWidth;
    private final int indexMask;
    private final long[][] matrix;
    private final int[] rowSizes;
    private int updatedSize;

    public static <A> FastFrequencySketch<A> apply(int n, int n2, double d) {
        return FastFrequencySketch$.MODULE$.apply(n, n2, d);
    }

    public static <A> int apply$default$2() {
        return FastFrequencySketch$.MODULE$.apply$default$2();
    }

    public static <A> double apply$default$3() {
        return FastFrequencySketch$.MODULE$.apply$default$3();
    }

    public FastFrequencySketch(int width, int resetSize) {
        this.resetSize = resetSize;
        Predef$.MODULE$.require(FrequencySketch$Bits$.MODULE$.isPowerOfTwo(width), FastFrequencySketch::$init$$$anonfun$6);
        int Depth = 4;
        int SlotShift = 4;
        int SlotMask = 15;
        int CounterShift = 2;
        long CounterMask = 15L;
        long OddMask = 0x1111111111111111L;
        long ResetMask = 0x7777777777777777L;
        long Seed0 = -4348849565147123417L;
        long Seed1 = -5435081209227447693L;
        long Seed2 = -7286425919675154353L;
        long Seed3 = -3750763034362895579L;
        this.rowWidth = package$.MODULE$.max(1, width >>> 4);
        this.indexMask = width - 1;
        this.matrix = (long[][])Array$.MODULE$.fill(4, this::$init$$$anonfun$7, ClassTag$.MODULE$.apply(Long.TYPE).wrap());
        this.rowSizes = new int[4];
        this.updatedSize = 0;
    }

    public int size() {
        return this.updatedSize;
    }

    public int frequency(A value) {
        int hash = this.rehash(value.hashCode());
        int minCount = this.getCounter(0, this.index(hash, -4348849565147123417L));
        minCount = Math.min(minCount, this.getCounter(1, this.index(hash, -5435081209227447693L)));
        minCount = Math.min(minCount, this.getCounter(2, this.index(hash, -7286425919675154353L)));
        minCount = Math.min(minCount, this.getCounter(3, this.index(hash, -3750763034362895579L)));
        return minCount;
    }

    public void increment(A value) {
        int hash = this.rehash(value.hashCode());
        boolean updated = this.incrementCounter(0, this.index(hash, -4348849565147123417L));
        updated |= this.incrementCounter(1, this.index(hash, -5435081209227447693L));
        updated |= this.incrementCounter(2, this.index(hash, -7286425919675154353L));
        if (updated |= this.incrementCounter(3, this.index(hash, -3750763034362895579L))) {
            ++this.updatedSize;
            if (this.updatedSize == this.resetSize) {
                this.reset();
                return;
            }
            return;
        }
    }

    private int rehash(int hash) {
        int x = hash;
        x = (x >>> 15 ^ x) * -781669715;
        x = (x >>> 15 ^ x) * -1351469673;
        return x >>> 15 ^ x;
    }

    private int index(int hash, long seed) {
        long x = ((long)hash + seed) * seed;
        return (int)(x + (x >>> 32)) & this.indexMask;
    }

    private int getCounter(int row, int index) {
        int column = index >>> 4;
        int slot = (index & 0xF) << 2;
        return (int)(this.matrix[row][column] >>> slot & 0xFL);
    }

    private boolean incrementCounter(int row, int index) {
        int column = index >>> 4;
        int slot = (index & 0xF) << 2;
        long mask = 15L << slot;
        if ((this.matrix[row][column] & mask) != mask) {
            long[] lArray = this.matrix[row];
            lArray[column] = lArray[column] + (1L << slot);
            this.rowSizes[row] = this.rowSizes[row] + 1;
            return true;
        }
        return false;
    }

    private void reset() {
        for (int row = 0; row < 4; ++row) {
            int odd = 0;
            for (int column = 0; column < this.rowWidth; ++column) {
                odd += Long.bitCount(this.matrix[row][column] & 0x1111111111111111L);
                this.matrix[row][column] = this.matrix[row][column] >>> 1 & 0x7777777777777777L;
            }
            this.rowSizes[row] = this.rowSizes[row] - odd >>> 1;
        }
        this.updatedSize = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(this.rowSizes).max((Ordering)Ordering.Int$.MODULE$));
    }

    public String toDebugString() {
        return FrequencySketchUtil$.MODULE$.debugString(this.matrix, this.rowWidth, 16, 4, 15L);
    }

    private static final Object $init$$$anonfun$6() {
        return "width must be a power of two";
    }

    private final long[] $init$$$anonfun$7() {
        return new long[this.rowWidth];
    }
}

