/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.util.ManifestInfo$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;

public final class ManifestInfo
implements Extension {
    private final ExtendedActorSystem system;
    private final Map versions;

    public static Extension apply(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.apply(classicActorSystemProvider);
    }

    public static ManifestInfo createExtension(ExtendedActorSystem extendedActorSystem) {
        return ManifestInfo$.MODULE$.createExtension(extendedActorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.get(actorSystem);
    }

    public static ManifestInfo get(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.get(classicActorSystemProvider);
    }

    public static ManifestInfo get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.get(classicActorSystemProvider);
    }

    public static ManifestInfo$ lookup() {
        return ManifestInfo$.MODULE$.lookup();
    }

    /*
     * WARNING - void declaration
     */
    public ManifestInfo(ExtendedActorSystem system) {
        void var2_2;
        this.system = system;
        Map manifests = Predef$.MODULE$.Map().empty();
        ManifestInfo manifestInfo = this;
        try {
            Enumeration<URL> resources = system.dynamicAccess().classLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try (InputStream ios = resources.nextElement().openStream();){
                    String v;
                    String vendor;
                    String v2;
                    String t;
                    Manifest manifest = new Manifest(ios);
                    Attributes attributes = manifest.getMainAttributes();
                    String string = attributes.getValue(new Attributes.Name(ManifestInfo$.org$apache$pekko$util$ManifestInfo$$$ImplTitle));
                    String title = string == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.org$apache$pekko$util$ManifestInfo$$$BundleName)) : (t = string);
                    String string2 = attributes.getValue(new Attributes.Name(ManifestInfo$.org$apache$pekko$util$ManifestInfo$$$ImplVersion));
                    String version = string2 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.org$apache$pekko$util$ManifestInfo$$$BundleVersion)) : (v2 = string2);
                    String string3 = attributes.getValue(new Attributes.Name(ManifestInfo$.org$apache$pekko$util$ManifestInfo$$$ImplVendor));
                    String string4 = vendor = string3 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.org$apache$pekko$util$ManifestInfo$$$BundleVendor)) : (v = string3);
                    if (title == null || version == null || vendor == null || !ManifestInfo$.org$apache$pekko$util$ManifestInfo$$$knownVendors.apply((Object)vendor)) continue;
                    manifests = (Map)manifests.updated((Object)title, (Object)new Version(version));
                }
            }
        }
        catch (IOException ioe) {
            Logging$.MODULE$.apply(system, ManifestInfo.class, LogSource$.MODULE$.fromAnyClass()).warning("Could not read manifest information. {}", ioe);
        }
        ManifestInfo manifestInfo2 = manifestInfo;
        manifestInfo = null;
        manifestInfo2.versions = var2_2;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Map<String, Version> versions() {
        return this.versions;
    }

    public boolean checkSameVersion(String productName, Seq<String> dependencies, boolean logWarning) {
        return this.checkSameVersion(productName, dependencies, logWarning, this.system().settings().FailMixedVersions());
    }

    public boolean checkSameVersion(String productName, Seq<String> dependencies, boolean logWarning, boolean throwException) {
        Option<String> option = ManifestInfo$.MODULE$.checkSameVersion(productName, dependencies, this.versions());
        if (option instanceof Some) {
            String message = (String)((Some)option).value();
            if (logWarning) {
                Logging$.MODULE$.apply(this.system(), ManifestInfo.class, LogSource$.MODULE$.fromAnyClass()).warning(message);
            }
            if (throwException) {
                throw new IllegalStateException(message);
            }
            return false;
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    public static final class Version
    implements Comparable<Version> {
        private final String version;
        private final org.apache.pekko.util.Version impl;

        public Version(String version) {
            this.version = version;
            this.impl = new org.apache.pekko.util.Version(version);
        }

        public String version() {
            return this.version;
        }

        private org.apache.pekko.util.Version impl() {
            return this.impl;
        }

        @Override
        public int compareTo(Version other) {
            return this.impl().compareTo(other.impl());
        }

        public boolean equals(Object o) {
            Object object = o;
            if (object instanceof Version) {
                Version v = (Version)object;
                return this.impl().equals(v.impl());
            }
            return false;
        }

        public int hashCode() {
            return this.impl().hashCode();
        }

        public String toString() {
            return this.impl().toString();
        }
    }
}

