/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.util.Comparator;
import java.util.UUID;
import org.apache.pekko.util.UUIDComparator$;

public class UUIDComparator
implements Comparator<UUID> {
    public static UUIDComparator comparator() {
        return UUIDComparator$.MODULE$.comparator();
    }

    @Override
    public int compare(UUID u1, UUID u2) {
        int version = u1.version();
        int diff = version - u2.version();
        if (diff != 0) {
            return diff;
        }
        if (version == 1) {
            int diff2 = this.compareULongs(u1.timestamp(), u2.timestamp());
            if (diff2 == 0) {
                return this.compareULongs(u1.getLeastSignificantBits(), u2.getLeastSignificantBits());
            }
            return diff2;
        }
        int diff2 = this.compareULongs(u1.getMostSignificantBits(), u2.getMostSignificantBits());
        if (diff2 == 0) {
            return this.compareULongs(u1.getLeastSignificantBits(), u2.getLeastSignificantBits());
        }
        return diff2;
    }

    private int compareULongs(long l1, long l2) {
        int diff = this.compareUInts((int)(l1 >> 32), (int)(l2 >> 32));
        if (diff == 0) {
            return this.compareUInts((int)l1, (int)l2);
        }
        return diff;
    }

    private int compareUInts(int i1, int i2) {
        if (i1 < 0) {
            if (i2 < 0) {
                return i1 - i2;
            }
            return 1;
        }
        if (i2 < 0) {
            return -1;
        }
        return i1 - i2;
    }
}

