/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.Version$;
import scala.Array$;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class Version
implements Comparable<Version> {
    private final String version;
    private volatile int[] numbers;
    private String rest;

    public static Version Zero() {
        return Version$.MODULE$.Zero();
    }

    public static Version apply(String string) {
        return Version$.MODULE$.apply(string);
    }

    public Version(String version) {
        this.version = version;
        this.numbers = Array$.MODULE$.emptyIntArray();
        this.rest = "";
    }

    public String version() {
        return this.version;
    }

    private int[] numbers() {
        return this.numbers;
    }

    private void numbers_$eq(int[] x$0) {
        this.numbers = x$0;
    }

    private String rest() {
        return this.rest;
    }

    private void rest_$eq(String x$0) {
        this.rest = x$0;
    }

    @InternalApi
    public Version parse() {
        if (this.numbers().length == 0) {
            String string;
            int[] nbrs = new int[4];
            String[] segments = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.version()), '.');
            if (segments.length == 1) {
                String s = segments[0];
                if (s.isEmpty()) {
                    throw new IllegalArgumentException("Empty version not supported.");
                }
                nbrs[1] = Version$.org$apache$pekko$util$Version$$$Undefined;
                nbrs[2] = Version$.org$apache$pekko$util$Version$$$Undefined;
                nbrs[3] = Version$.org$apache$pekko$util$Version$$$Undefined;
                if (RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(s.charAt(0)))) {
                    try {
                        nbrs[0] = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s));
                        string = "";
                    }
                    catch (NumberFormatException numberFormatException) {
                        string = s;
                    }
                } else {
                    string = s;
                }
            } else if (segments.length == 2) {
                Tuple3 tuple3 = Version.parseLastParts$1(segments[1]);
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                int n1 = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int n2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                String rest = (String)tuple3._3();
                Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n1), (Object)BoxesRunTime.boxToInteger((int)n2), (Object)rest);
                int n12 = BoxesRunTime.unboxToInt((Object)tuple32._1());
                int n22 = BoxesRunTime.unboxToInt((Object)tuple32._2());
                String rest2 = (String)tuple32._3();
                nbrs[0] = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments[0]));
                nbrs[1] = n12;
                nbrs[2] = n22;
                nbrs[3] = Version$.org$apache$pekko$util$Version$$$Undefined;
                string = rest2;
            } else if (segments.length == 3) {
                Tuple3 tuple3 = Version.parseLastParts$1(segments[2]);
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                int n1 = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int n2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                String rest = (String)tuple3._3();
                Tuple3 tuple33 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n1), (Object)BoxesRunTime.boxToInteger((int)n2), (Object)rest);
                int n13 = BoxesRunTime.unboxToInt((Object)tuple33._1());
                int n23 = BoxesRunTime.unboxToInt((Object)tuple33._2());
                String rest3 = (String)tuple33._3();
                nbrs[0] = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments[0]));
                nbrs[1] = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments[1]));
                nbrs[2] = n13;
                nbrs[3] = n23;
                string = rest3;
            } else {
                throw new IllegalArgumentException(new StringBuilder(50).append("Only 3 digits separated with '.' are supported. [").append(this.version()).append("]").toString());
            }
            String rst = string;
            this.rest_$eq(rst);
            this.numbers_$eq(nbrs);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(Version other) {
        String string = this.version();
        String string2 = other.version();
        if (string == null) {
            if (string2 == null) return 0;
        } else if (string.equals(string2)) {
            return 0;
        }
        this.parse();
        other.parse();
        int diff = 0;
        diff = this.numbers()[0] - other.numbers()[0];
        if (diff != 0) return diff;
        diff = this.numbers()[1] - other.numbers()[1];
        if (diff != 0) return diff;
        diff = this.numbers()[2] - other.numbers()[2];
        if (diff != 0) return diff;
        diff = this.numbers()[3] - other.numbers()[3];
        if (diff != 0) return diff;
        String string3 = this.rest();
        String string4 = "";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            String string5 = other.rest();
            String string6 = "";
            if (string5 == null ? string6 != null : !string5.equals(string6)) {
                diff = 1;
            }
        }
        String string7 = other.rest();
        String string8 = "";
        if (string7 == null) {
            if (string8 != null) {
                return this.rest().compareTo(other.rest());
            }
        } else if (!string7.equals(string8)) return this.rest().compareTo(other.rest());
        String string9 = this.rest();
        String string10 = "";
        if (string9 == null) {
            if (string10 == null) return this.rest().compareTo(other.rest());
            return -1;
        } else if (string9.equals(string10)) return this.rest().compareTo(other.rest());
        return -1;
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof Version) {
            Version v = (Version)object;
            return this.compareTo(v) == 0;
        }
        return false;
    }

    public int hashCode() {
        this.parse();
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, this.numbers()[0]);
        result = HashCode$.MODULE$.hash(result, this.numbers()[1]);
        result = HashCode$.MODULE$.hash(result, this.numbers()[2]);
        result = HashCode$.MODULE$.hash(result, this.numbers()[3]);
        result = HashCode$.MODULE$.hash(result, this.rest());
        return result;
    }

    public String toString() {
        return this.version();
    }

    private static final Tuple2 parseLastPart$1(String s) {
        int k;
        if (s.length() == 0) {
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Version$.org$apache$pekko$util$Version$$$Undefined));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)s);
        }
        int i = s.indexOf(45);
        int j = s.indexOf(43);
        int n = i == -1 ? j : (k = j == -1 ? i : package$.MODULE$.min(i, j));
        if (k == -1) {
            Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n2, (Object)"");
        }
        Integer n3 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s.substring(0, k)))));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n3, (Object)s.substring(k + 1));
    }

    private static final Tuple2 parseDynverPart$1(String s) {
        Tuple2 tuple2;
        if (s.isEmpty() || !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(s.charAt(0)))) {
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Version$.org$apache$pekko$util$Version$$$Undefined));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)s);
        }
        int n = s.indexOf(45);
        if (-1 == n) {
            Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Version$.org$apache$pekko$util$Version$$$Undefined));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n2, (Object)s);
        }
        int i = n;
        try {
            Integer n3 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s.substring(0, i)))));
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n3, (Object)s.substring(i + 1));
        }
        catch (NumberFormatException numberFormatException) {
            Integer n4 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Version$.org$apache$pekko$util$Version$$$Undefined));
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n4, (Object)s);
        }
        return tuple2;
    }

    private static final Tuple3 parseLastParts$1(String s) {
        String rest;
        Tuple2 tuple2 = Version.parseLastPart$1(s);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int lastNumber = BoxesRunTime.unboxToInt((Object)tuple2._1());
        String rest2 = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)lastNumber), (Object)rest2);
        int lastNumber2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        String string = rest = (String)tuple22._2();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)lastNumber2), (Object)BoxesRunTime.boxToInteger((int)Version$.org$apache$pekko$util$Version$$$Undefined), (Object)rest);
        }
        Tuple2 tuple23 = Version.parseDynverPart$1(rest);
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        int dynverNumber = BoxesRunTime.unboxToInt((Object)tuple23._1());
        String rest22 = (String)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)dynverNumber), (Object)rest22);
        int dynverNumber2 = BoxesRunTime.unboxToInt((Object)tuple24._1());
        String rest23 = (String)tuple24._2();
        return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)lastNumber2), (Object)BoxesRunTime.boxToInteger((int)dynverNumber2), (Object)rest23);
    }
}

