/*
 * Decompiled with CFR 0.152.
 */
package sttp.model.headers;

import java.io.Serializable;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sttp.model.headers.Range;
import sttp.model.internal.ParseUtils$;
import sttp.model.internal.Validate$;

public final class Range$
implements Mirror.Product,
Serializable {
    public static final Range$ MODULE$ = new Range$();

    private Range$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Range$.class);
    }

    public Range apply(Option<Object> start, Option<Object> end, String unit) {
        return new Range(start, end, unit);
    }

    public Range unapply(Range x$1) {
        return x$1;
    }

    public Either<String, List<Range>> parse(String str) {
        Object object;
        String[] stringArray = str.split("=");
        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
            String unit;
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String s = string2;
            List<Range> ranges = this.processString(s, unit = string);
            if (ranges.forall((Function1 & Serializable)range -> MODULE$.validateRange((Range)range)) && ranges.nonEmpty()) {
                return package$.MODULE$.Right().apply((Object)ranges.reverse());
            }
            return package$.MODULE$.Left().apply((Object)"Invalid Range");
        }
        return package$.MODULE$.Left().apply((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected range in the format: \"unit=start/end\", but got: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{str})));
    }

    private List<Range> processString(String s, String unit) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])s.split(","));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> MODULE$.parseSingleRange((String)_$1, unit), ClassTag$.MODULE$.apply(Range.class)));
        return Predef$.MODULE$.wrapRefArray((Object[])((Range[])ArrayOps$.MODULE$.reverse$extension(object2))).toList();
    }

    private Range parseSingleRange(String rangeString, String unit) {
        String[] stringArray = rangeString.trim().split("-");
        if (stringArray != null) {
            Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) == 0) {
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String start = string;
                String end = string2;
                return this.apply(ParseUtils$.MODULE$.toLongOption(start), ParseUtils$.MODULE$.toLongOption(end), unit);
            }
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) == 0) {
                String string;
                String start = string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                return this.apply(ParseUtils$.MODULE$.toLongOption(start), (Option<Object>)None$.MODULE$, unit);
            }
        }
        return this.apply((Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, unit);
    }

    private boolean validateRange(Range range) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(range.start(), range.end());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                long start = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                if (option2 instanceof Some) {
                    long end = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                    return start <= end;
                }
            }
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return false;
            }
        }
        return true;
    }

    public List<Range> unsafeParse(String s) {
        return Validate$.MODULE$.RichEither(this.parse(s)).getOrThrow();
    }

    public List<Range> unsafeApply(Option<Object> start, Option<Object> end, String unit) {
        return Validate$.MODULE$.RichEither(this.safeApply(start, end, unit)).getOrThrow();
    }

    public Either<String, List<Range>> safeApply(Option<Object> start, Option<Object> end, String unit) {
        Range range = this.apply(start, end, unit);
        if (this.validateRange(range)) {
            return package$.MODULE$.Right().apply((Object)new .colon.colon((Object)range, (List)Nil$.MODULE$));
        }
        return package$.MODULE$.Left().apply((Object)"Invalid Range");
    }

    public Range fromProduct(Product x$0) {
        return new Range((Option<Object>)((Option)x$0.productElement(0)), (Option<Object>)((Option)x$0.productElement(1)), (String)x$0.productElement(2));
    }
}

