/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.util.Undoable;

public class UndoRedoActivity
implements Undoable {
    private Undoable myReversedActivity;

    protected UndoRedoActivity(Undoable undoable) {
        this.setReversedActivity(undoable);
    }

    public boolean undo() {
        if (this.isRedoable()) {
            return this.getReversedActivity().redo();
        }
        return false;
    }

    public boolean redo() {
        if (this.isUndoable()) {
            return this.getReversedActivity().undo();
        }
        return false;
    }

    public boolean isUndoable() {
        return this.getReversedActivity().isRedoable();
    }

    public void setUndoable(boolean bl) {
        this.getReversedActivity().setRedoable(bl);
    }

    public boolean isRedoable() {
        return this.getReversedActivity().isUndoable();
    }

    public void setRedoable(boolean bl) {
        this.getReversedActivity().setUndoable(bl);
    }

    public void setAffectedFigures(FigureEnumeration figureEnumeration) {
        this.getReversedActivity().setAffectedFigures(figureEnumeration);
    }

    public FigureEnumeration getAffectedFigures() {
        return this.getReversedActivity().getAffectedFigures();
    }

    public int getAffectedFiguresCount() {
        return this.getReversedActivity().getAffectedFiguresCount();
    }

    public DrawingView getDrawingView() {
        return this.getReversedActivity().getDrawingView();
    }

    public void release() {
        this.getReversedActivity().release();
    }

    protected void setReversedActivity(Undoable undoable) {
        this.myReversedActivity = undoable;
    }

    public Undoable getReversedActivity() {
        return this.myReversedActivity;
    }

    public static Undoable createUndoRedoActivity(Undoable undoable) {
        if (undoable instanceof UndoRedoActivity) {
            return ((UndoRedoActivity)undoable).getReversedActivity();
        }
        return new UndoRedoActivity(undoable);
    }
}

