/*
 * Decompiled with CFR 0.152.
 */
package sttp.monad;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sttp.monad.Canceler;
import sttp.monad.MonadAsyncError;

public class FutureMonad
implements MonadAsyncError<Future> {
    private final ExecutionContext ec;

    public FutureMonad(ExecutionContext ec) {
        this.ec = ec;
    }

    @Override
    public <T> Future<T> unit(T t) {
        return Future$.MODULE$.successful(t);
    }

    @Override
    public <T, T2> Future<T2> map(Future<T> fa, Function1<T, T2> f) {
        return fa.map(f, this.ec);
    }

    @Override
    public <T, T2> Future<T2> flatMap(Future<T> fa, Function1<T, Future<T2>> f) {
        return fa.flatMap(f, this.ec);
    }

    @Override
    public <T> Future<T> error(Throwable t) {
        return Future$.MODULE$.failed(t);
    }

    @Override
    public <T> Future<T> handleWrappedError(Future<T> rt, PartialFunction<Throwable, Future<T>> h) {
        return rt.recoverWith(h, this.ec);
    }

    @Override
    public <T> Future<T> eval(Function0<T> t) {
        return Future$.MODULE$.apply(t, this.ec);
    }

    @Override
    public <T> Future<T> suspend(Function0<Future<T>> t) {
        return Future$.MODULE$.apply(t, this.ec).flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), this.ec);
    }

    @Override
    public <T> Future<T> fromTry(Try<T> t) {
        return Future$.MODULE$.fromTry(t);
    }

    @Override
    public <T> Future<T> async(Function1<Function1<Either<Throwable, T>, BoxedUnit>, Canceler> register) {
        Promise p = Promise$.MODULE$.apply();
        register.apply((JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Throwable t = (Throwable)((Left)either).value();
                p.failure(t);
                return;
            }
            if (either instanceof Right) {
                Object t = ((Right)either).value();
                p.success(t);
                return;
            }
            throw new MatchError((Object)either);
        });
        return p.future();
    }

    @Override
    public <T> Future<T> ensure(Future<T> f, Function0<Future<BoxedUnit>> e) {
        return this.ensure2((Function0<Future<T>>)((Function0 & Serializable)() -> FutureMonad.ensure$$anonfun$3(f)), e);
    }

    @Override
    public <T> Future<T> ensure2(Function0<Future<T>> f, Function0<Future<BoxedUnit>> e) {
        Promise p = Promise$.MODULE$.apply();
        try {
            ((Future)f.apply()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    Object v = ((Success)try_).value();
                    FutureMonad.runE$2(e).map((Function1 & Serializable)_$13 -> v, this.ec).onComplete((Function1 & Serializable)_$14 -> p.complete(_$14), this.ec);
                    return;
                }
                if (try_ instanceof Failure) {
                    Throwable f = ((Failure)try_).exception();
                    FutureMonad.runE$2(e).flatMap((Function1 & Serializable)_$15 -> Future$.MODULE$.failed(f), this.ec).onComplete((Function1 & Serializable)_$16 -> p.complete(_$16), this.ec);
                    return;
                }
                throw new MatchError((Object)try_);
            }, this.ec);
        }
        catch (Throwable t) {
            ((Future)e.apply()).onComplete((Function1 & Serializable)_$17 -> p.complete((Try)Failure$.MODULE$.apply(t)), this.ec);
        }
        return p.future();
    }

    @Override
    public <T> Future<T> blocking(Function0<T> t) {
        return Future$.MODULE$.apply(() -> FutureMonad.blocking$$anonfun$1(t), this.ec);
    }

    private static final Future ensure$$anonfun$3(Future f$6) {
        return f$6;
    }

    private static final Future runE$2(Function0 e$2) {
        Try try_ = Try$.MODULE$.apply(e$2);
        if (try_ instanceof Failure) {
            Throwable f = ((Failure)try_).exception();
            return Future$.MODULE$.failed(f);
        }
        if (try_ instanceof Success) {
            Future v = (Future)((Success)try_).value();
            return v;
        }
        throw new MatchError((Object)try_);
    }

    private static final Object blocking$$anonfun$1(Function0 t$4) {
        return package$.MODULE$.blocking(t$4);
    }
}

