/*
 * Decompiled with CFR 0.152.
 */
import com.wolfram.jlink.Expr;
import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.nlogo.api.Exceptions;
import org.nlogo.api.LogoException;
import org.nlogo.app.App;
import org.nlogo.core.CompilerException;
import org.nlogo.core.LogoList;
import org.nlogo.headless.HeadlessWorkspace;
import org.nlogo.workspace.Controllable;

public class NLink {
    private String modelLocation;
    private Controllable workspace = null;
    private IOException caughtEx = null;
    private boolean isGUIworkspace;

    public NLink(boolean isGUImode) {
        this.isGUIworkspace = isGUImode;
        if (isGUImode) {
            App.main((String[])new String[0]);
            this.workspace = App.app();
            Exceptions.setHandler((Exceptions.Handler)new Exceptions.Handler(){

                public void handle(Throwable t) {
                    throw new RuntimeException(t.getMessage());
                }
            });
        } else {
            this.workspace = HeadlessWorkspace.newInstance();
        }
    }

    public void loadModel(final String path) throws IOException, LogoException, CompilerException, InterruptedException {
        this.caughtEx = null;
        if (this.isGUIworkspace) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            App.app().open(path, true);
                        }
                        catch (IOException ex) {
                            NLink.this.caughtEx = ex;
                        }
                    }
                });
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            if (this.caughtEx != null) {
                throw this.caughtEx;
            }
        } else {
            try {
                if (this.workspace != null) {
                    ((HeadlessWorkspace)this.workspace).dispose();
                }
                this.workspace = HeadlessWorkspace.newInstance();
                this.workspace.open(path, true);
            }
            catch (IOException ex) {
                if (this.workspace != null) {
                    ((HeadlessWorkspace)this.workspace).dispose();
                }
                this.workspace = HeadlessWorkspace.newInstance();
                throw ex;
            }
        }
    }

    public Expr report(String s) throws LogoException, CompilerException {
        return this.logoToExpr(this.workspace.report(s));
    }

    public Expr report(String[] s) throws LogoException, CompilerException {
        Expr[] results = new Expr[s.length];
        for (int i = 0; i < s.length; ++i) {
            results[i] = this.logoToExpr(this.workspace.report(s[i]));
        }
        return new Expr(new Expr(4, "List"), results);
    }

    public void command(String s) throws LogoException, CompilerException {
        this.workspace.command(s);
    }

    public void command(String[] s) throws LogoException, CompilerException {
        for (int i = 0; i < s.length; ++i) {
            this.workspace.command(s[i]);
        }
    }

    public Expr doReport(String s, String var, int repeats) throws LogoException, CompilerException {
        Expr[] results = new Expr[repeats];
        for (int i = 0; i < repeats; ++i) {
            this.workspace.command(s);
            results[i] = this.report(var);
        }
        return new Expr(new Expr(4, "List"), results);
    }

    public Expr doReport(String s, String[] vars, int repeats) throws LogoException, CompilerException {
        Expr[] results = new Expr[repeats];
        for (int i = 0; i < repeats; ++i) {
            this.workspace.command(s);
            results[i] = this.report(vars);
        }
        return new Expr(new Expr(4, "List"), results);
    }

    public Expr doReportWhile(String s, String var, String condition) throws LogoException, CompilerException {
        ArrayList<Expr> varList = new ArrayList<Expr>();
        int i = 0;
        while (((Boolean)this.workspace.report(condition)).booleanValue()) {
            this.workspace.command(s);
            varList.add(this.report(var));
            ++i;
        }
        Object[] objArray = varList.toArray();
        Expr[] exprArray = new Expr[objArray.length];
        for (int j = 0; j < exprArray.length; ++j) {
            exprArray[j] = (Expr)objArray[j];
        }
        return new Expr(new Expr(4, "List"), exprArray);
    }

    public Expr doReportWhile(String s, String[] vars, String condition) throws LogoException, CompilerException {
        ArrayList<Expr> varList = new ArrayList<Expr>();
        int i = 0;
        while (((Boolean)this.workspace.report(condition)).booleanValue()) {
            this.workspace.command(s);
            varList.add(this.report(vars));
            ++i;
        }
        Object[] objArray = varList.toArray();
        Expr[] exprArray = new Expr[objArray.length];
        for (int j = 0; j < exprArray.length; ++j) {
            exprArray[j] = (Expr)objArray[j];
        }
        return new Expr(new Expr(4, "List"), exprArray);
    }

    private Expr NLArray(LogoList l) {
        Expr[] exprArray = new Expr[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            exprArray[i] = this.logoToExpr(l.get(i));
        }
        return new Expr(new Expr(4, "List"), exprArray);
    }

    private Expr logoToExpr(Object o) {
        if (o instanceof LogoList) {
            return this.NLArray((LogoList)o);
        }
        if (o instanceof String) {
            return new Expr((String)o);
        }
        if (o instanceof Integer) {
            return new Expr((Integer)o);
        }
        if (o instanceof Double) {
            return new Expr((Double)o);
        }
        if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                return new Expr(4, "True");
            }
            return new Expr(4, "False");
        }
        return new Expr("Unknown data type");
    }
}

