/*
 * Decompiled with CFR 0.152.
 */
package arduino;

import arduino.ErrorRecord;
import arduino.MessageParser$;
import arduino.ValuePair;
import arduino.ValuePair$;
import java.io.Serializable;
import java.util.Deque;
import java.util.Map;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class PortListener
implements SerialPortEventListener {
    private final SerialPort port;
    private final Map<String, Object> values;
    private final Deque<ErrorRecord> inboundErrors;
    private final int MaxErrorSize;
    private String residue;

    public PortListener(SerialPort port, Map<String, Object> values, Deque<ErrorRecord> inboundErrors) {
        this.port = port;
        this.values = values;
        this.inboundErrors = inboundErrors;
        this.MaxErrorSize = 10;
        this.residue = "";
    }

    public void serialEvent(SerialPortEvent event) {
        if (event.isRXCHAR()) {
            try {
                String readValue = this.port.readString();
                if (readValue != null) {
                    this.residue = this.residue + readValue;
                    Tuple2<String, Seq<Either<ErrorRecord, ValuePair>>> tuple2 = MessageParser$.MODULE$.parseStream(this.residue);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String newResidue = (String)tuple2._1();
                    Seq results = (Seq)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)newResidue, (Object)results);
                    String newResidue2 = (String)tuple22._1();
                    Seq results2 = (Seq)tuple22._2();
                    this.residue = newResidue2;
                    results2.foreach((Function1 & Serializable)x$1 -> {
                        ErrorRecord errorRecord;
                        ValuePair valuePair;
                        Either either = x$1;
                        if (either instanceof Right && (valuePair = (ValuePair)((Right)either).value()) != null) {
                            ValuePair valuePair2 = ValuePair$.MODULE$.unapply(valuePair);
                            String string = valuePair2._1();
                            Object object = valuePair2._2();
                            String key = string;
                            Object value = object;
                            return this.values.put(key, value);
                        }
                        if (either instanceof Left && (errorRecord = (ErrorRecord)((Left)either).value()) != null) {
                            ErrorRecord e = errorRecord;
                            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.inboundErrors.size() - this.MaxErrorSize).foreach((Function1 & Serializable)i -> this.serialEvent$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
                            this.inboundErrors.addFirst(e);
                            return BoxedUnit.UNIT;
                        }
                        throw new MatchError((Object)either);
                    });
                }
            }
            catch (SerialPortException s) {
                s.printStackTrace();
            }
            return;
        }
    }

    private final /* synthetic */ ErrorRecord serialEvent$$anonfun$1$$anonfun$1(int i) {
        return this.inboundErrors.removeLast();
    }
}

