/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.shapefile;

import java.util.ArrayList;
import org.myworldgis.io.shapefile.DBaseConstants;
import org.myworldgis.util.StringUtils;

public final class DBaseFieldDescriptor
implements DBaseConstants {
    private final char _type;
    private final String _name;
    private final int _length;
    private final int _decimalCount;

    public static String makeLegalFieldName(String name) {
        int i;
        StringBuffer result = new StringBuffer();
        int firstAlpha = -1;
        for (i = 0; i < name.length(); ++i) {
            if (!Character.isLetter(name.charAt(i))) continue;
            firstAlpha = i;
            break;
        }
        if (firstAlpha < 0) {
            result.append('f');
            firstAlpha = 0;
        }
        for (i = firstAlpha; i < name.length() && result.length() < 11; ++i) {
            char c = name.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_') continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String[] makeLegalFieldNames(String[] strings) {
        int i;
        int maxLen = 10;
        String[] work = new String[strings.length];
        String[] result = new String[strings.length];
        for (i = 0; i < strings.length; ++i) {
            work[i] = result[i] = StringUtils.stripNonAlphanumeric(strings[i]).toUpperCase();
        }
        block1: for (i = 0; i < result.length; ++i) {
            while (result[i].length() > maxLen) {
                int j;
                int matchSize = 0;
                int[] matches = null;
                for (j = 2; j <= result[i].length(); ++j) {
                    int k;
                    String matchStr = result[i].substring(0, j);
                    ArrayList<Integer> matchList = new ArrayList<Integer>(result.length - i);
                    for (k = i + 1; k < result.length; ++k) {
                        if (result[k].length() <= maxLen || !StringUtils.startsWithIgnoreCase(result[k], matchStr)) continue;
                        matchList.add(k);
                    }
                    if (matchList.size() <= 0) break;
                    matchSize = matchStr.length();
                    matches = new int[matchList.size()];
                    for (k = 0; k < matchList.size(); ++k) {
                        matches[k] = (Integer)matchList.get(k);
                    }
                }
                if (matches == null) continue block1;
                result[i] = result[i].substring(matchSize);
                for (j = 0; j < matches.length; ++j) {
                    result[matches[j]] = result[matches[j]].substring(matchSize);
                }
            }
        }
        for (i = 0; i < result.length; ++i) {
            if (result[i].length() > maxLen) {
                result[i] = result[i].substring(0, maxLen);
                continue;
            }
            if (work[i].length() <= maxLen || result[i].length() >= maxLen) continue;
            result[i] = work[i].substring(0, maxLen - result[i].length()) + result[i];
        }
        return result;
    }

    public DBaseFieldDescriptor(char type, String name, int length, int decimalCount) {
        this._type = type;
        this._name = DBaseFieldDescriptor.makeLegalFieldName(name);
        this._length = length;
        this._decimalCount = decimalCount;
    }

    public char getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public int getLength() {
        return this._length;
    }

    public int getDecimalCount() {
        return this._decimalCount;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBaseFieldDescriptor) {
            DBaseFieldDescriptor dfd = (DBaseFieldDescriptor)obj;
            return dfd._type == this._type && dfd._name.equals(this._name) && dfd._length == this._length && dfd._decimalCount == this._decimalCount;
        }
        return false;
    }

    public int hashCode() {
        return (int)(Math.pow(2.0, this._type) * Math.pow(3.0, this._name.hashCode()) * Math.pow(5.0, this._length) * Math.pow(7.0, this._decimalCount) % 2.147483647E9);
    }
}

