/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.shapefile;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.myworldgis.io.shapefile.DBaseBuffer;
import org.myworldgis.io.shapefile.DBaseConstants;
import org.myworldgis.io.shapefile.DBaseFieldDescriptor;
import org.nlogo.core.Syntax;

public final class DBaseFileReader
implements DBaseConstants {
    private InputStream _in;
    private DBaseBuffer _buffer;
    private DBaseFieldDescriptor[] _fieldDescriptors;
    private int _recordCount;
    private int _recordLength;

    public DBaseFileReader(InputStream in) throws IOException {
        this._in = in;
        this._buffer = new DBaseBuffer();
        this._buffer.read(this._in, 0, 10);
        int headerSize = this._buffer.getShort(8);
        int headerBytes = headerSize - 10;
        int headerBytesRead = this._buffer.read(this._in, 10, headerBytes);
        if (headerBytesRead < headerBytes) {
            throw new EOFException();
        }
        byte fileCode = this._buffer.getByte(0);
        if (fileCode != 3) {
            throw new IOException("invalid file code " + fileCode + ", probably not a dBase file");
        }
        this._recordCount = this._buffer.getInt(4);
        this._recordLength = this._buffer.getShort(10);
        ArrayList<DBaseFieldDescriptor> fieldList = new ArrayList<DBaseFieldDescriptor>();
        for (int offset = 32; offset < headerSize && this._buffer.getByte(offset) != 13; offset += 32) {
            fieldList.add(this._buffer.getFieldDescriptor(offset));
        }
        this._fieldDescriptors = fieldList.toArray(new DBaseFieldDescriptor[fieldList.size()]);
        this._buffer.ensureCapacity(this._recordLength);
    }

    public int getFieldCount() {
        return this._fieldDescriptors.length;
    }

    public String getFieldName(int index) {
        return this._fieldDescriptors[index].getName();
    }

    public DBaseFieldDescriptor getField(int index) {
        return this._fieldDescriptors[index];
    }

    public int getFieldDataType(int index) {
        switch (this._fieldDescriptors[index].getType()) {
            case 'C': 
            case 'D': {
                return Syntax.StringType();
            }
            case 'F': 
            case 'N': {
                return Syntax.NumberType();
            }
            case 'L': {
                return Syntax.BooleanType();
            }
        }
        return Syntax.NobodyType();
    }

    public int getRecordCount() {
        return this._recordCount;
    }

    public Object[] getNextRecord() throws IOException {
        this._buffer.read(this._in, 0, this._recordLength);
        return this._buffer.getRecord(0, this._fieldDescriptors);
    }

    public void close() throws IOException {
        this._in.close();
    }
}

