/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.netlogo.VectorFeature;
import org.myworldgis.util.JTSUtils;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentException;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.Patch;
import org.nlogo.api.World;
import org.nlogo.core.LogoList;
import org.nlogo.core.Reference;
import org.nlogo.core.Referenceable;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public abstract class ApplyCoverage {
    static void applyCoverages(World world, VectorDataset dataset, String[] properties, Reference[] variables) throws AgentException, ExtensionException, LogoException {
        for (int i = 0; i < properties.length; ++i) {
            if (dataset.isValidPropertyName(properties[i])) continue;
            throw new ExtensionException(properties[i] + " is not a valid property name");
        }
        double singleCellThreshold = GISExtension.getState().getCoverageSingleCellThreshold();
        for (int px = world.minPxcor(); px <= world.maxPxcor(); ++px) {
            for (int py = world.minPycor(); py <= world.maxPycor(); ++py) {
                Patch p = world.fastGetPatchAt(px, py);
                Geometry patchGeometry = GISExtension.getState().agentGeometry((Agent)p);
                List<VectorFeature> features = dataset.intersectingFeatures(patchGeometry);
                if (features.size() > 1) {
                    Object[] values = ApplyCoverage.aggregatePropertyValues(patchGeometry, properties, features);
                    for (int i = 0; i < properties.length; ++i) {
                        p.setVariable(variables[i].vn(), values[i]);
                    }
                    continue;
                }
                if (features.size() == 1 && JTSUtils.fastGetSharedAreaRatio(patchGeometry, features.get(0).getGeometry()) > singleCellThreshold) {
                    for (int i = 0; i < properties.length; ++i) {
                        p.setVariable(variables[i].vn(), features.get(0).getProperty(properties[i]));
                    }
                    continue;
                }
                for (int i = 0; i < properties.length; ++i) {
                    p.setVariable(variables[i].vn(), (Object)GISExtension.MISSING_VALUE);
                }
            }
        }
    }

    static Object[] aggregatePropertyValues(Geometry patchGeometry, String[] propertyNames, List<VectorFeature> features) {
        Object value;
        int j;
        double areaRatio;
        Geometry geom;
        VectorFeature feature;
        int i;
        int maxAreaIndex = -1;
        double maxAreaRatio = 0.0;
        ValueRecord[][] records = new ValueRecord[propertyNames.length][features.size()];
        boolean[] categoricalProperty = new boolean[propertyNames.length];
        Arrays.fill(categoricalProperty, false);
        for (i = 0; i < features.size(); ++i) {
            feature = features.get(i);
            geom = feature.getGeometry();
            areaRatio = JTSUtils.fastGetSharedAreaRatio(patchGeometry, geom);
            if (areaRatio > maxAreaRatio) {
                maxAreaIndex = i;
                maxAreaRatio = areaRatio;
            }
            for (j = 0; j < propertyNames.length; ++j) {
                value = feature.getProperty(propertyNames[j]);
                if (value instanceof String) {
                    categoricalProperty[j] = true;
                }
                records[j][i] = new ValueRecord(value, areaRatio);
            }
        }
        if (maxAreaRatio == 0.0) {
            for (i = 0; i < features.size(); ++i) {
                feature = features.get(i);
                geom = feature.getGeometry();
                areaRatio = JTSUtils.getSharedAreaRatio(patchGeometry, geom);
                if (areaRatio > maxAreaRatio) {
                    maxAreaIndex = i;
                    maxAreaRatio = areaRatio;
                }
                for (j = 0; j < propertyNames.length; ++j) {
                    value = feature.getProperty(propertyNames[j]);
                    if (value instanceof String) {
                        categoricalProperty[j] = true;
                    }
                    records[j][i] = new ValueRecord(value, areaRatio);
                }
            }
        }
        Object[] result = new Object[propertyNames.length];
        if (maxAreaRatio == 0.0) {
            for (int j2 = 0; j2 < propertyNames.length; ++j2) {
                result[j2] = GISExtension.MISSING_VALUE;
            }
        } else if (maxAreaRatio >= GISExtension.getState().getCoverageMultipleCellThreshold()) {
            for (int j3 = 0; j3 < propertyNames.length; ++j3) {
                result[j3] = records[j3][maxAreaIndex].getValue();
            }
        } else {
            for (int j4 = 0; j4 < propertyNames.length; ++j4) {
                result[j4] = categoricalProperty[j4] ? ApplyCoverage.majority(records[j4]) : ApplyCoverage.weightedAverage(records[j4]);
            }
        }
        return result;
    }

    static Object majority(ValueRecord[] records) {
        HashMap<Object, Double> map = new HashMap<Object, Double>();
        double maxWeight = 0.0;
        Object maxWeightValue = null;
        for (int i = 0; i < records.length; ++i) {
            Object value = records[i].getValue();
            if (value == null) continue;
            Double weight = (Double)map.get(value);
            weight = weight == null ? Double.valueOf(records[i].getWeight()) : Double.valueOf(weight + records[i].getWeight());
            if (weight > maxWeight) {
                maxWeight = weight;
                maxWeightValue = value;
            }
            map.put(value, weight);
        }
        return maxWeightValue;
    }

    static Object weightedAverage(ValueRecord[] records) {
        double totalValue = 0.0;
        double totalWeight = 0.0;
        for (int i = 0; i < records.length; ++i) {
            double value;
            Number n = (Number)records[i].getValue();
            if (n == null || Double.isNaN(value = n.doubleValue()) || Double.isInfinite(value)) continue;
            double weight = records[i].getWeight();
            totalValue += value * weight;
            totalWeight += weight;
        }
        return totalValue / totalWeight;
    }

    private static final class ValueRecord {
        private Object _value;
        private double _areaRatio;

        public ValueRecord(Object value, double areaRatio) {
            this._value = value;
            this._areaRatio = areaRatio;
        }

        public Object getValue() {
            return this._value;
        }

        public double getWeight() {
            return this._areaRatio;
        }
    }

    public static final class SetCoverageMaximumThreshold
    extends GISExtension.Command {
        public String getAgentClassString() {
            return "O";
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.NumberType()});
        }

        @Override
        public void performInternal(Argument[] args, Context context) throws AgentException, ExtensionException, LogoException {
            GISExtension.getState().setCoverageMultipleCellThreshold(args[0].getDoubleValue());
        }
    }

    public static final class GetCoverageMaximumThreshold
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "O";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[0], (int)Syntax.NumberType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws AgentException, ExtensionException, LogoException {
            return GISExtension.getState().getCoverageMultipleCellThreshold();
        }
    }

    public static final class SetCoverageMinimumThreshold
    extends GISExtension.Command {
        public String getAgentClassString() {
            return "O";
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.NumberType()});
        }

        @Override
        public void performInternal(Argument[] args, Context context) throws AgentException, ExtensionException, LogoException {
            GISExtension.getState().setCoverageSingleCellThreshold(args[0].getDoubleValue());
        }
    }

    public static final class GetCoverageMinimumThreshold
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "O";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[0], (int)Syntax.NumberType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws AgentException, ExtensionException, LogoException {
            return GISExtension.getState().getCoverageSingleCellThreshold();
        }
    }

    public static final class MultiplePolygonFields
    extends GISExtension.Command {
        public String getAgentClassString() {
            return "O";
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.ListType(), Syntax.ReferenceType() | Syntax.RepeatableType()}, (int)3);
        }

        @Override
        public void performInternal(Argument[] args, Context context) throws AgentException, ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof VectorDataset)) {
                throw new ExtensionException("not a VectorDataset: " + arg0);
            }
            int propertyCount = args.length - 2;
            LogoList arg1 = args[1].getList();
            if (arg1.size() != propertyCount) {
                throw new ExtensionException("number of properties must match the number of patch variables");
            }
            String[] properties = new String[arg1.size()];
            int idx = 0;
            Iterator i = arg1.javaIterator();
            while (i.hasNext()) {
                properties[idx++] = (String)i.next();
            }
            Reference[] variables = new Reference[propertyCount];
            for (int i2 = 0; i2 < propertyCount; ++i2) {
                variables[i2] = ((Referenceable)((org.nlogo.nvm.Argument)args[i2 + 2]).getReference()).makeReference();
            }
            ApplyCoverage.applyCoverages(context.getAgent().world(), (VectorDataset)arg0, properties, variables);
        }
    }

    public static final class SinglePolygonField
    extends GISExtension.Command {
        public String getAgentClassString() {
            return "O";
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType(), Syntax.ReferenceType()});
        }

        @Override
        public void performInternal(Argument[] args, Context context) throws AgentException, ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof VectorDataset)) {
                throw new ExtensionException("not a VectorDataset: " + arg0);
            }
            ApplyCoverage.applyCoverages(context.getAgent().world(), (VectorDataset)arg0, new String[]{args[1].getString()}, new Reference[]{((org.nlogo.nvm.Argument)args[2]).getReference()});
        }
    }
}

