/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import java.text.ParseException;
import java.util.Iterator;
import java.util.ListIterator;
import org.myworldgis.projection.Projection;
import org.myworldgis.projection.ProjectionFormat;
import org.myworldgis.wkt.WKTElement;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.LogoList;

public final class WKLogoListFormat {
    private static final WKLogoListFormat _instance = new WKLogoListFormat();

    public static WKLogoListFormat getInstance() {
        return _instance;
    }

    private WKLogoListFormat() {
    }

    public Projection parseProjection(LogoList wkList) throws ParseException {
        return ProjectionFormat.getInstance().parseProjection(this.parseWKT(wkList));
    }

    public WKTElement parseWKT(LogoList wkList) throws ParseException {
        WKTElement result = new WKTElement((String)wkList.first());
        ListIterator iterator = wkList.listIterator(1);
        while (iterator.hasNext()) {
            Object elt = iterator.next();
            if (elt instanceof LogoList) {
                result.addContent(this.parseWKT((LogoList)elt));
                continue;
            }
            result.addContent(elt);
        }
        return result;
    }

    public LogoList format(Projection proj) {
        return this.format(ProjectionFormat.getInstance().toWKT(proj));
    }

    public LogoList format(WKTElement wkt) {
        LogoListBuilder result = new LogoListBuilder();
        result.add((Object)wkt.getKeyword());
        Iterator<Object> iterator = wkt.iterator();
        while (iterator.hasNext()) {
            Object elt = iterator.next();
            if (elt instanceof WKTElement) {
                result.add((Object)this.format((WKTElement)elt));
                continue;
            }
            result.add(elt);
        }
        return result.toLogoList();
    }
}

