/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import java.text.ParseException;
import org.locationtech.jts.geom.Coordinate;
import org.myworldgis.projection.Cylindrical;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public final class CylindricalEqualArea
extends Cylindrical {
    public static final String WKT_NAME = "Cylindrical_Equal_Area";
    public static final String CENTER_LON_PROPERTY = "central_meridian";
    public static final String CENTER_LAT_PROPERTY = "standard_parallel_1";
    private double _e;
    private double _k0;
    private double _qp;
    private double[] _subLat;

    public CylindricalEqualArea(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._name = WKT_NAME;
        this._subLat = new double[3];
        this.computeParameters();
    }

    public CylindricalEqualArea(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this._subLat = new double[3];
        this.computeParameters();
    }

    @Override
    protected Coordinate forwardPointRaw(double lon, double lat, Coordinate storage) {
        storage.x = this._a * this._k0 * GeometryUtils.wrap_longitude(lon - this._lambda0);
        double sinPhi = StrictMath.sin(lat);
        double q = (1.0 - this._e2) * (sinPhi / (1.0 - this._e2 * sinPhi * sinPhi) - 1.0 / (2.0 * this._e) * StrictMath.log((1.0 - this._e * sinPhi) / (1.0 + this._e * sinPhi)));
        storage.y = this._a * q / (2.0 * this._k0);
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        storage.x = this._lambda0 + x / (this._a * this._k0);
        double beta = StrictMath.asin(2.0 * y * this._k0 / (this._a * this._qp));
        storage.y = beta + this._subLat[0] * StrictMath.sin(2.0 * beta) + this._subLat[1] * StrictMath.sin(4.0 * beta) + this._subLat[2] * StrictMath.sin(6.0 * beta);
        return storage;
    }

    @Override
    protected void computeParameters() {
        this._e = StrictMath.sqrt(this._e2);
        double sinPhi0 = StrictMath.sin(this._phi0);
        this._k0 = StrictMath.cos(this._phi0) / StrictMath.sqrt(1.0 - this._e2 * sinPhi0 * sinPhi0);
        this._qp = (1.0 - this._e2) * (1.0 / (1.0 - this._e2) - 1.0 / (2.0 * this._e) * StrictMath.log((1.0 - this._e) / (1.0 + this._e)));
        this._subLat[0] = this._e2 / 3.0 + 31.0 * this._e2 * this._e2 / 180.0 + 517.0 * this._e2 * this._e2 * this._e2 / 5040.0;
        this._subLat[1] = 23.0 * this._e2 * this._e2 / 360.0 + 251.0 * this._e2 * this._e2 * this._e2 / 3780.0;
        this._subLat[2] = 761.0 * this._e2 * this._e2 * this._e2 / 45360.0;
        super.computeParameters();
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        return result;
    }

    @Override
    public Object clone() {
        CylindricalEqualArea clone = (CylindricalEqualArea)super.clone();
        clone._subLat = (double[])this._subLat.clone();
        return clone;
    }
}

