/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import java.text.ParseException;
import org.locationtech.jts.geom.Coordinate;
import org.myworldgis.projection.Azimuthal;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public final class Stereographic
extends Azimuthal {
    public static final String WKT_NAME = "Stereographic";
    public static final String CENTER_LON_PROPERTY = "central_meridian";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_origin";
    public static final String SCALE_FACTOR_PROPERTY = "scale_factor";
    private double _k0;

    public Stereographic(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        this(ellipsoid, center, units, falseEasting, falseNorthing, 1.0);
    }

    public Stereographic(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing, double k0) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._name = WKT_NAME;
        this._k0 = k0;
        this.computeParameters();
    }

    public Stereographic(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this._k0 = parameters.getDimensionlessParameter(SCALE_FACTOR_PROPERTY);
        this.computeParameters();
    }

    public double getCenterScaleFactor() {
        return this._k0;
    }

    public void setCenterScaleFactor(double newScale) {
        if (newScale != this._k0) {
            this._k0 = newScale;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Stereographic proj = (Stereographic)obj;
            return StrictMath.abs(proj._k0 - this._k0) < 1.567855942887398E-7;
        }
        return false;
    }

    public int hashCode() {
        return (int)((long)super.hashCode() * Math.round(this._k0 / 1.567855942887398E-7) % Integer.MAX_VALUE);
    }

    @Override
    protected double getMaxC() {
        return 1.5707963267948966;
    }

    @Override
    protected Coordinate forwardPointRaw(double lon, double lat, Coordinate storage) {
        double sinPhi = StrictMath.sin(lat);
        double cosPhi = StrictMath.cos(lat);
        double cosLonMinusLambda0 = StrictMath.cos(lon - this._lambda0);
        double k = 2.0 * this._k0 / (1.0 + this._sinPhi0 * sinPhi + this._cosPhi0 * cosPhi * cosLonMinusLambda0);
        storage.x = this._a * k * cosPhi * StrictMath.sin(lon - this._lambda0);
        storage.y = this._a * k * (this._cosPhi0 * sinPhi - this._sinPhi0 * cosPhi * cosLonMinusLambda0);
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        double rho = StrictMath.sqrt(x * x + y * y);
        if (rho == 0.0) {
            storage.x = this._lambda0;
            storage.y = this._phi0;
        } else {
            double c = 2.0 * StrictMath.atan(rho / (2.0 * this._a * this._k0));
            double sinC = StrictMath.sin(c);
            double cosC = StrictMath.cos(c);
            storage.x = this._phi0 == 1.5707963267948966 ? this._lambda0 + StrictMath.atan2(x, -y) : (this._phi0 == -1.5707963267948966 ? this._lambda0 + StrictMath.atan2(x, y) : this._lambda0 + StrictMath.atan2(x * sinC, rho * this._cosPhi0 * cosC - y * this._sinPhi0 * sinC));
            storage.y = StrictMath.asin(cosC * this._sinPhi0 + y * sinC * this._cosPhi0 / rho);
        }
        return storage;
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        result.addDimensionlessParameter(SCALE_FACTOR_PROPERTY, this._k0);
        return result;
    }
}

