/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import java.awt.Dimension;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.locationtech.jts.geom.Envelope;
import org.myworldgis.util.StringUtils;

public class URLBuilder {
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#########0.#####");
    private String baseUrl;
    private Map<String, String> queryVars;

    public URLBuilder(String base) {
        try {
            URI uri = new URI(base);
            URI baseUri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null);
            this.baseUrl = baseUri.toString();
            this.queryVars = new HashMap<String, String>();
            if (uri.getQuery() != null && uri.getQuery().length() > 0) {
                String[] queryParts = uri.getQuery().split("&");
                for (int i = 0; i < queryParts.length; ++i) {
                    String[] queryVar = queryParts[i].split("=");
                    this.queryVars.put(queryVar[0], queryVar[1]);
                }
            }
        }
        catch (URISyntaxException e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public void setParameter(String key, String value) {
        this.queryVars.put(key, value);
    }

    public void setParameter(String key, Dimension value) {
        StringBuffer dim = new StringBuffer();
        dim.append(value.width);
        dim.append(",");
        dim.append(value.height);
        this.queryVars.put(key, dim.toString());
    }

    public void setParameter(String key, Envelope value) {
        StringBuffer bbox = new StringBuffer();
        bbox.append(NUMBER_FORMAT.format(value.getMinX()));
        bbox.append(",");
        bbox.append(NUMBER_FORMAT.format(value.getMinY()));
        bbox.append(",");
        bbox.append(NUMBER_FORMAT.format(value.getMaxX()));
        bbox.append(",");
        bbox.append(NUMBER_FORMAT.format(value.getMaxY()));
        this.queryVars.put(key, bbox.toString());
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.baseUrl);
        result.append("?");
        Iterator<String> e = this.queryVars.keySet().iterator();
        while (e.hasNext()) {
            String key = e.next();
            result.append(key);
            result.append("=");
            result.append(this.queryVars.get(key));
            if (!e.hasNext()) continue;
            result.append("&");
        }
        return StringUtils.encodeURL(result.toString());
    }
}

