// Generated by delombok at Fri Apr 19 18:23:12 UTC 2024
/*
 * Matomo Java Tracker
 *
 * @link https://github.com/matomo/matomo-java-tracker
 * @license https://github.com/matomo/matomo-java-tracker/blob/master/LICENSE BSD-3 Clause
 */
package org.matomo.java.tracking;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import lombok.NonNull;

final class TrackingParameterMethod {
  private final String parameterName;
  private final Method method;
  private final Pattern pattern;
  private final double min;
  private final double max;
  private final int maxLength;

  void validateParameterValue(@NonNull Object parameterValue) {
    if (parameterValue == null) {
      throw new java.lang.NullPointerException("parameterValue is marked non-null but is null");
    }
    if (pattern != null && parameterValue instanceof CharSequence && !pattern.matcher((CharSequence) parameterValue).matches()) {
      throw new MatomoException(String.format("Invalid value for %s. Must match regex %s", parameterName, pattern));
    }
    if (maxLength != 0 && parameterValue.toString().length() > maxLength) {
      throw new MatomoException(String.format("Invalid value for %s. Must be less or equal than %d characters", parameterName, maxLength));
    }
    if (parameterValue instanceof Number) {
      Number number = (Number) parameterValue;
      if (number.doubleValue() < min) {
        throw new MatomoException(String.format("Invalid value for %s. Must be greater or equal than %s", parameterName, min % 1 == 0 ? Long.toString((long) min) : min));
      }
      if (number.doubleValue() > max) {
        throw new MatomoException(String.format("Invalid value for %s. Must be less or equal than %s", parameterName, max % 1 == 0 ? Long.toString((long) max) : max));
      }
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  TrackingParameterMethod(final String parameterName, final Method method, final Pattern pattern, final double min, final double max, final int maxLength) {
    this.parameterName = parameterName;
    this.method = method;
    this.pattern = pattern;
    this.min = min;
    this.max = max;
    this.maxLength = maxLength;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class TrackingParameterMethodBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String parameterName;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Method method;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Pattern pattern;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private double min;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private double max;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private int maxLength;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    TrackingParameterMethodBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackingParameterMethod.TrackingParameterMethodBuilder parameterName(final String parameterName) {
      this.parameterName = parameterName;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackingParameterMethod.TrackingParameterMethodBuilder method(final Method method) {
      this.method = method;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackingParameterMethod.TrackingParameterMethodBuilder pattern(final Pattern pattern) {
      this.pattern = pattern;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackingParameterMethod.TrackingParameterMethodBuilder min(final double min) {
      this.min = min;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackingParameterMethod.TrackingParameterMethodBuilder max(final double max) {
      this.max = max;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackingParameterMethod.TrackingParameterMethodBuilder maxLength(final int maxLength) {
      this.maxLength = maxLength;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrackingParameterMethod build() {
      return new TrackingParameterMethod(this.parameterName, this.method, this.pattern, this.min, this.max, this.maxLength);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "TrackingParameterMethod.TrackingParameterMethodBuilder(parameterName=" + this.parameterName + ", method=" + this.method + ", pattern=" + this.pattern + ", min=" + this.min + ", max=" + this.max + ", maxLength=" + this.maxLength + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static TrackingParameterMethod.TrackingParameterMethodBuilder builder() {
    return new TrackingParameterMethod.TrackingParameterMethodBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getParameterName() {
    return this.parameterName;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Method getMethod() {
    return this.method;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Pattern getPattern() {
    return this.pattern;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public double getMin() {
    return this.min;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public double getMax() {
    return this.max;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getMaxLength() {
    return this.maxLength;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof TrackingParameterMethod)) return false;
    final TrackingParameterMethod other = (TrackingParameterMethod) o;
    if (java.lang.Double.compare(this.getMin(), other.getMin()) != 0) return false;
    if (java.lang.Double.compare(this.getMax(), other.getMax()) != 0) return false;
    if (this.getMaxLength() != other.getMaxLength()) return false;
    final java.lang.Object this$parameterName = this.getParameterName();
    final java.lang.Object other$parameterName = other.getParameterName();
    if (this$parameterName == null ? other$parameterName != null : !this$parameterName.equals(other$parameterName)) return false;
    final java.lang.Object this$method = this.getMethod();
    final java.lang.Object other$method = other.getMethod();
    if (this$method == null ? other$method != null : !this$method.equals(other$method)) return false;
    final java.lang.Object this$pattern = this.getPattern();
    final java.lang.Object other$pattern = other.getPattern();
    if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) return false;
    return true;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final long $min = java.lang.Double.doubleToLongBits(this.getMin());
    result = result * PRIME + (int) ($min >>> 32 ^ $min);
    final long $max = java.lang.Double.doubleToLongBits(this.getMax());
    result = result * PRIME + (int) ($max >>> 32 ^ $max);
    result = result * PRIME + this.getMaxLength();
    final java.lang.Object $parameterName = this.getParameterName();
    result = result * PRIME + ($parameterName == null ? 43 : $parameterName.hashCode());
    final java.lang.Object $method = this.getMethod();
    result = result * PRIME + ($method == null ? 43 : $method.hashCode());
    final java.lang.Object $pattern = this.getPattern();
    result = result * PRIME + ($pattern == null ? 43 : $pattern.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "TrackingParameterMethod(parameterName=" + this.getParameterName() + ", method=" + this.getMethod() + ", pattern=" + this.getPattern() + ", min=" + this.getMin() + ", max=" + this.getMax() + ", maxLength=" + this.getMaxLength() + ")";
  }
}
