// Generated by delombok at Fri Apr 19 18:23:12 UTC 2024
/*
 * Matomo Java Tracker
 *
 * @link https://github.com/matomo/matomo-java-tracker
 * @license https://github.com/matomo/matomo-java-tracker/blob/master/LICENSE BSD-3 Clause
 */
package org.matomo.java.tracking.parameters;

import edu.umd.cs.findbugs.annotations.Nullable;

/**
 * The resolution (width and height) of the user's output device (monitor / phone).
 */
public class DeviceResolution {
  private final int width;
  private final int height;

  /**
   * Creates a device resolution from a string representation.
   *
   * <p>The string must be in the format "widthxheight", e.g. "1920x1080".
   *
   * @param deviceResolution The string representation of the device resolution, e.g. "1920x1080"
   * @return The device resolution representation
   */
  @Nullable
  public static DeviceResolution fromString(@Nullable String deviceResolution) {
    if (deviceResolution == null || deviceResolution.trim().isEmpty()) {
      return null;
    }
    if (deviceResolution.length() < 3) {
      throw new IllegalArgumentException("Wrong device resolution size");
    }
    String[] dimensions = deviceResolution.split("x");
    if (dimensions.length != 2) {
      throw new IllegalArgumentException("Wrong dimension size");
    }
    return builder().width(Integer.parseInt(dimensions[0])).height(Integer.parseInt(dimensions[1])).build();
  }

  @Override
  public String toString() {
    return String.format("%dx%d", width, height);
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class DeviceResolutionBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private int width;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private int height;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    DeviceResolutionBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DeviceResolution.DeviceResolutionBuilder width(final int width) {
      this.width = width;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DeviceResolution.DeviceResolutionBuilder height(final int height) {
      this.height = height;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DeviceResolution build() {
      return new DeviceResolution(this.width, this.height);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "DeviceResolution.DeviceResolutionBuilder(width=" + this.width + ", height=" + this.height + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static DeviceResolution.DeviceResolutionBuilder builder() {
    return new DeviceResolution.DeviceResolutionBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DeviceResolution(final int width, final int height) {
    this.width = width;
    this.height = height;
  }
}
